/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.Store;
import com.caucho.server.cluster.StoreManager;
import com.caucho.util.CharBuffer;
import com.caucho.util.Crc64;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileObject
extends ClusterObject {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/FileObject"));
    private final Path _path;

    FileObject(StoreManager storeManager, Store store, String id, Path root) {
        super(storeManager, store, id);
        this._path = this.calculatePath(root, store.getId(), id);
    }

    FileObject(StoreManager storeManager, String storeId, String id, Path root) {
        super(storeManager, storeId, id);
        this._path = this.calculatePath(root, storeId, id);
    }

    Path getPath() {
        return this._path;
    }

    public ReadStream openRead() throws IOException {
        return this._path.openRead();
    }

    WriteStream openWrite() throws IOException {
        return this._path.openWrite();
    }

    public void removeImpl() {
        try {
            this._path.remove();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    Path calculatePath(Path top, String managerId, String key) {
        return FileObject.calculatePath(top, this.getServerId(), managerId, key);
    }

    static Path calculatePath(Path top, String serverId, String managerId, String key) {
        long crc = Crc64.generate(key);
        CharBuffer cb = CharBuffer.allocate();
        FileObject.addDigit(cb, crc);
        FileObject.addDigit(cb, crc >> 60);
        FileObject.addDigit(cb, crc >> 56);
        String hash = cb.close();
        managerId = serverId + '-' + managerId;
        Path parent = top.lookup(managerId).lookup(hash);
        try {
            parent.mkdirs();
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return parent.lookup(key);
    }

    private static void addDigit(CharBuffer cb, long digit) {
        if ((digit &= 0xFL) <= 9L) {
            cb.append((char)(48L + digit));
        } else {
            cb.append((char)(97L + digit - 10L));
        }
    }

    protected String getServerId() {
        return Cluster.getServerId();
    }

    public String toString() {
        return "FileObject[" + this._path + "]";
    }
}

