/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.naming.Jndi;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.FileStore;
import com.caucho.server.cluster.StoreManager;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistentStoreConfig {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/PersistentStoreConfig"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/cluster/PersistentStoreConfig"));
    private String _name = "caucho/persistent-store";
    private StoreManager _store;

    public void setJndiName(String name) {
        this._name = name;
    }

    public void setType(String type) throws ConfigException {
        Cluster cluster = Cluster.getLocal();
        if (type.equals("jdbc")) {
            try {
                Class<?> cl = Class.forName("com.caucho.server.cluster.JdbcStore");
                this._store = (StoreManager)cl.newInstance();
                if (cluster != null) {
                    cluster.setStore(this._store);
                }
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
            }
            if (this._store == null) {
                throw new ConfigException(L.l("'{0}' persistent sessions are available in Resin Professional.  See http://www.caucho.com for information and licensing.", type));
            }
        } else if (type.equals("file")) {
            this._store = new FileStore();
        } else if (type.equals("cluster") || type.equals("tcp")) {
            try {
                Class<?> cl = Class.forName("com.caucho.server.cluster.ClusterStore");
                this._store = (StoreManager)cl.newInstance();
                if (cluster != null) {
                    cluster.setStore(this._store);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                log.log(Level.FINER, e.toString(), e);
            }
            if (this._store == null) {
                throw new ConfigException(L.l("'{0}' persistent sessions are available in Resin Professional.  See http://www.caucho.com for information and licensing.", type));
            }
        }
        if (this._store == null) {
            throw new ConfigException(L.l("{0} is an unknown persistent-store type.  Only 'jdbc', 'file', and 'tcp' are allowed.", type));
        }
    }

    public StoreManager createInit() {
        return this._store;
    }

    public void init() throws Exception {
        if (this._store == null) {
            throw new ConfigException(L.l("type is a required attribute of persistent-store"));
        }
        this._store.init();
        if (this._name.startsWith("java:comp")) {
            Jndi.bindDeep(this._name, this._store);
        } else {
            Jndi.bindDeep("java:comp/env/" + this._name, this._store);
        }
    }
}

