/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.net.InetAddress;

public abstract class Connection {
    private final ReadStream _readStream = new ReadStream();
    private final WriteStream _writeStream;

    public abstract int getId();

    public abstract InetAddress getLocalAddress();

    public abstract int getLocalPort();

    public abstract InetAddress getRemoteAddress();

    public abstract int getRemotePort();

    public Connection() {
        this._readStream.setReuseBuffer(true);
        this._writeStream = new WriteStream();
        this._writeStream.setReuseBuffer(true);
    }

    public final ReadStream getReadStream() {
        return this._readStream;
    }

    public final WriteStream getWriteStream() {
        return this._writeStream;
    }

    public boolean isSecure() {
        return false;
    }

    public String getVirtualHost() {
        return null;
    }

    public String getRemoteHost() {
        return this.getRemoteAddress().getHostAddress();
    }

    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        InetAddress remote = this.getRemoteAddress();
        String name = remote.getHostAddress();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            buffer[offset + i] = (byte)name.charAt(i);
        }
        return len;
    }
}

