/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.Connection;
import com.caucho.server.connection.ToByteResponseStream;
import com.caucho.server.webapp.Application;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResponseStream
extends ToByteResponseStream {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/connection/ResponseStream"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/connection/ResponseStream"));
    private static final int _tailChunkedLength = 7;
    private static final byte[] _tailChunked = new byte[]{13, 10, 48, 13, 10, 13, 10};
    private final AbstractHttpResponse _response;
    private WriteStream _next;
    private WriteStream _cache;
    private boolean _chunkedEncoding;
    private int _bufferSize;
    private boolean _disableAutoFlush;
    private int _contentLength;
    private boolean _isFirst;
    private boolean _isDisconnected;
    private boolean _allowFlush = true;
    private boolean _isHead = false;
    private boolean _isClosed = false;
    private final byte[] _buffer = new byte[16];

    ResponseStream(AbstractHttpResponse response) {
        this._response = response;
    }

    public void init(WriteStream next) {
        this._next = next;
    }

    public void start() {
        super.start();
        this._chunkedEncoding = false;
        this._contentLength = 0;
        this._allowFlush = true;
        this._disableAutoFlush = false;
        this._isClosed = false;
        this._isHead = false;
        this._cache = null;
        this._isDisconnected = false;
        this._isFirst = true;
    }

    public boolean isCauchoResponseStream() {
        return true;
    }

    public void setCache(WriteStream cache) {
        this._cache = cache;
    }

    public boolean canWrite() {
        return true;
    }

    void setFlush(boolean flush) {
        this._allowFlush = flush;
    }

    void setDisableAutoFlush(boolean disable) {
        this._disableAutoFlush = disable;
    }

    public void setHead() {
        this._isHead = true;
        this._bufferSize = 0;
    }

    public int getContentLength() {
        return this._contentLength;
    }

    public boolean isCommitted() {
        return this._response.isHeaderWritten() || this._isClosed;
    }

    void clear() {
        this.clearBuffer();
        if (this._response.isHeaderWritten()) {
            throw new IllegalStateException(L.l("can't clear response after writing headers"));
        }
    }

    public void clearClosed() {
        this._isClosed = false;
    }

    private void writeHeaders(int length) throws IOException {
        this._chunkedEncoding = this._response.writeHeaders(this._next, length);
    }

    protected void writeNext(byte[] buf, int offset, int length, boolean isFinished) throws IOException {
        try {
            if (this._isClosed) {
                return;
            }
            if (this._isFirst) {
                if (isFinished) {
                    this.writeHeaders(this.getBufferLength());
                } else {
                    this.writeHeaders(-1);
                }
            }
            if (length == 0) {
                return;
            }
            boolean isFirst = this._isFirst;
            this._isFirst = false;
            long contentLengthHeader = this._response.getContentLengthHeader();
            if (0L < contentLengthHeader && contentLengthHeader < (long)(length + this._contentLength)) {
                for (int i = (int)((long)offset + contentLengthHeader - (long)this._contentLength); i < offset + length; ++i) {
                    byte ch = buf[i];
                    if (ch == 13 || ch == 10 || ch == 32 || ch == 9) continue;
                    CauchoRequest request = this._response.getRequest();
                    Application app = request.getApplication();
                    String graph = "";
                    if (Character.isLetterOrDigit((char)ch)) {
                        graph = "'" + (char)ch + "', ";
                    }
                    IllegalStateException exn = new IllegalStateException(L.l("{0}: tried to write {1} bytes with content-length {2} (At {3}char={4}).", request.getRequestURL(), "" + (length + this._contentLength), "" + contentLengthHeader, graph, "" + ch));
                    if (app != null) {
                        app.log(exn.getMessage(), exn);
                        break;
                    }
                    exn.printStackTrace();
                    break;
                }
                if ((length = (int)(contentLengthHeader - (long)this._contentLength)) <= 0) {
                    return;
                }
            }
            if (this._cache != null) {
                CauchoRequest req = this._response.getRequest();
                Application app = req.getApplication();
                if (app != null && app.getCacheMaxLength() < (long)this._contentLength) {
                    this._cache = null;
                    this._response.killCache();
                } else {
                    this._cache.write(buf, offset, length);
                }
            }
            if (this._next != null && !this._isHead) {
                if (!this._chunkedEncoding) {
                    this._next.write(buf, offset, length);
                } else {
                    int off = this._buffer.length;
                    this._buffer[--off] = 10;
                    this._buffer[--off] = 13;
                    for (int count = length; count > 0; count >>= 4) {
                        int digit = count & 0xF;
                        this._buffer[--off] = digit <= 9 ? (byte)(48 + digit) : (byte)(97 + digit - 10);
                    }
                    this._buffer[--off] = 10;
                    this._buffer[--off] = 13;
                    this._next.write(this._buffer, off, this._buffer.length - off);
                    this._next.write(buf, offset, length);
                }
                if (log.isLoggable(Level.FINE)) {
                    Connection conn;
                    String id = this._response.getRequest() instanceof AbstractHttpRequest ? ((conn = ((AbstractHttpRequest)this._response.getRequest()).getConnection()) != null ? String.valueOf(conn.getId()) : "jni") : "inc";
                    log.fine("[" + id + "] chunk: " + length);
                }
            }
            if (!this._isDisconnected) {
                this._contentLength += length;
            }
        }
        catch (ClientDisconnectException e) {
            this._response.killCache();
            if (this._response.isIgnoreClientDisconnect()) {
                this._isDisconnected = true;
            }
            throw e;
        }
    }

    public void flush() throws IOException {
        try {
            if (this._allowFlush && !this._isClosed) {
                this.flushBuffer();
                if (this._next != null) {
                    this._next.flush();
                }
            }
        }
        catch (ClientDisconnectException e) {
            if (this._response.isIgnoreClientDisconnect()) {
                this._isDisconnected = true;
            }
            throw e;
        }
    }

    public void flushByte() throws IOException {
        this.flush();
    }

    public void flushChar() throws IOException {
        this.flush();
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
    }

    public void finish() throws IOException {
        boolean isClosed = this._isClosed;
        if (this._next == null || isClosed) {
            this._isClosed = true;
            return;
        }
        this._isFinished = true;
        this._allowFlush = true;
        this.flushBuffer();
        this._isClosed = true;
        if (isClosed || this._next == null) {
            return;
        }
        try {
            CauchoRequest req;
            if (this._chunkedEncoding) {
                this._next.write(_tailChunked, 0, 7);
            }
            if (!(req = this._response.getRequest()).allowKeepalive()) {
                if (log.isLoggable(Level.FINE)) {
                    Connection conn;
                    String id = req instanceof AbstractHttpRequest ? ((conn = ((AbstractHttpRequest)req).getConnection()) != null ? String.valueOf(conn.getId()) : "jni") : "inc";
                    log.fine("[" + id + "] close stream");
                }
                this._next.close();
            }
        }
        catch (ClientDisconnectException e) {
            if (this._response.isIgnoreClientDisconnect()) {
                this._isDisconnected = true;
            }
            throw e;
        }
    }

    public void close() throws IOException {
        this.finish();
    }
}

