/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.util.L10N;
import com.caucho.vfs.TempCharBuffer;
import com.caucho.vfs.i18n.EncodingReader;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class ToCharResponseStream
extends AbstractResponseStream {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/connection/ToCharResponseStream"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/connection/ToCharResponseStream"));
    protected static final int SIZE = TempCharBuffer.SIZE;
    private final byte[] _byteBuffer = new byte[SIZE];
    private int _byteLength;
    private TempCharBuffer _head = TempCharBuffer.allocate();
    private TempCharBuffer _tail;
    private char[] _charBuffer;
    private int _charLength;
    private int _bufferCapacity;
    private int _bufferSize;
    private boolean _autoFlush;
    private boolean _isHead;
    private boolean _isClosed;
    private EncodingReader _toChar;

    protected abstract void writeNext(char[] var1, int var2, int var3) throws IOException;

    public void start() {
        this._head.clear();
        this._tail = this._head;
        this._charBuffer = this._tail.getBuffer();
        this._charLength = 0;
        this._byteLength = 0;
        this._bufferCapacity = SIZE;
        this._bufferSize = 0;
        this._autoFlush = true;
        this._isHead = false;
        this._isClosed = false;
    }

    public char[] getCharBuffer() {
        return this._charBuffer;
    }

    public int getCharOffset() {
        return this._charLength;
    }

    public void setCharOffset(int offset) {
        this._charLength = offset;
    }

    public byte[] getBuffer() {
        return this._byteBuffer;
    }

    public int getBufferOffset() {
        return this._byteLength;
    }

    public void setBufferOffset(int offset) {
        this._byteLength = offset;
    }

    public int getBufferSize() {
        return this._bufferCapacity;
    }

    public void setBufferSize(int size) {
        this._bufferCapacity = SIZE * ((size + SIZE - 1) / SIZE);
        if (this._bufferCapacity <= 0) {
            this._bufferCapacity = 0;
        }
    }

    public int getRemaining() {
        return this._bufferCapacity - this.getBufferLength();
    }

    protected int getBufferLength() {
        return this._bufferSize + this._byteLength + this._charLength;
    }

    public void clearBuffer() {
        TempCharBuffer.freeAll(this._head.getNext());
        this._head.clear();
        this._tail = this._head;
        this._charBuffer = this._tail.getBuffer();
        this._charLength = 0;
        this._byteLength = 0;
        this._bufferSize = 0;
        this._autoFlush = true;
    }

    public void write(int v) throws IOException {
        if (this._byteLength == SIZE) {
            this.flushByteBuffer();
        }
        this._byteBuffer[this._byteLength++] = (byte)v;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        int byteLength = this._byteLength;
        while (length > 0) {
            int sublen;
            if (byteLength == SIZE) {
                this._byteLength = byteLength;
                byteLength = 0;
                this.flushByteBuffer();
            }
            if (length < (sublen = SIZE - byteLength)) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, this._byteBuffer, byteLength, sublen);
            offset += sublen;
            length -= sublen;
            byteLength += sublen;
        }
        this._byteLength = byteLength;
    }

    public void print(int ch) throws IOException {
        if (this._isHead || this._isClosed) {
            return;
        }
        if (this._byteLength > 0) {
            this.flushByteBuffer();
        }
        if (this._bufferCapacity <= this._bufferSize + 1 && this._bufferSize > 0) {
            this.flushCharBuffer();
        }
        this._charBuffer[this._charLength++] = (char)ch;
    }

    public void print(char[] buffer, int offset, int length) throws IOException {
        if (this._isHead || this._isClosed) {
            return;
        }
        if (this._byteLength > 0) {
            this.flushByteBuffer();
        }
        if (this._bufferCapacity <= this._bufferSize + length) {
            if (this._bufferSize > 0) {
                this.flushCharBuffer();
            }
            if (this._bufferCapacity < length) {
                this.writeNext(buffer, offset, length);
                return;
            }
        }
        int charLength = this._charLength;
        while (length > 0) {
            int sublen;
            if (SIZE <= charLength) {
                this._tail.setLength(charLength);
                this._bufferSize += charLength;
                TempCharBuffer tempBuf = TempCharBuffer.allocate();
                this._tail.setNext(tempBuf);
                this._tail = tempBuf;
                this._charBuffer = this._tail.getBuffer();
                charLength = 0;
            }
            if (SIZE - charLength < (sublen = length)) {
                sublen = SIZE - charLength;
            }
            System.arraycopy(buffer, offset, this._charBuffer, charLength, sublen);
            offset += sublen;
            length -= sublen;
            charLength += sublen;
        }
        this._charLength = charLength;
    }

    public void flush() throws IOException {
        this.flushBuffer();
    }

    public void close() throws IOException {
        this.flushBuffer();
    }

    public void flushBuffer() throws IOException {
        if (this._byteLength > 0) {
            this.flushByteBuffer();
        }
        this.flushCharBuffer();
    }

    public byte[] nextBuffer(int offset) throws IOException {
        this._byteLength = offset;
        this.flushByteBuffer();
        return this._byteBuffer;
    }

    protected void flushByteBuffer() throws IOException {
        int byteLength = this._byteLength;
        this._byteLength = 0;
    }

    public char[] nextCharBuffer(int offset) throws IOException {
        this._charLength = offset;
        this.flushCharBuffer();
        return this._charBuffer;
    }

    private void flushCharBuffer() throws IOException {
        TempCharBuffer next;
        this._tail.setLength(this._charLength);
        this._bufferSize += this._charLength;
        this._charLength = 0;
        TempCharBuffer ptr = this._head;
        do {
            this._head = ptr;
            next = ptr.getNext();
            ptr.setNext(null);
            this.writeNext(ptr.getBuffer(), 0, ptr.getLength());
        } while ((ptr = next) != null);
        this._tail = this._head;
        this._charBuffer = this._tail.getBuffer();
        this._bufferSize = 0;
    }
}

