/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.server.deploy.Entry;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpandEntry<I extends DeployInstance>
extends Entry<I> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/deploy/ExpandEntry"));
    private Object _archiveExpandLock = new Object();
    private Path _rootDirectory;
    private Path _archivePath;
    private Manifest _manifest;

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public Path getArchivePath() {
        return this._archivePath;
    }

    public void setArchivePath(Path path) {
        this._archivePath = path;
    }

    public Manifest getManifest() {
        return this._manifest;
    }

    @Override
    protected void deploy() throws IOException {
        this.expandArchive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expandArchive() throws IOException {
        Object object = this._archiveExpandLock;
        synchronized (object) {
            Path path;
            if (!this.expandArchiveImpl()) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.expandArchiveImpl();
            }
            if ((path = this.getRootDirectory().lookup("META-INF/MANIFEST.MF")).canRead()) {
                ReadStream is = path.openRead();
                try {
                    this._manifest = new Manifest(is);
                }
                finally {
                    is.close();
                }
            }
        }
    }

    protected void addManifestClassPath() throws IOException {
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes main = manifest.getMainAttributes();
        String classPath = main.getValue("Class-Path");
        if (classPath == null) {
            return;
        }
        String[] urls = Pattern.compile("[\\s,]+").split(classPath);
        if (urls == null) {
            return;
        }
        DynamicClassLoader loader = Environment.getDynamicClassLoader();
        if (loader == null) {
            return;
        }
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            if (url.equals("")) continue;
            loader.addJar(Vfs.lookup(url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean expandArchiveImpl() throws IOException {
        Path archivePath = this._archivePath;
        if (archivePath == null) {
            return true;
        }
        if (!archivePath.canRead()) {
            return true;
        }
        Path expandDir = this.getRootDirectory();
        Path parent = expandDir.getParent();
        try {
            parent.mkdirs();
        }
        catch (Throwable e) {
            // empty catch block
        }
        Path dependPath = expandDir.lookup("META-INF/resin-war.digest");
        Depend depend = null;
        if (dependPath.canRead()) {
            ReadStream is = null;
            try {
                is = dependPath.openRead();
                String digest = is.readLine().trim();
                depend = new Depend(archivePath, digest);
                if (!depend.isModified()) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if (depend == null) {
            depend = new Depend(archivePath);
        }
        try {
            if (log.isLoggable(Level.INFO)) {
                this.getLog().info(new StringBuffer().append("expanding ").append(archivePath).append(" to ").append(expandDir).toString());
            }
            expandDir.mkdirs();
            ReadStream rs = archivePath.openRead();
            ZipInputStream zis = new ZipInputStream(rs);
            try {
                ZipEntry entry;
                byte[] buffer = new byte[1024];
                while ((entry = zis.getNextEntry()) != null) {
                    String name = entry.getName();
                    Path path = expandDir.lookup(name);
                    if (entry.isDirectory()) {
                        path.mkdirs();
                        continue;
                    }
                    long length = entry.getSize();
                    long lastModified = entry.getTime();
                    path.getParent().mkdirs();
                    WriteStream os = path.openWrite();
                    try {
                        int len;
                        while ((len = zis.read(buffer, 0, buffer.length)) > 0) {
                            os.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                    finally {
                        os.close();
                    }
                    if (lastModified <= 0L) continue;
                    path.setLastModified(lastModified);
                }
            }
            finally {
                try {
                    zis.close();
                }
                catch (IOException e) {}
                try {
                    rs.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            return false;
        }
        try {
            dependPath.getParent().mkdirs();
            WriteStream os = dependPath.openWrite();
            os.println(depend.getDigest());
            os.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return true;
    }

    private static void removeAll(Path path) {
        try {
            if (path.isDirectory()) {
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    ExpandEntry.removeAll(path.lookup(list[i]));
                }
            }
            path.remove();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected void removeExpandDirectory(Path path, String relPath) {
        try {
            if (path.isDirectory()) {
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    this.removeExpandDirectory(path.lookup(list[i]), new StringBuffer().append(relPath).append("/").append(list[i]).toString());
                }
            }
            this.removeExpandFile(path, relPath);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    protected void removeExpandFile(Path path, String relPath) throws IOException {
        path.remove();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Entry entry = (Entry)o;
        return this.getName().equals(entry.getName());
    }
}

