/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.log.Log;
import com.caucho.server.dispatch.FilterChainBuilder;
import com.caucho.server.dispatch.FilterFilterChain;
import com.caucho.server.dispatch.FilterManager;
import com.caucho.server.dispatch.FilterMapping;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class FilterMapper {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/dispatch/FilterMapper"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/dispatch/FilterMapper"));
    private ServletContext _servletContext;
    private int _unique;
    private FilterManager _filterManager;
    private ArrayList<FilterMapping> _filterMap = new ArrayList();
    private ArrayList<FilterChainBuilder> _topFilters = new ArrayList();
    private ArrayList<FilterChainBuilder> _bottomFilters = new ArrayList();

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public FilterManager getFilterManager() {
        return this._filterManager;
    }

    public void setFilterManager(FilterManager manager) {
        this._filterManager = manager;
    }

    public void addFilterMapping(FilterMapping mapping) throws ServletException {
        try {
            String filterName = mapping.getFilterName();
            if (this._filterManager.getFilter(filterName) == null) {
                throw new ServletConfigException(L.l("`{0}' is an unknown filter-name.  filter-mapping requires that the named filter be defined in a <filter> configuration before the <filter-mapping>.", filterName));
            }
            this._filterMap.add(mapping);
            if (mapping.getServletName() != null) {
                log.fine("filter-mapping " + mapping.getServletName() + " -> " + filterName);
            } else {
                log.fine("filter-mapping " + mapping.getURLPattern() + " -> " + filterName);
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void addTopFilter(FilterChainBuilder filterBuilder) {
        this._topFilters.add(filterBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDispatchChain(Invocation invocation, FilterChain chain) throws ServletException {
        Filter filter;
        String filterName;
        FilterMapping map;
        int i;
        ArrayList<FilterMapping> arrayList = this._filterMap;
        synchronized (arrayList) {
            for (i = this._filterMap.size() - 1; i >= 0; --i) {
                map = this._filterMap.get(i);
                if (!map.isMatch(invocation.getServletName())) continue;
                filterName = map.getFilterName();
                filter = this._filterManager.createFilter(filterName);
                chain = new FilterFilterChain(chain, filter);
            }
        }
        arrayList = this._filterMap;
        synchronized (arrayList) {
            for (i = this._filterMap.size() - 1; i >= 0; --i) {
                map = this._filterMap.get(i);
                if (!map.isMatch(invocation)) continue;
                filterName = map.getFilterName();
                filter = this._filterManager.createFilter(filterName);
                chain = new FilterFilterChain(chain, filter);
            }
        }
        for (int i2 = 0; i2 < this._topFilters.size(); ++i2) {
            FilterChainBuilder filterBuilder = this._topFilters.get(i2);
            chain = filterBuilder.build(chain, invocation);
        }
        invocation.setFilterChain(chain);
    }
}

