/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.config.types.InitParam;
import com.caucho.config.types.InitProgram;
import com.caucho.jmx.Jmx;
import com.caucho.jsp.Page;
import com.caucho.jsp.QServlet;
import com.caucho.log.Log;
import com.caucho.server.connection.StubServletRequest;
import com.caucho.server.connection.StubServletResponse;
import com.caucho.server.dispatch.PageFilterChain;
import com.caucho.server.dispatch.RunAt;
import com.caucho.server.dispatch.SecurityRoleMapFilterChain;
import com.caucho.server.dispatch.SecurityRoleRef;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.dispatch.ServletFilterChain;
import com.caucho.server.dispatch.ServletManager;
import com.caucho.server.dispatch.SingleThreadServletFilterChain;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletConfigImpl
implements ServletConfig,
AlarmListener {
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/dispatch/ServletConfigImpl"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/dispatch/ServletConfigImpl"));
    private String _servletName;
    private String _servletClassName;
    private Class _servletClass;
    private String _jspFile;
    private String _displayName;
    private int _loadOnStartup = Integer.MIN_VALUE;
    private boolean _allowEL = true;
    private HashMap<String, String> _initParams = new HashMap();
    private HashMap<String, String> _roleMap;
    private InitProgram _init;
    private RunAt _runAt;
    private Alarm _alarm;
    private ServletContext _servletContext;
    private ServletManager _servletManager;
    private ServletException _initException;
    private long _nextInitTime;
    private Servlet _servlet;
    private FilterChain _servletChain;

    public void setId(String id) {
    }

    public void setServletName(String name) {
        this._servletName = name;
    }

    public String getServletName() {
        return this._servletName;
    }

    public String getServletClassName() {
        return this._servletClassName;
    }

    public void setServletClass(String servletClassName) throws ServletException {
        this._servletClassName = servletClassName;
    }

    public Class getServletClass() {
        return this._servletClass;
    }

    public void setJspFile(String jspFile) {
        this._jspFile = jspFile;
    }

    public String getJspFile() {
        return this._jspFile;
    }

    public void setAllowEL(boolean allowEL) {
        this._allowEL = allowEL;
    }

    public void setInitParam(String param, String value) {
        this._initParams.put(param, value);
    }

    public InitParam createInitParam() {
        InitParam initParam = new InitParam();
        initParam.setAllowEL(this._allowEL);
        return initParam;
    }

    public void setInitParam(InitParam initParam) {
        this._initParams.putAll(initParam.getParameters());
    }

    public Map getInitParamMap() {
        return this._initParams;
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void setServletContext(ServletContext app) {
        this._servletContext = app;
    }

    public ServletManager getServletManager() {
        return this._servletManager;
    }

    public void setServletManager(ServletManager manager) {
        this._servletManager = manager;
    }

    public void setInit(InitProgram init) {
        this._init = init;
    }

    public InitProgram getInit() {
        return this._init;
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this._loadOnStartup = loadOnStartup;
    }

    public int getLoadOnStartup() {
        if (this._loadOnStartup > Integer.MIN_VALUE) {
            return this._loadOnStartup;
        }
        if (this._runAt != null) {
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    public RunAt createRunAt() {
        if (this._runAt == null) {
            this._runAt = new RunAt();
        }
        return this._runAt;
    }

    public RunAt getRunAt() {
        return this._runAt;
    }

    public void addSecurityRoleRef(SecurityRoleRef ref) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap();
        }
        this._roleMap.put(ref.getRoleName(), ref.getRoleLink());
    }

    public HashMap<String, String> getRoleMap() {
        return this._roleMap;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDescription(String description) {
    }

    public void setIcon(String icon) {
    }

    public void setInitException(ServletException exn) {
        UnavailableException unExn;
        this._initException = exn;
        this._nextInitTime = 0x3FFFFFFFFFFFFFFFL;
        if (exn instanceof UnavailableException && !(unExn = (UnavailableException)exn).isPermanent()) {
            this._nextInitTime = Alarm.getCurrentTime() + 1000L * (long)unExn.getUnavailableSeconds();
        }
    }

    public Servlet getServlet() {
        return this._servlet;
    }

    public void init() throws ServletException {
        if (this._runAt != null) {
            this._alarm = new Alarm(this);
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (this._servletName == null) {
            this._servletName = this._servletClassName;
        }
        if (this._servletClassName != null && !this._servletClassName.equals("invoker")) {
            try {
                this._servletClass = Class.forName(this._servletClassName, false, loader);
            }
            catch (ClassNotFoundException e) {
                log.log(Level.FINER, e.toString(), e);
            }
            if (this._servletClass == null) {
                throw new ServletConfigException(L.l("`{0}' is not a known servlet.  Servlets belong in the classpath, often in WEB-INF/classes.", this._servletClassName));
            }
            if (!ClassLiteral.getClass((String)"javax/servlet/Servlet").isAssignableFrom(this._servletClass)) {
                throw new ServletConfigException(L.l("`{0}' must implement javax.servlet.Servlet.  All servlets must implement the Servlet interface.", this._servletClassName));
            }
            if (Modifier.isAbstract(this._servletClass.getModifiers())) {
                throw new ServletConfigException(L.l("`{0}' must not be abstract.  Servlets must be fully-implemented classes.", this._servletClassName));
            }
            if (!Modifier.isPublic(this._servletClass.getModifiers())) {
                throw new ServletConfigException(L.l("`{0}' must be public.  Servlets must be public classes.", this._servletClassName));
            }
            this.checkConstructor();
        }
    }

    public void checkConstructor() throws ServletException {
        Constructor<?>[] constructors = this._servletClass.getDeclaredConstructors();
        Constructor<?> zeroArg = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            zeroArg = constructors[i];
            break;
        }
        if (zeroArg == null) {
            throw new ServletConfigException(L.l("`{0}' must have a zero arg constructor.  Servlets must have public zero-arg constructors.\n{1} is not a valid constructor.", (Object)this._servletClassName, constructors[0]));
        }
        if (!Modifier.isPublic(zeroArg.getModifiers())) {
            throw new ServletConfigException(L.l("`{0}' must be public.  '{1}' must have a public, zero-arg constructor.", zeroArg, this._servletClassName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAlarm(Alarm alarm) {
        try {
            log.fine(new StringBuffer().append(this).append(" cron").toString());
            FilterChain chain = this.createServletChain();
            StubServletRequest req = new StubServletRequest();
            StubServletResponse res = new StubServletResponse();
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            long nextTime = this._runAt.getNextTimeout(Alarm.getCurrentTime());
            this._alarm.queue(nextTime - Alarm.getCurrentTime());
        }
    }

    synchronized FilterChain createServletChain() throws ServletException {
        if (this._servletChain != null) {
            return this._servletChain;
        }
        String jspFile = this.getJspFile();
        Object servletChain = null;
        if (jspFile != null) {
            QServlet jsp = (QServlet)this._servletManager.createServlet("jsp");
            servletChain = new PageFilterChain(this._servletContext, jsp, jspFile, this);
            return servletChain;
        }
        Class servletClass = this.getServletClass();
        if (servletClass == null) {
            throw new IllegalStateException(L.l("servlet class for {0} can't be null", this.getServletName()));
        }
        servletChain = ClassLiteral.getClass((String)"com/caucho/jsp/QServlet").isAssignableFrom(servletClass) ? new PageFilterChain(this._servletContext, (QServlet)this.createServlet()) : (ClassLiteral.getClass((String)"javax/servlet/SingleThreadModel").isAssignableFrom(servletClass) ? new SingleThreadServletFilterChain(this) : new ServletFilterChain(this));
        if (this._roleMap != null) {
            servletChain = new SecurityRoleMapFilterChain((FilterChain)servletChain, this._roleMap);
        }
        return servletChain;
    }

    synchronized Servlet createServlet() throws ServletException {
        if (this._servlet != null) {
            return this._servlet;
        }
        if (Alarm.getCurrentTime() < this._nextInitTime) {
            throw this._initException;
        }
        Class servletClass = this.getServletClass();
        if (log.isLoggable(Level.FINE)) {
            log.fine(new StringBuffer().append("Servlet[").append(this._servletName).append("] starting").toString());
        }
        try {
            Servlet servlet = null;
            if (this._jspFile != null) {
                servlet = this.createJspServlet(this._servletName, this._jspFile);
            } else if (servletClass != null) {
                servlet = (Servlet)servletClass.newInstance();
            } else {
                throw new ServletException(L.l("Null servlet class for `{0}'.", this._servletName));
            }
            InjectIntrospector.configure(servlet);
            InitProgram init = this.getInit();
            if (init != null) {
                init.getBuilderProgram().configure(servlet);
            }
            try {
                servlet.init((ServletConfig)this);
            }
            catch (UnavailableException e) {
                this.setInitException((ServletException)((Object)e));
                throw e;
            }
            this._servlet = servlet;
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("type", "Servlet");
                props.put("name", this._servletName);
                Jmx.register((Object)this._servlet, props);
            }
            catch (Throwable e) {
                log.finest(e.toString());
            }
            if (this._runAt != null && this._alarm != null) {
                long nextTime = this._runAt.getNextTimeout(Alarm.getCurrentTime());
                this._alarm.queue(nextTime - Alarm.getCurrentTime());
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(new StringBuffer().append("Servlet[").append(this._servletName).append("] started").toString());
            }
            return this._servlet;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            throw new ServletException(e);
        }
    }

    Servlet createJspServlet(String servletName, String jspFile) throws ServletException {
        try {
            ServletConfigImpl jspConfig = this._servletManager.getServlet("jsp");
            QServlet jsp = (QServlet)jspConfig.createServlet();
            Page page = jsp.getPage(servletName, jspFile);
            return page;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    void killServlet() {
        Servlet servlet = this._servlet;
        this._servlet = null;
        if (this._alarm != null) {
            this._alarm.dequeue();
        }
        if (servlet != null) {
            servlet.destroy();
        }
    }

    public String toString() {
        return new StringBuffer().append("ServletConfigImpl[name=").append(this._servletName).append(",class=").append(this._servletClass).append("]").toString();
    }
}

