/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.NodeBuilder;
import com.caucho.log.Log;
import com.caucho.server.deploy.ExpandEntry;
import com.caucho.server.e_app.ApplicationConfig;
import com.caucho.server.e_app.EntAppClient;
import com.caucho.server.e_app.EnterpriseApplication;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.jar.Manifest;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClientEntry
extends ExpandEntry<EntAppClient> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/e_app/AppClientEntry"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/e_app/AppClientEntry"));
    private String _name = "";
    private ClassLoader _parentClassLoader;
    private JarPath _clientJar;
    private ArrayList<Path> _configList = new ArrayList();
    private boolean _isInit;

    public AppClientEntry() {
        this._parentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this._parentClassLoader;
    }

    public void addConfig(Path path) {
        this._configList.add(path);
    }

    public void main(String[] args) throws Throwable {
        this.start();
        EntAppClient appClient = (EntAppClient)this.createLazyInstance();
        if (appClient != null) {
            appClient.main(args);
        }
    }

    public void main(String mainClass, String[] args) throws Throwable {
        this.start();
        EntAppClient appClient = (EntAppClient)this.createLazyInstance();
        if (appClient != null) {
            appClient.main(mainClass, args);
        }
    }

    public ClassLoader getLoader() {
        this.start();
        EntAppClient appClient = (EntAppClient)this.createLazyInstance();
        if (appClient != null) {
            return appClient.getClassLoader();
        }
        return null;
    }

    @Override
    protected EntAppClient instantiateDeployInstance() {
        return new EntAppClient(this, this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInstance(EntAppClient appClient) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        Path rootDir = null;
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            appClient.setArchivePath(this.getArchivePath());
            rootDir = this.getRootDirectory();
            if (rootDir == null) {
                throw new NullPointerException("Null root-directory");
            }
            appClient.setRootDirectory(rootDir);
            thread.setContextClassLoader(appClient.getClassLoader());
            Vfs.setPwd(rootDir);
            this.addManifestClassPath();
            this.configApplication(appClient);
            this.configClientApplication(appClient);
            for (int i = 0; i < this._configList.size(); ++i) {
                this.configClientConfig(appClient, this._configList.get(i));
            }
            appClient.init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void configApplication(EntAppClient appClient) throws Exception {
        Path rootDir = this.getRootDirectory();
        Path xml = rootDir.lookup("META-INF/application.xml");
        ApplicationConfig config = EnterpriseApplication.parseApplicationConfig(rootDir, xml);
        ArrayList<Path> ejbModules = config.getEjbModules();
        ArrayList<Path> javaModules = config.getJavaModules();
        for (int i = 0; i < javaModules.size(); ++i) {
            Path path = javaModules.get(i);
            appClient.getClassLoader().addJar(path);
            this._clientJar = JarPath.create(path);
            Manifest manifest = this._clientJar.getManifest();
            String mainClass = manifest.getMainAttributes().getValue("Main-Class");
            appClient.setMainClass(mainClass);
        }
    }

    private void configClientApplication(EntAppClient appClient) throws Exception {
        if (this._clientJar == null) {
            return;
        }
        Path xml = this._clientJar.lookup("META-INF/application-client.xml");
        if (!xml.canRead()) {
            return;
        }
        NodeBuilder builder = new NodeBuilder();
        builder.setCompactSchema("com/caucho/server/e_app/app-client-14.rnc");
        builder.configure((Object)appClient, xml);
    }

    private void configClientConfig(EntAppClient appClient, Path xml) throws Exception {
        if (!xml.canRead()) {
            return;
        }
        NodeBuilder builder = new NodeBuilder();
        builder.configure((Object)appClient, xml);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AppClientEntry)) {
            return false;
        }
        AppClientEntry entry = (AppClientEntry)o;
        return this.getName().equals(entry.getName());
    }

    @Override
    public String toString() {
        return new StringBuffer().append("AppClientEntry[").append(this.getName()).append("]").toString();
    }
}

