/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.e_app;

import com.caucho.config.ConfigException;
import com.caucho.config.NodeBuilder;
import com.caucho.ejb.EJBServerInterface;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.java.WorkDir;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.log.Log;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.server.deploy.DeployInstance;
import com.caucho.server.e_app.ApplicationConfig;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarEntry;
import com.caucho.server.e_app.WebModule;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.el.VariableResolver;
import org.iso_relax.verifier.Schema;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseApplication
implements EnvironmentBean,
DeployInstance {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/e_app/EnterpriseApplication"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/e_app/EnterpriseApplication"));
    protected static EnvironmentLocal<EJBServerInterface> _localServer = new EnvironmentLocal("caucho.ejb-server");
    private static Schema _earXmlSchema;
    private EnvironmentClassLoader _loader;
    private String _name;
    private Path _rootDir;
    private Path _earPath;
    private String _prefix = "";
    private EarEntry _entry;
    private ApplicationConfig _config;
    private ApplicationContainer _container;
    private EarConfig _earConfig;
    private HashMap<String, Object> _variableMap = new HashMap();
    private VariableResolver _variableResolver;
    private LinkedHashMap<String, String> _jmxContext;
    private ArrayList<WebAppEntry> _webApps = new ArrayList();
    private Throwable _configException;
    private final Lifecycle _lifecycle;

    EnterpriseApplication(ApplicationContainer container, EarEntry entry, String name) {
        this._container = container;
        this._entry = entry;
        this._name = name;
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        this._loader = new EnhancingClassLoader(container.getClassLoader());
        this._loader.setOwner(this);
        this._loader.setId(new StringBuffer().append("EnterpriseApplication[").append(name).append("]").toString());
        VariableResolver parentResolver = EL.getEnvironment();
        this._variableResolver = new MapVariableResolver(this._variableMap, parentResolver);
        EL.setEnvironment(this._variableResolver, this._loader);
        Vfs.setPwd(this._entry.getRootDirectory(), this._loader);
        WorkDir.setLocalWorkDir(this._entry.getRootDirectory().lookup("META-INF/work"), this._loader);
        this._jmxContext = Jmx.copyContextProperties();
        this._jmxContext.put("EApp", name);
        Jmx.setContextProperties(this._jmxContext, this._loader);
        this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
        if (entry.getArchivePath() != null) {
            Environment.addDependency(new Depend(entry.getArchivePath()), (ClassLoader)this._loader);
        }
    }

    public void setName(String name) {
        this._name = name;
        this._loader.setId(new StringBuffer().append("EnterpriseApplication[").append(name).append("]").toString());
    }

    public String getName() {
        return this._name;
    }

    public void setRootDirectory(Path rootDir) {
        this._rootDir = rootDir;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    @Override
    public EnvironmentClassLoader getClassLoader() {
        return this._loader;
    }

    @Override
    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._loader = loader;
    }

    public void setEarPath(Path earPath) {
        this._earPath = earPath;
    }

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void addEarConfig(EarConfig earConfig) {
        this._earConfig = earConfig;
    }

    public VariableResolver getVariableResolver() {
        return this._variableResolver;
    }

    public Map<String, Object> getVariableMap() {
        return this._variableMap;
    }

    @Override
    public boolean isModified() {
        return this._loader.isModified();
    }

    @Override
    public boolean isModifiedForAutomaticRedeploy() {
        return this.isModified();
    }

    @Override
    public void setConfigException(Throwable e) {
        this._configException = e;
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    public void init() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            if (!this._lifecycle.toInit()) {
                return;
            }
            log.fine(new StringBuffer().append(this).append(" initializing").toString());
            Vfs.setPwd(this._rootDir, this._loader);
            Path appXml = this._rootDir.lookup("META-INF/application.xml");
            if (!appXml.canRead()) {
                throw new ConfigException(L.l("missing application.xml for ear {0}.  .ear files require a META-INF/application.xml file.", this._earPath));
            }
            Depend depend = new Depend(appXml);
            Environment.addDependency(depend, (ClassLoader)this._loader);
            this._config = EnterpriseApplication.parseApplicationConfig(this._rootDir, appXml);
            ArrayList<Path> ejbModules = this._config.getEjbModules();
            Object configException = null;
            this.configureEJB(ejbModules);
            ArrayList<WebModule> webModules = this._config.getWebModules();
            for (int i = 0; i < webModules.size(); ++i) {
                WebModule web = webModules.get(i);
                String webUri = web.getWebURI();
                String contextUrl = web.getContextRoot();
                Path path = this._rootDir.lookup(webUri);
                if (contextUrl == null) {
                    contextUrl = webUri;
                }
                WebAppEntry entry = null;
                if (webUri.endsWith(".war")) {
                    String name = webUri.substring(0, webUri.length() - 4);
                    int p = name.lastIndexOf(47);
                    if (p > 0) {
                        name = name.substring(p + 1);
                    }
                    Path expandPath = this._rootDir.lookup("webapps");
                    expandPath.mkdirs();
                    entry = new WebAppEntry(this._container, contextUrl);
                    entry.setRootDirectory(expandPath.lookup(name));
                    entry.setArchivePath(path);
                } else {
                    entry = new WebAppEntry(this._container, contextUrl);
                    entry.setRootDirectory(path);
                }
                entry.setDynamicDeploy(true);
                this._webApps.add(entry);
                entry.init();
                this._container.getApplicationGenerator().update(entry.getName());
            }
        }
        catch (ConfigException e) {
            this._configException = e;
            throw e;
        }
        catch (Exception e) {
            this._configException = e;
            throw e;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    static ApplicationConfig parseApplicationConfig(Path rootDir, Path appXml) throws IOException, ConfigException, SAXException {
        ApplicationConfig config = new ApplicationConfig();
        NodeBuilder builder = new NodeBuilder();
        builder.setCompactSchema("com/caucho/server/e_app/ear.rnc");
        builder.configure((Object)config, appXml);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            this.getClassLoader().start();
            for (int i = 0; i < this._webApps.size(); ++i) {
                WebAppEntry entry = this._webApps.get(i);
                try {
                    entry.start();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        finally {
            this._lifecycle.toActive();
            thread.setContextClassLoader(oldLoader);
        }
    }

    public WebAppEntry findWebAppEntry(String name) {
        for (int i = 0; i < this._webApps.size(); ++i) {
            WebAppEntry entry = this._webApps.get(i);
            if (!entry.isNameMatch(name)) continue;
            return entry;
        }
        return null;
    }

    private void addDepend(Path path) {
        this._loader.addDependency(new Depend(path));
    }

    private void configureEJB(ArrayList<Path> ejbModules) throws Exception {
        if (ejbModules.size() == 0) {
            return;
        }
        this._loader.init();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            Path path;
            int i;
            thread.setContextClassLoader(this._loader);
            EJBServerInterface ejbServer = _localServer.getLevel();
            if (ejbServer == null) {
                throw new ConfigException(L.l("<ear-deploy> needs a configured <ejb-server>"));
            }
            for (i = 0; i < ejbModules.size(); ++i) {
                path = ejbModules.get(i);
                this._loader.addJar(path);
            }
            for (i = 0; i < ejbModules.size(); ++i) {
                path = ejbModules.get(i);
                ejbServer.addEJBJar(path);
            }
            ejbServer.initEJBs();
        }
        catch (ConfigException e) {
            throw e;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public ArrayList<WebAppEntry> getApplications() {
        return this._webApps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this._lifecycle.toStopping()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            this._loader.stop();
        }
        finally {
            this._lifecycle.toStop();
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            log.fine(new StringBuffer().append(this).append(" destroying").toString());
            ArrayList<WebAppEntry> webApps = new ArrayList<WebAppEntry>(this._webApps);
            this._webApps.clear();
            for (int i = 0; i < webApps.size(); ++i) {
                WebAppEntry entry = webApps.get(i);
                entry.destroy();
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            this._loader.destroy();
            log.fine(new StringBuffer().append(this).append(" destroyed").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getEarXmlSchema() {
        block6: {
            if (_earXmlSchema == null) {
                try {
                    MergePath schemaPath = new MergePath();
                    schemaPath.addClassPath();
                    Path path = schemaPath.lookup("com/caucho/server/e_app/resin-ear-xml.rnc");
                    if (!path.canRead()) break block6;
                    ReadStream is = path.openRead();
                    try {
                        CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
                        _earXmlSchema = factory.compileSchema(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        return _earXmlSchema;
    }

    public String toString() {
        return new StringBuffer().append("EnterpriseApplication[").append(this.getName()).append("]").toString();
    }
}

