/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainName {
    static final Logger log;
    static final L10N L;
    private static final char[] ENCODE;
    private static final int[] DECODE;
    private static final int base = 36;
    private static final int tmin = 1;
    private static final int tmax = 26;
    private static final int skew = 38;
    private static final int damp = 700;
    private static final int initialBias = 72;
    private static final int initialN = 128;

    public static String fromAscii(String source) {
        CharBuffer result = CharBuffer.allocate();
        CharBuffer cb = CharBuffer.allocate();
        int index = 0;
        int length = source.length();
        boolean isFirst = true;
        try {
            while (index < length) {
                char ch = source.charAt(index + 0);
                if (isFirst && index + 4 < length && source.charAt(index + 0) == 'x' && source.charAt(index + 1) == 'n' && source.charAt(index + 2) == '-' && source.charAt(index + 3) == '-') {
                    int p = source.indexOf(46);
                    String seq = p < 0 ? source.substring(index + 4) : source.substring(index + 4, p);
                    DomainName.decode(result, cb, seq);
                    index += 4 + seq.length();
                    continue;
                }
                ++index;
                isFirst = false;
                if (ch == '.') {
                    isFirst = true;
                    result.append(ch);
                    continue;
                }
                result.append(Character.toLowerCase(ch));
            }
            return result.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            throw new RuntimeException(e);
        }
    }

    public static String toAscii(String source) {
        CharBuffer result = CharBuffer.allocate();
        CharBuffer cb = CharBuffer.allocate();
        int head = 0;
        int length = source.length();
        while (head < length) {
            char ch;
            int i;
            boolean isAscii = true;
            cb.clear();
            for (i = head; i < length; ++i) {
                ch = source.charAt(i);
                if (ch == '.') {
                    cb.append(ch);
                    break;
                }
                if (ch > '\u007f') {
                    isAscii = false;
                    break;
                }
                cb.append(ch);
            }
            if (isAscii) {
                head = i + 1;
                result.append(cb);
                continue;
            }
            cb.clear();
            for (i = head; i < length && (ch = source.charAt(i)) != '.'; ++i) {
                cb.append(ch);
            }
            head = i;
            String seq = cb.toString();
            cb.clear();
            DomainName.toAscii(cb, seq);
            result.append(cb);
        }
        return result.close();
    }

    private static void decode(CharBuffer result, CharBuffer cb, String seq) {
        char ch;
        int i;
        int length = seq.length();
        int b = 0;
        for (i = 0; i < length; ++i) {
            ch = seq.charAt(i);
            if (ch != '-') continue;
            b = i;
        }
        for (i = 0; i < b; ++i) {
            ch = seq.charAt(i);
            cb.append(Character.toLowerCase(ch));
        }
        int in = b > 0 ? b + 1 : 0;
        int i2 = 0;
        int bias = 72;
        int out = cb.length();
        int n = 128;
        while (in < length) {
            int oldi = i2;
            int w = 1;
            int k = 36;
            while (true) {
                char ch2 = seq.charAt(in++);
                int digit = DECODE[ch2];
                i2 += digit * w;
                int t = k <= bias ? 1 : (bias + 26 <= k ? 26 : k - bias);
                if (digit < t) break;
                w *= 36 - t;
                k += 36;
            }
            bias = DomainName.adapt(i2 - oldi, out + 1, oldi == 0);
            n += i2 / (out + 1);
            cb.append(' ');
            char[] cBuf = cb.getBuffer();
            System.arraycopy(cBuf, i2 %= out + 1, cBuf, i2 + 1, out - i2);
            cBuf[i2++] = Character.toLowerCase((char)n);
            ++out;
        }
        result.append(cb);
    }

    private static void toAscii(CharBuffer cb, String seq) {
        cb.append("xn--");
        int length = seq.length();
        boolean index = false;
        int n = 128;
        int delta = 0;
        int bias = 72;
        int b = 0;
        for (int i = 0; i < length; ++i) {
            char ch = seq.charAt(i);
            if (ch >= '\u0080') continue;
            cb.append(ch);
            ++b;
        }
        if (b > 0) {
            cb.append('-');
        }
        int h = b;
        while (h < length) {
            int ch;
            int i;
            int m = 65535;
            for (i = 0; i < length; ++i) {
                ch = seq.charAt(i);
                if (n > ch || ch >= m) continue;
                m = ch;
            }
            delta += (m - n) * (h + 1);
            n = m;
            for (i = 0; i < length; ++i) {
                int t;
                ch = seq.charAt(i);
                if (ch < n) {
                    ++delta;
                }
                if (ch != n) continue;
                int q = delta;
                int k = 36;
                while (q >= (t = k <= bias ? 1 : (bias + 26 <= k ? 26 : k - bias))) {
                    cb.append(ENCODE[t + (q - t) % (36 - t)]);
                    q = (q - t) / (36 - t);
                    k += 36;
                }
                cb.append(ENCODE[q]);
                bias = DomainName.adapt(delta, h + 1, h == b);
                delta = 0;
                ++h;
            }
            ++delta;
            ++n;
        }
    }

    private static int adapt(int delta, int nPoints, boolean isFirst) {
        delta = isFirst ? delta / 700 : delta / 2;
        delta += delta / nPoints;
        int k = 0;
        while (455 < delta) {
            delta /= 35;
            k += 36;
        }
        return k + 36 * delta / (delta + 38);
    }

    static {
        int i;
        log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/host/DomainName"));
        L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/host/DomainName"));
        ENCODE = new char[36];
        for (i = 0; i < 26; ++i) {
            DomainName.ENCODE[i] = (char)(97 + i);
        }
        for (i = 0; i < 10; ++i) {
            DomainName.ENCODE[i + 26] = (char)(48 + i);
        }
        DECODE = new int[128];
        for (i = 0; i < 26; ++i) {
            DomainName.DECODE[(char)(97 + i)] = i;
            DomainName.DECODE[(char)(65 + i)] = i;
        }
        for (i = 0; i < 10; ++i) {
            DomainName.DECODE[(char)(48 + i)] = 26 + i;
        }
    }
}

