/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.el.EL;
import com.caucho.log.Log;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.deploy.ExpandDeploy;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostEntry;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostExpandDeploy
extends ExpandDeploy<HostEntry> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/host/HostExpandDeploy"));
    private HostContainer _container;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private String _hostName;

    public HostExpandDeploy(DeployContainer<HostEntry> container, HostContainer hostContainer) {
        super((DeployContainer)container);
        this._container = hostContainer;
    }

    public HostContainer getContainer() {
        return this._container;
    }

    public void setHostName(RawString name) {
        this._hostName = name.getValue();
    }

    public String getHostName() {
        return this._hostName;
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        log.config("lazy-init is deprecated.  Use <startup>lazy</startup> instead.");
        if (lazyInit) {
            this.setStartupMode("lazy");
        } else {
            this.setStartupMode("automatic");
        }
    }

    public void addHostDefault(HostConfig config) {
        this._hostDefaults.add(config);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public HostEntry createEntry(String name) throws Exception {
        Path rootDirectory = this.getExpandDirectory().lookup(name);
        HostEntry entry = new HostEntry(this._container, null);
        entry.setName(name);
        entry.setRootDirectory(rootDirectory);
        entry.setStartupMode(this.getStartupMode());
        Path jarPath = this.getArchiveDirectory().lookup(new StringBuffer().append(name).append(".jar").toString());
        entry.setArchivePath(jarPath);
        entry.addDepend(jarPath);
        String hostName = this.getHostName();
        if (hostName != null) {
            entry.setHostName(EL.evalString(hostName, entry.getVariableResolver()));
        } else {
            entry.setHostName(name);
        }
        for (int i = 0; i < this._hostDefaults.size(); ++i) {
            entry.addHostDefault(this._hostDefaults.get(i));
        }
        return entry;
    }

    @Override
    public boolean equals(Object o) {
        Path deployExpandPath;
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        HostExpandDeploy deploy = (HostExpandDeploy)o;
        Path expandPath = this.getExpandDirectory();
        return expandPath == (deployExpandPath = deploy.getExpandDirectory()) || expandPath != null && expandPath.equals(deployExpandPath);
    }

    @Override
    public String toString() {
        return new StringBuffer().append("HostExpandDeploy[").append(this.getExpandDirectory()).append("]").toString();
    }
}

