/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.log.Log;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostEntry;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostRegexpDeploy
extends Deploy<HostEntry> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/host/HostSingleDeploy"));
    private HostContainer _container;
    private HostConfig _config;
    private ArrayList<HostConfig> _hostDefaults = new ArrayList();
    private ArrayList<HostEntry> _entries = new ArrayList();

    public HostRegexpDeploy(DeployContainer<HostEntry> container) {
        super(container);
    }

    public HostRegexpDeploy(DeployContainer<HostEntry> container, HostContainer hostContainer, HostConfig config) {
        super(container);
        this.setContainer(hostContainer);
        this._config = config;
    }

    public HostContainer getContainer() {
        return this._container;
    }

    public void setContainer(HostContainer container) {
        this._container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostEntry generateEntry(String name) {
        Pattern regexp = this._config.getRegexp();
        Matcher matcher = regexp.matcher(name);
        if (!matcher.find() || matcher.start() != 0) {
            return null;
        }
        int length = matcher.end() - matcher.start();
        String contextPath = matcher.group();
        ArrayList<String> vars = new ArrayList<String>();
        HashMap<String, Object> varMap = new HashMap<String, Object>();
        for (int j = 0; j <= matcher.groupCount(); ++j) {
            vars.add(matcher.group(j));
            varMap.put(new StringBuffer().append("host").append(j).toString(), matcher.group(j));
        }
        varMap.put("regexp", vars);
        HostEntry entry = new HostEntry(this._container, this._config);
        entry.addVariableMap(varMap);
        entry.setRegexpName(name);
        for (int i = 0; i < this._hostDefaults.size(); ++i) {
            entry.addHostDefault(this._hostDefaults.get(i));
        }
        entry.init();
        Path rootDir = entry.getRootDirectory();
        if (rootDir == null || !rootDir.canRead()) {
            return null;
        }
        ArrayList<HostEntry> arrayList = this._entries;
        synchronized (arrayList) {
            for (int i = 0; i < this._entries.size(); ++i) {
                HostEntry oldEntry = this._entries.get(i);
                if (!rootDir.equals(oldEntry.getRootDirectory())) continue;
                return oldEntry;
            }
            this._entries.add(entry);
        }
        return entry;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return new StringBuffer().append("HostRegexpDeploy[").append(this._config).append("]").toString();
    }
}

