/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.config.types.PathBuilder;
import com.caucho.log.Log;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostEntry;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostSingleDeploy
extends Deploy<HostEntry> {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/host/HostSingleDeploy"));
    private HostContainer _container;
    private Path _archivePath;
    private Path _rootDirectory;
    private HostConfig _config;
    private HostEntry _entry;

    public HostSingleDeploy(DeployContainer<HostEntry> container) {
        super(container);
    }

    public HostSingleDeploy(DeployContainer<HostEntry> container, HostContainer hostContainer, HostConfig config) throws Exception {
        super(container);
        this._container = hostContainer;
        this._config = config;
        Path serverRoot = hostContainer.getRootDirectory();
        String rootDir = config.getRootDirectory();
        this._rootDirectory = rootDir == null ? serverRoot : PathBuilder.lookupPath(rootDir, null, serverRoot);
        this._config = config;
        this.init();
    }

    public HostContainer getContainer() {
        return this._container;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this._container.getClassLoader();
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    public void init() {
        this._entry = new HostEntry(this._container, this._config);
        this._entry.setCfgRootDirectory(this._rootDirectory);
        this._entry.setArchivePath(this._archivePath);
        if (this._archivePath != null) {
            this._entry.addDepend(this._archivePath);
        }
        this._entry.setStartupMode(this._config.getStartupMode());
        this._entry.init();
    }

    @Override
    protected void fillDeployedKeys(Set<String> keys) {
        keys.add(this._entry.getName());
    }

    @Override
    public HostEntry generateEntry(String name) {
        if (this._entry.isNameMatch(name)) {
            return this._entry;
        }
        return null;
    }

    @Override
    public HostEntry mergeEntry(HostEntry entry, String name) {
        if (!this._entry.isNameMatch(name)) {
            return entry;
        }
        return entry.merge(this._entry);
    }

    public void deploy() {
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return new StringBuffer().append("HostDeploy[").append(this._config.getHostName()).append("]").toString();
    }
}

