/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.server.connection.AbstractHttpRequest;
import com.caucho.server.connection.AbstractHttpResponse;
import com.caucho.server.http.HttpRequest;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.http.Cookie;

public class HttpResponse
extends AbstractHttpResponse {
    static final byte[] _http10ok = "HTTP/1.0 200 OK".getBytes();
    static final byte[] _http11ok = "HTTP/1.1 200 OK".getBytes();
    static final byte[] _contentLengthBytes = "\r\nContent-Length: ".getBytes();
    static final byte[] _contentTypeBytes = "\r\nContent-Type: ".getBytes();
    static final byte[] _textHtmlBytes = "\r\nContent-Type: text/html".getBytes();
    static final byte[] _connectionCloseBytes = "\r\nConnection: close".getBytes();
    static byte[] _resinServerBytes = ("\r\nServer: Resin/" + Version.VERSION).getBytes();
    static final char[] _connectionCb = "Connection".toCharArray();
    static final CharBuffer _closeCb = new CharBuffer("Close");
    private HttpRequest _request;
    private final byte[] _dateBuffer = new byte[256];
    private int _dateBufferLength;
    private final CharBuffer _dateCharBuffer = new CharBuffer();
    private long _lastDate;

    HttpResponse(HttpRequest request) {
        super(request);
        this._request = request;
    }

    public void switchToRaw() throws IOException {
        this.clearBuffer();
        this.setStatus(101);
        this.finish();
    }

    public WriteStream getRawOutput() throws IOException {
        return this._rawWrite;
    }

    public boolean isTop() {
        if (!(this._request instanceof AbstractHttpRequest)) {
            return false;
        }
        return ((AbstractHttpRequest)this._request).isTop();
    }

    protected void writeContinueInt(WriteStream os) throws IOException {
        long now;
        os.print("HTTP/1.1 100 Continue");
        if (!this.containsHeader("Server")) {
            os.write(_resinServerBytes, 0, _resinServerBytes.length);
        }
        if (this._lastDate + 1000L < (now = Alarm.getCurrentTime())) {
            this.fillDate(now);
        }
        os.write(this._dateBuffer, 0, this._dateBufferLength);
    }

    protected boolean writeHeadersInt(WriteStream os, int length) throws IOException {
        boolean isChunked = false;
        int version = this._request.getVersion();
        boolean debug = log.isLoggable(Level.FINE);
        if (version < 256) {
            this._request.killKeepalive();
            return false;
        }
        int statusCode = this._statusCode;
        if (statusCode == 200) {
            if (version < 257) {
                os.write(_http10ok, 0, _http10ok.length);
            } else {
                os.write(_http11ok, 0, _http11ok.length);
            }
        } else {
            if (version < 257) {
                os.print("HTTP/1.0 ");
            } else {
                os.print("HTTP/1.1 ");
            }
            os.write(statusCode / 100 % 10 + 48);
            os.write(statusCode / 10 % 10 + 48);
            os.write(statusCode % 10 + 48);
            os.write(32);
            os.print(this._statusMessage);
        }
        if (debug) {
            log.fine(this._request.dbgId() + "HTTP/1.1 " + this._statusCode + " " + this._statusMessage);
        }
        if (!this.containsHeader("Server")) {
            os.write(_resinServerBytes, 0, _resinServerBytes.length);
        }
        if (statusCode >= 400) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
        } else if (this._isNoCache) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            os.print("\r\nCache-Control: no-cache");
            if (debug) {
                log.fine(this._request.dbgId() + "" + "Expires: Thu, 01 Dec 1994 16:00:00 GMT");
            }
        } else if (this.isPrivateCache()) {
            if (257 <= version) {
                os.print("\r\nCache-Control: private");
                if (debug) {
                    log.fine(this._request.dbgId() + "Cache-Control: private");
                }
            } else {
                this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
                os.print("\r\nCache-Control: no-cache");
                if (debug) {
                    log.fine(this._request.dbgId() + "" + "Expires: Thu, 01 Dec 1994 16:00:00 GMT");
                }
            }
        }
        int size = this._headerKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)this._headerKeys.get(i);
            os.write(13);
            os.write(10);
            os.print(key);
            os.write(58);
            os.write(32);
            os.print((String)this._headerValues.get(i));
            if (!debug) continue;
            log.fine(this._request.dbgId() + "" + key + ": " + (String)this._headerValues.get(i));
        }
        long now = Alarm.getCurrentTime();
        for (int i = 0; i < this._cookiesOut.size(); ++i) {
            Cookie cookie = (Cookie)this._cookiesOut.get(i);
            int cookieVersion = cookie.getVersion();
            CharBuffer cb = this._cb;
            this.fillCookie(cb, cookie, now, 0);
            os.print("\r\nSet-Cookie: ");
            os.print(cb.getBuffer(), 0, cb.getLength());
            if (cookieVersion > 0) {
                this.fillCookie(cb, cookie, now, cookieVersion);
                os.print("\r\nSet-Cookie2: ");
                os.print(cb.getBuffer(), 0, cb.getLength());
            }
            if (!debug) continue;
            log.fine(this._request.dbgId() + "Set-Cookie: " + cb);
        }
        String contentType = this._contentType;
        if (contentType == "text/html") {
            os.write(_textHtmlBytes, 0, _textHtmlBytes.length);
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Type: text/html");
            }
        } else if (contentType != null) {
            os.write(_contentTypeBytes, 0, _contentTypeBytes.length);
            os.print(contentType);
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Type: " + contentType);
            }
        }
        boolean hasContentLength = false;
        if (this._contentLength >= 0L) {
            os.write(_contentLengthBytes, 0, _contentLengthBytes.length);
            os.print(this._contentLength);
            hasContentLength = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Length: " + this._contentLength);
            }
        } else if (statusCode == 304 || statusCode == 204) {
            hasContentLength = true;
        } else if (length >= 0) {
            os.write(_contentLengthBytes, 0, _contentLengthBytes.length);
            os.print(length);
            hasContentLength = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Content-Length: " + length);
            }
        }
        if (version < 257) {
            this._request.killKeepalive();
        } else {
            CharSegment conn = this._request.getHeaderBuffer(_connectionCb, _connectionCb.length);
            if (conn != null && conn.equalsIgnoreCase(_closeCb)) {
                this._request.killKeepalive();
            } else if (!this._request.allowKeepalive()) {
                os.write(_connectionCloseBytes, 0, _connectionCloseBytes.length);
                this._request.killKeepalive();
                if (debug) {
                    log.fine(this._request.dbgId() + "Connection: close");
                }
            }
        }
        if (257 <= version && !hasContentLength) {
            os.print("\r\nTransfer-Encoding: chunked");
            isChunked = true;
            if (debug) {
                log.fine(this._request.dbgId() + "Transfer-Encoding: chunked");
            }
        }
        if (this._lastDate / 1000L != now / 1000L) {
            this.fillDate(now);
        }
        if (isChunked) {
            os.write(this._dateBuffer, 0, this._dateBufferLength - 2);
        } else {
            os.write(this._dateBuffer, 0, this._dateBufferLength);
        }
        return isChunked;
    }

    private void fillDate(long now) {
        if (this._lastDate / 60000L == now / 60000L) {
            this._lastDate = now;
            int sec = (int)(now / 1000L % 60L);
            int s2 = 48 + sec / 10;
            int s1 = 48 + sec % 10;
            this._dateBuffer[31] = (byte)s2;
            this._dateBuffer[32] = (byte)s1;
            return;
        }
        this._lastDate = now;
        this._calendar.setGMTTime(now);
        this._dateCharBuffer.clear();
        this._dateCharBuffer.append("\r\nDate: ");
        this._calendar.printDate(this._dateCharBuffer);
        char[] cb = this._dateCharBuffer.getBuffer();
        int len = this._dateCharBuffer.getLength();
        for (int i = len - 1; i >= 0; --i) {
            this._dateBuffer[i] = (byte)cb[i];
        }
        this._dateBuffer[len] = 13;
        this._dateBuffer[len + 1] = 10;
        this._dateBuffer[len + 2] = 13;
        this._dateBuffer[len + 3] = 10;
        this._dateBufferLength = len + 4;
    }
}

