/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.types.Period;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.jca.ResourceManagerImpl;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.security.PermissionManager;
import com.caucho.server.admin.PingThread;
import com.caucho.server.cache.AbstractCache;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterContainer;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationMatcher;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostExpandDeploy;
import com.caucho.server.http.HttpProtocol;
import com.caucho.server.log.AccessLog;
import com.caucho.server.port.AbstractSelectManager;
import com.caucho.server.port.Port;
import com.caucho.server.port.ProtocolDispatchServer;
import com.caucho.server.resin.ThreadPoolAdmin;
import com.caucho.server.resin.mbean.ServletServerMBean;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import javax.servlet.jsp.el.VariableResolver;
import org.iso_relax.verifier.Schema;

public class ServletServer
extends ProtocolDispatchServer
implements EnvironmentBean,
SchemaBean,
AlarmListener,
ClassLoaderListener,
ServletServerMBean {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/resin/ServletServer"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/resin/ServletServer"));
    private static final long ALARM_INTERVAL = 60000L;
    private static SoftReference<Schema> _schemaRef;
    private static final EnvironmentLocal<String> _serverIdLocal;
    private EnvironmentClassLoader _classLoader;
    private HashMap<String, Object> _variableMap = new HashMap();
    private VariableResolver _varResolver;
    private LinkedHashMap<String, String> _jmxContext;
    private HostContainer _hostContainer;
    private ObjectName _objectName;
    private String _serverId = "";
    private String _id = "";
    private String _url = "";
    private int _srunCount;
    private AccessLog _accessLog;
    private long _waitForActiveTime = 10000L;
    private ArrayList<Port> _ports = new ArrayList();
    private Alarm _alarm = new Alarm(this);
    private AbstractCache _cache;
    private volatile boolean _isStartedPorts;
    private final Lifecycle _lifecycle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletServer() throws Exception {
        this._classLoader = new EnhancingClassLoader();
        this._classLoader.setOwner(this);
        Environment.addClassLoaderListener(this, this._classLoader);
        this._jmxContext = Jmx.copyContextProperties();
        VariableResolver parentResolver = EL.getEnvironment();
        this._varResolver = new MapVariableResolver(this._variableMap, parentResolver);
        EL.setEnvironment(this._varResolver, this._classLoader);
        EL.setVariableMap(this._variableMap, this._classLoader);
        try {
            Method method = ClassLiteral.getClass((String)"com/caucho/naming/Jndi").getMethod("lookup", ClassLiteral.getClass((String)"java/lang/String"));
            this._variableMap.put("jndi:lookup", method);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this._variableMap.put("server", new Var());
        PermissionManager permissionManager = new PermissionManager();
        PermissionManager.setPermissionManager(permissionManager);
        String serverId = _serverIdLocal.get();
        if (serverId == null) {
            serverId = "";
        }
        this.setServerId(serverId);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            LinkedHashMap<String, String> props = Jmx.copyContextProperties();
            props.put("Server", "default");
            Jmx.setContextProperties(props);
            this._hostContainer = new HostContainer();
            this._hostContainer.setClassLoader(this._classLoader);
            this._hostContainer.setDispatchServer(this);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        try {
            Class<?> cl = Class.forName("com.caucho.server.port.JniSelectManager");
            Method method = cl.getMethod("create", new Class[0]);
            this.setSelectManager((AbstractSelectManager)method.invoke(null, null));
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString());
        }
        this._lifecycle = new Lifecycle(log, this.toString(), Level.INFO);
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._classLoader = loader;
        this._classLoader.setOwner(this);
    }

    public Schema getSchema() {
        Schema schema = null;
        if (_schemaRef == null || (schema = _schemaRef.get()) == null) {
            String schemaName = "com/caucho/server/resin/server.rnc";
            try {
                schema = CompactVerifierFactoryImpl.compileFromResource(schemaName);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
                log.warning(e.toString());
            }
            _schemaRef = new SoftReference<Schema>(schema);
        }
        return schema;
    }

    public void setId(String id) {
        if (id == null) {
            id = "";
        }
        this._id = id;
        LinkedHashMap<String, String> props = Jmx.copyContextProperties();
        if (this._id.equals("")) {
            props.put("Server", "default-server");
        } else {
            props.put("Server", this._id);
        }
        Jmx.setContextProperties(props);
    }

    public void setServerId(String serverId) {
        if (serverId == null) {
            serverId = "";
        }
        _serverIdLocal.set(serverId, this._classLoader);
        this._serverId = serverId;
        this._classLoader.setId("servlet-server:" + serverId);
        this._variableMap.put("serverId", serverId);
        if (this._lifecycle != null) {
            this._lifecycle.setName(this.toString());
        }
    }

    public String getServerId() {
        return this._serverId;
    }

    public void setRootDirectory(Path path) {
        this._hostContainer.setRootDirectory(path);
        Vfs.setPwd(path, this._classLoader);
        this._variableMap.put("root-dir", path);
        this._variableMap.put("server-root", path);
    }

    public Path getRootDirectory() {
        return this._hostContainer.getRootDirectory();
    }

    public void setRootDir(Path path) {
        this.setRootDirectory(path);
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._hostContainer.addWebAppDefault(init);
    }

    public void addHostDefault(HostConfig init) {
        this._hostContainer.addHostDefault(init);
    }

    public HostExpandDeploy createHostDeploy() {
        return this._hostContainer.createHostDeploy();
    }

    public void addHostDeploy(HostExpandDeploy deploy) {
        this._hostContainer.addHostDeploy(deploy);
    }

    public void addHost(HostConfig host) throws Exception {
        this._hostContainer.addHost(host);
    }

    public AbstractCache createCache() throws ConfigException {
        try {
            Class<?> cl = Class.forName("com.caucho.server.cache.Cache");
            this._cache = (AbstractCache)cl.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this._cache == null) {
            throw new ConfigException(L.l("<cache> requires Resin Professional.  Please see http://www.caucho.com for Resin Professional information and licensing."));
        }
        return this._cache;
    }

    public void setAccessLog(AccessLog log) {
        this._accessLog = log;
        Environment.setAttribute("caucho.server.access-log", log);
    }

    public long getDependencyCheckInterval() {
        return Environment.getDependencyCheckInterval(this.getClassLoader());
    }

    public void setSessionCookie(String cookie) {
        this.getInvocationDecoder().setSessionCookie(cookie);
    }

    public String getSessionCookie() {
        return this.getInvocationDecoder().getSessionCookie();
    }

    public void setSessionURLPrefix(String urlPrefix) {
        this.getInvocationDecoder().setSessionURLPrefix(urlPrefix);
    }

    public String getSessionURLPrefix() {
        return this.getInvocationDecoder().getSessionURLPrefix();
    }

    public void setAlternateSessionURLPrefix(String urlPrefix) throws ConfigException {
        this.getInvocationDecoder().setAlternateSessionURLPrefix(urlPrefix);
    }

    public String getAlternateSessionURLPrefix() {
        return this.getInvocationDecoder().getAlternateSessionURLPrefix();
    }

    public void setURLCharacterEncoding(String encoding) throws ConfigException {
        this.getInvocationDecoder().setEncoding(encoding);
    }

    public void addPing(PingThread ping) throws ConfigException {
        ResourceManagerImpl.addResource(ping);
    }

    public void setKeepaliveMax(int max) {
        AbstractSelectManager selectManager = this.getSelectManager();
        if (selectManager != null) {
            selectManager.setSelectMax(max);
        }
    }

    public void setKeepaliveTimeout(Period period) {
        AbstractSelectManager selectManager = this.getSelectManager();
        if (selectManager != null) {
            selectManager.setSelectTimeout(period.getPeriod());
        }
    }

    public void buildInvocation(Invocation invocation) throws Throwable {
        if (this._lifecycle.waitForActive(this._waitForActiveTime)) {
            this._hostContainer.buildInvocation(invocation);
        } else {
            int code = 503;
            invocation.setFilterChain(new ErrorFilterChain(code));
            invocation.setDependency(AlwaysModified.create());
        }
    }

    public String getServletPattern(String hostName, int port, String url) {
        try {
            Host host = this._hostContainer.getHost(hostName, port);
            if (host == null) {
                return null;
            }
            Application app = host.findApplicationByURI(url);
            if (app == null) {
                return null;
            }
            String pattern = app.getServletPattern(url);
            return pattern;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public Application getApplication(String hostName, int port, String url) {
        try {
            Host host = this._hostContainer.getHost(hostName, port);
            if (host == null) {
                return null;
            }
            return host.findApplicationByURI(url);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public Host getHost(String hostName, int port) {
        try {
            return this._hostContainer.getHost(hostName, port);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    public void addHttp(Port port) throws Exception {
        if (this._url.equals("") && this._serverId.equals(port.getServerId())) {
            this._url = port.getHost() == null || port.getHost().equals("") || port.getHost().equals("*") ? "http://localhost" : "http://" + port.getHost();
            if (port.getPort() != 0) {
                this._url = this._url + ":" + port.getPort();
            }
            if (this._hostContainer != null) {
                this._hostContainer.setURL(this._url);
            }
        }
        if (port.getProtocol() == null) {
            HttpProtocol protocol = new HttpProtocol();
            protocol.setParent(port);
            port.setProtocol(protocol);
        }
        this.addPort(port);
    }

    public void addPort(Port port) throws Exception {
        this._ports.add(port);
    }

    public ObjectName[] getPortObjectNames() {
        ObjectName[] portNames = new ObjectName[this._ports.size()];
        for (int i = 0; i < this._ports.size(); ++i) {
            portNames[i] = this._ports.get(i).getObjectName();
        }
        return portNames;
    }

    public ObjectName[] getClusterObjectNames() {
        ClusterContainer clusterContainer = ClusterContainer.getLocal();
        if (clusterContainer == null) {
            return new ObjectName[0];
        }
        ArrayList<Cluster> clusterList = clusterContainer.getClusterList();
        ObjectName[] clusterNames = new ObjectName[clusterList.size()];
        for (int i = 0; i < clusterList.size(); ++i) {
            Cluster subCluster = clusterList.get(i);
            clusterNames[i] = subCluster.getObjectName();
        }
        return clusterNames;
    }

    public void addSrun(Object object) throws ConfigException {
        throw new ConfigException(L.l("<srun> must be in a <cluster> for Resin 3.0.  See http://www.caucho.com/resin-3.0/config/balance.xtp for the new syntax."));
    }

    public void classLoaderInit(DynamicClassLoader loader) {
        try {
            Jmx.register((Object)this, "resin:type=Server,name=default");
            ThreadPoolAdmin threadPoolAdmin = new ThreadPoolAdmin();
            Jmx.register((Object)threadPoolAdmin, "resin:type=ThreadPool");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        try {
            Jmx.unregister("resin:name=default,type=Server");
            Jmx.unregister("resin:type=ThreadPool");
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
        }
    }

    public void init() {
        this._classLoader.init();
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindPorts() throws Exception {
        ServletServer servletServer = this;
        synchronized (servletServer) {
            if (this._isStartedPorts) {
                return;
            }
            this._isStartedPorts = true;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            for (int i = 0; i < this._ports.size(); ++i) {
                Port port = this._ports.get(i);
                if (!this._serverId.equals(port.getServerId())) continue;
                port.bind();
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            ClusterContainer clusterContainer;
            thread.setContextClassLoader(this._classLoader);
            if (!this._lifecycle.toStarting()) {
                return;
            }
            AbstractSelectManager selectManager = this.getSelectManager();
            if (selectManager != null) {
                selectManager.start();
            }
            this.bindPorts();
            Cluster cluster = Cluster.getLocal();
            if (cluster == null) {
                cluster = new Cluster();
                cluster.init();
            }
            if ((clusterContainer = ClusterContainer.getLocal()) != null) {
                ArrayList<Cluster> clusterList = clusterContainer.getClusterList();
                for (int i = 0; i < clusterList.size(); ++i) {
                    Cluster subCluster = clusterList.get(i);
                    ArrayList<ClusterPort> clusterPorts = subCluster.getServerPorts(this._serverId);
                    for (int j = 0; j < clusterPorts.size(); ++j) {
                        ClusterPort port = clusterPorts.get(j);
                        port.setServer(this);
                        this.addPort(port);
                    }
                }
            }
            for (int i = 0; i < this._ports.size(); ++i) {
                Port port = this._ports.get(i);
                if (!this._serverId.equals(port.getServerId())) continue;
                port.start();
            }
            this._lifecycle.toActive();
            this._classLoader.start();
            this._hostContainer.start();
            this._alarm.queue(60000L);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        if (!this._lifecycle.isActive()) {
            return;
        }
        try {
            long now = Alarm.getCurrentTime();
            if (this.isModified()) {
                log.info("Resin restarting due to configuration change");
                this.stop();
                this.destroy();
                return;
            }
            try {
                for (int i = 0; i < this._ports.size(); ++i) {
                    Port port = this._ports.get(i);
                    if (!port.isClosed()) continue;
                    log.info("Resin restarting due to closed port: " + port);
                    this.destroy();
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                this.destroy();
                alarm.queue(60000L);
                return;
            }
        }
        finally {
            alarm.queue(60000L);
        }
    }

    public boolean isModified() {
        boolean isModified = this._classLoader.isModified();
        if (isModified) {
            log.fine("servlet server is modified");
        }
        return isModified;
    }

    public boolean isStopped() {
        return this._lifecycle.isStopped();
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public void clearCacheByPattern(String hostPattern, String uriPattern) {
        final Matcher hostMatcher = hostPattern != null ? Pattern.compile(hostPattern).matcher("") : null;
        final Matcher uriMatcher = uriPattern != null ? Pattern.compile(uriPattern).matcher("") : null;
        InvocationMatcher matcher = new InvocationMatcher(){

            public boolean isMatch(Invocation invocation) {
                if (hostMatcher != null) {
                    hostMatcher.reset(invocation.getHost());
                    if (!hostMatcher.find()) {
                        return false;
                    }
                }
                if (uriMatcher != null) {
                    uriMatcher.reset(invocation.getURI());
                    if (!uriMatcher.find()) {
                        return false;
                    }
                }
                return true;
            }
        };
        this.invalidateMatchingInvocations(matcher);
    }

    public void clearCache() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("ServletServer clearCache");
        }
        super.clearCache();
    }

    public long getProxyCacheHitCount() {
        if (this._cache != null) {
            return this._cache.getHitCount();
        }
        return 0L;
    }

    public long getProxyCacheMissCount() {
        if (this._cache != null) {
            return this._cache.getMissCount();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            if (!this._lifecycle.toStopping()) {
                return;
            }
            super.stop();
            Alarm alarm = this._alarm;
            this._alarm = null;
            if (alarm != null) {
                alarm.dequeue();
            }
            if (this.getSelectManager() != null) {
                this.getSelectManager().stop();
            }
            for (int i = 0; i < this._ports.size(); ++i) {
                Port port = this._ports.get(i);
                try {
                    port.close();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            try {
                ThreadPool.interrupt();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                Thread.yield();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this._hostContainer.stop();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                this._classLoader.stop();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            this._lifecycle.toStop();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._classLoader);
            try {
                this._hostContainer.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            super.destroy();
            log.fine(this + " destroyed");
            this._classLoader.destroy();
            this._hostContainer = null;
            this._ports = null;
            this._variableMap = null;
            this._varResolver = null;
            this._accessLog = null;
            this._cache = null;
        }
        finally {
            DynamicClassLoader.setOldLoader(thread, oldLoader);
        }
    }

    public String toString() {
        return "ServletServer[" + this._serverId + "]";
    }

    static {
        _serverIdLocal = new EnvironmentLocal("caucho.server-id");
    }

    public class Var {
        public String getId() {
            return ServletServer.this._serverId;
        }

        public Path getRootDir() {
            return ServletServer.this._hostContainer.getRootDirectory();
        }

        public String toString() {
            return ServletServer.this.toString();
        }
    }
}

