/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.security;

import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.security.AbstractConstraint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityFilterChain
implements FilterChain {
    private FilterChain _next;
    private ServletContext _application;
    private AbstractConstraint[] _constraints;
    private HashMap<String, AbstractConstraint[]> _methodMap;

    SecurityFilterChain(FilterChain next) {
        this._next = next;
    }

    public void setApplication(ServletContext app) {
        this._application = app;
    }

    public void setConstraints(ArrayList<AbstractConstraint> constraints) {
        this._constraints = new AbstractConstraint[constraints.size()];
        constraints.toArray(this._constraints);
    }

    public void setMethodMap(HashMap<String, AbstractConstraint[]> methodMap) {
        this._methodMap = methodMap;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        CauchoRequest req = (CauchoRequest)request;
        CauchoResponse res = (CauchoResponse)response;
        AbstractConstraint[] constraints = null;
        if (this._methodMap != null) {
            constraints = this._methodMap.get(req.getMethod());
        }
        if (constraints == null) {
            constraints = this._constraints;
        }
        boolean isPrivateCache = false;
        if (constraints != null) {
            boolean hasAuth = false;
            for (int i = 0; i < constraints.length; ++i) {
                if (!hasAuth && constraints[i].needsAuthentication()) {
                    hasAuth = true;
                    if (!req.authenticate()) {
                        return;
                    }
                }
                if (!constraints[i].isAuthorized(req, res, this._application)) {
                    return;
                }
                if (!constraints[i].isPrivateCache()) continue;
                isPrivateCache = true;
            }
        }
        if (isPrivateCache) {
            res.setPrivateCache(true);
        }
        this._next.doFilter(request, response);
    }
}

