/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.make.AlwaysModified;
import com.caucho.server.deploy.Deploy;
import com.caucho.server.deploy.DeployContainer;
import com.caucho.server.dispatch.DispatchBuilder;
import com.caucho.server.dispatch.DispatchServer;
import com.caucho.server.dispatch.ErrorFilterChain;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarDeploy;
import com.caucho.server.e_app.EarEntry;
import com.caucho.server.log.AccessLog;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.ContextFilterChain;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.RequestDispatcherImpl;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppEarDeploy;
import com.caucho.server.webapp.WebAppEntry;
import com.caucho.server.webapp.WebAppExpandDeploy;
import com.caucho.server.webapp.WebAppRegexpDeploy;
import com.caucho.server.webapp.WebAppSingleDeploy;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationContainer
implements DispatchBuilder,
ClassLoaderListener,
EnvironmentListener {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/webapp/Application"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/ApplicationContainer"));
    private DispatchServer _dispatchServer;
    private EnvironmentClassLoader _classLoader;
    private Path _rootDir;
    private Path _docDir;
    private ArrayList<EarConfig> _earDefaultList = new ArrayList();
    private DeployContainer<EarEntry> _earDeploy;
    private DeployContainer<WebAppEntry> _appDeploy;
    private WebAppExpandDeploy _warGenerator;
    private boolean _hasWarGenerator;
    private ArrayList<WebAppConfig> _webAppDefaultList = new ArrayList();
    private HashMap<String, WebAppConfig> _configAppMap = new HashMap();
    private AccessLog _accessLog;
    private ErrorPageManager _errorPageManager;
    private long _startWaitTime = 10000L;
    private Throwable _configException;
    private final Lifecycle _lifecycle = new Lifecycle();

    public ApplicationContainer() {
        this((EnvironmentClassLoader)Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContainer(EnvironmentClassLoader loader) {
        this._rootDir = Vfs.lookup();
        this._docDir = Vfs.lookup();
        this._classLoader = loader;
        this._errorPageManager = new ErrorPageManager();
        this._errorPageManager.setApplicationContainer(this);
        Environment.addEnvironmentListener(this, loader);
        Environment.addClassLoaderListener(this, loader);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            this._earDeploy = new DeployContainer();
            this._appDeploy = new DeployContainer();
            this._warGenerator = new WebAppExpandDeploy(this._appDeploy);
            this._warGenerator.setContainer(this);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void setDispatchServer(DispatchServer server) {
        this._dispatchServer = server;
    }

    public DispatchServer getDispatchServer() {
        return this._dispatchServer;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._classLoader = loader;
    }

    public Path getRootDirectory() {
        return this._rootDir;
    }

    public void setRootDirectory(Path path) {
        this._rootDir = path;
        Vfs.setPwd(path, this.getClassLoader());
    }

    public Path getDocumentDirectory() {
        return this._docDir;
    }

    public void setDocumentDirectory(Path path) {
        this._docDir = path;
    }

    public void setDocDir(Path path) {
        this.setDocumentDirectory(path);
    }

    public void setAccessLog(AccessLog log) {
        this._accessLog = log;
        Environment.setAttribute("caucho.server.access-log", log);
    }

    public void addErrorPage(ErrorPage errorPage) {
        this._errorPageManager.addErrorPage(errorPage);
    }

    public ErrorPageManager getErrorPageManager() {
        return this._errorPageManager;
    }

    public void setConfigException(Throwable e) {
        this._configException = e;
    }

    public DeployContainer<WebAppEntry> getApplicationGenerator() {
        return this._appDeploy;
    }

    public SessionManager getSessionManager() {
        return null;
    }

    public boolean isModified() {
        return this._lifecycle.isDestroyed() || this._classLoader.isModified();
    }

    public void addWebApp(WebAppConfig config) throws Exception {
        if (config.getURLRegexp() != null) {
            WebAppRegexpDeploy deploy = new WebAppRegexpDeploy(this._appDeploy, this, config);
            this._appDeploy.add(deploy);
            return;
        }
        WebAppEntry oldEntry = this._appDeploy.findEntry(config.getContextPath());
        if (oldEntry != null && oldEntry.getSourceType().equals("single")) {
            throw new ConfigException(L.l("duplicate web-app '{0}' forbidden.", config.getId()));
        }
        WebAppSingleDeploy deploy = new WebAppSingleDeploy(this._appDeploy, this, config);
        deploy.deploy();
        this._appDeploy.add(deploy);
    }

    void removeWebApp(WebAppEntry entry) {
        this._appDeploy.remove(entry.getContextPath());
        this.clearCache();
    }

    public void addWebAppDefault(WebAppConfig init) {
        this._webAppDefaultList.add(init);
    }

    public ArrayList<WebAppConfig> getWebAppDefaultList() {
        return this._webAppDefaultList;
    }

    public WebAppExpandDeploy createWebAppDeploy() {
        return new WebAppExpandDeploy(this._appDeploy);
    }

    public void addWebAppDeploy(WebAppExpandDeploy deploy) throws ConfigException {
        WebAppExpandDeploy webAppDeploy = deploy;
        webAppDeploy.setContainer(this);
        if (!this._hasWarGenerator) {
            this._hasWarGenerator = true;
            this._warGenerator = webAppDeploy;
        }
        this._appDeploy.add(deploy);
    }

    public void addDeploy(Deploy deploy) throws ConfigException {
        if (deploy instanceof WebAppExpandDeploy) {
            this.addWebAppDeploy((WebAppExpandDeploy)deploy);
        } else {
            this._appDeploy.add(deploy);
        }
    }

    public void removeWebAppDeploy(Deploy deploy) {
        this._appDeploy.remove(deploy);
    }

    public void updateWebAppDeploy(String name) {
        this.clearCache();
        this._appDeploy.update();
        this._appDeploy.update(name);
    }

    public void updateEarDeploy(String name) {
        this.clearCache();
        this._earDeploy.update();
        EarEntry entry = this._earDeploy.update(name);
        if (entry != null) {
            entry.start();
        }
    }

    public void addEarDefault(EarConfig init) {
        this._earDefaultList.add(init);
    }

    public ArrayList<EarConfig> getEarDefaultList() {
        return this._earDefaultList;
    }

    public EarDeploy createEarDeploy() throws Exception {
        return new EarDeploy(this._earDeploy, this);
    }

    public void addEarDeploy(EarDeploy earDeploy) throws Exception {
        this._appDeploy.add(new WebAppEarDeploy(this._appDeploy, this, earDeploy));
        this._earDeploy.add(earDeploy);
    }

    public String getURL() {
        return "";
    }

    public String getHostName() {
        return "";
    }

    public void setWarDir(Path warDir) throws ConfigException {
        this._warGenerator.setPath(warDir);
        if (!this._hasWarGenerator) {
            this._hasWarGenerator = true;
            this.addWebAppDeploy(this._warGenerator);
        }
    }

    public Path getWarDir() {
        return this._warGenerator.getPath();
    }

    public void setWarExpandDir(Path warDir) {
        this._warGenerator.setExpandDirectory(warDir);
    }

    public Path getWarExpandDir() {
        return this._warGenerator.getExpandDirectory();
    }

    public void init() throws Exception {
        if (!this._lifecycle.toInitializing()) {
            return;
        }
        log.fine(new StringBuffer().append(this).append(" initializing").toString());
        this._lifecycle.toInit();
    }

    protected void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            this._earDeploy.start();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        try {
            this._appDeploy.start();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void clearCache() {
        if (this._dispatchServer != null) {
            this._dispatchServer.clearCache();
        }
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        if (url == null) {
            throw new IllegalArgumentException(L.l("request dispatcher url can't be null."));
        }
        if (!url.startsWith("/")) {
            throw new IllegalArgumentException(L.l("request dispatcher url `{0}' must be absolute", url));
        }
        Invocation includeInvocation = new Invocation();
        Invocation forwardInvocation = new Invocation();
        Invocation errorInvocation = new Invocation();
        InvocationDecoder decoder = new InvocationDecoder();
        String rawURI = url;
        try {
            decoder.splitQuery(includeInvocation, rawURI);
            decoder.splitQuery(forwardInvocation, rawURI);
            decoder.splitQuery(errorInvocation, rawURI);
            this.buildIncludeInvocation(includeInvocation);
            this.buildForwardInvocation(forwardInvocation);
            this.buildErrorInvocation(errorInvocation);
            RequestDispatcherImpl disp = new RequestDispatcherImpl(includeInvocation, forwardInvocation, errorInvocation, this.getApplication(includeInvocation, false));
            return disp;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    @Override
    public void buildInvocation(Invocation invocation) throws Exception {
        if (this._configException != null) {
            ExceptionFilterChain chain = new ExceptionFilterChain(this._configException);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return;
        }
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            int code = 503;
            ErrorFilterChain chain = new ErrorFilterChain(code);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return;
        }
        Application app = this.getApplication(invocation, true);
        if (app != null) {
            app.buildInvocation(invocation);
        } else {
            int code = 404;
            ErrorFilterChain chain = new ErrorFilterChain(code);
            ContextFilterChain contextChain = new ContextFilterChain(chain);
            contextChain.setErrorPageManager(this._errorPageManager);
            invocation.setFilterChain(contextChain);
            invocation.setDependency(AlwaysModified.create());
        }
    }

    public void buildIncludeInvocation(Invocation invocation) throws ServletException {
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            int code = 503;
            ErrorFilterChain chain = new ErrorFilterChain(code);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return;
        }
        Application app = this.getApplication(invocation, false);
        if (app == null) {
            throw new ServletException(L.l("`{0}' is an unspecified web-app.", invocation.getURI()));
        }
        app.buildIncludeInvocation(invocation);
    }

    public void buildForwardInvocation(Invocation invocation) throws ServletException {
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            int code = 503;
            ErrorFilterChain chain = new ErrorFilterChain(code);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return;
        }
        Application app = this.getApplication(invocation, false);
        if (app == null) {
            throw new ServletException(L.l("`{0}' is an unspecified web-app.", invocation.getURI()));
        }
        app.buildForwardInvocation(invocation);
    }

    public void buildErrorInvocation(Invocation invocation) throws ServletException {
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            int code = 503;
            ErrorFilterChain chain = new ErrorFilterChain(code);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return;
        }
        Application app = this.getApplication(invocation, false);
        if (app == null) {
            throw new ServletException(L.l("`{0}' is an unspecified web-app.", invocation.getURI()));
        }
        app.buildErrorInvocation(invocation);
    }

    public void buildLoginInvocation(Invocation invocation) throws ServletException {
        if (!this._lifecycle.waitForActive(this._startWaitTime)) {
            int code = 503;
            ErrorFilterChain chain = new ErrorFilterChain(code);
            invocation.setFilterChain(chain);
            invocation.setDependency(AlwaysModified.create());
            return;
        }
        Application app = this.getApplication(invocation, false);
        if (app == null) {
            throw new ServletException(L.l("`{0}' is an unspecified web-app.", invocation.getURI()));
        }
        app.buildLoginInvocation(invocation);
    }

    private Application getApplication(Invocation invocation, boolean enableRedeploy) throws ServletException {
        WebAppEntry entry = this.findByURI(invocation.getURI());
        try {
            if (entry != null) {
                String invocationURI = invocation.getURI();
                String contextPath = entry.getContextPath(invocationURI);
                invocation.setContextPath(invocationURI.substring(0, contextPath.length()));
                String uri = invocationURI.substring(contextPath.length());
                invocation.setContextURI(uri);
                Application app = (Application)entry.createLazyInstance(enableRedeploy);
                if (app == null) {
                    return null;
                }
                invocation.setApplication(app);
                return app;
            }
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Application findApplicationByURI(String uri) throws Exception {
        WebAppEntry entry = this.findByURI(uri);
        if (entry != null) {
            return (Application)entry.createLazyInstance();
        }
        return null;
    }

    public WebAppEntry findByURI(String uri) {
        if (CauchoSystem.isCaseInsensitive()) {
            uri = uri.toLowerCase();
        }
        int uriLength = uri.length();
        String subURI = uri;
        while (true) {
            WebAppEntry entry;
            if ((entry = this._appDeploy.findEntry(subURI)) != null) {
                return entry;
            }
            int p = subURI.lastIndexOf(47);
            if (p < 0) break;
            subURI = subURI.substring(0, p);
        }
        return null;
    }

    public ArrayList<WebAppEntry> getApplicationList() {
        return this._appDeploy.getEntries();
    }

    public ArrayList<EarEntry> getEntAppList() {
        return this._earDeploy.getEntries();
    }

    public final boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public final boolean isActive() {
        return this._lifecycle.isActive();
    }

    public boolean stop() {
        if (!this._lifecycle.toStop()) {
            return false;
        }
        this._earDeploy.stop();
        this._appDeploy.stop();
        return true;
    }

    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._earDeploy.destroy();
        this._appDeploy.destroy();
    }

    @Override
    public void classLoaderInit(DynamicClassLoader loader) {
    }

    @Override
    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.destroy();
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }
}

