/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.BuilderProgram;
import com.caucho.config.ConfigException;
import com.caucho.config.types.PathBuilder;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.log.Log;
import com.caucho.relaxng.CompactVerifierFactoryImpl;
import com.caucho.server.deploy.ExpandEntry;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.server.webapp.ApplicationContainer;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.mbean.WebAppMBean;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import org.iso_relax.verifier.Schema;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppEntry
extends ExpandEntry<Application>
implements EnvironmentListener {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/webapp/WebAppEntry"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/webapp/WebAppEntry"));
    private static Schema _webXmlSchema;
    private ApplicationContainer _container;
    private WebAppEntry _parent;
    private String _id;
    private String _contextPath;
    private LinkedHashMap<String, String> _jmxContext;
    private Object _mbean;
    private ObjectName _mbeanName;
    private ArrayList<WebAppConfig> _webAppDefaults = new ArrayList();
    private WebAppConfig _config;
    private BuilderProgram _initProgram;
    private VariableResolver _variableResolver;
    private HashMap<String, Object> _variableMap = new HashMap();
    private ArrayList<String> _regexpValues;
    private Application _app;
    private boolean _isInheritSession;
    private boolean _isDynamicDeploy;
    private ArrayList<Path> _dependPathList = new ArrayList();
    private boolean _isInit;
    private String _sourceType = "unknown";

    public WebAppEntry(ApplicationContainer container, String contextPath) {
        this._container = container;
        this.setId(contextPath);
        if (contextPath.length() > 0 && !contextPath.startsWith("/")) {
            contextPath = new StringBuffer().append('/').append(contextPath).toString();
        }
        this.setName(contextPath);
        if (contextPath.equals("/ROOT") || CauchoSystem.isCaseInsensitive() && contextPath.equalsIgnoreCase("/root") || contextPath.equals("/")) {
            contextPath = "";
        }
        this.setContextPath(contextPath);
        if (contextPath.equals("")) {
            if (CauchoSystem.isCaseInsensitive()) {
                this.setId("root");
            } else {
                this.setId("ROOT");
            }
        }
        VariableResolver parentResolver = EL.getEnvironment(this.getParentClassLoader());
        this._variableResolver = new MapVariableResolver(this._variableMap, parentResolver);
        this._jmxContext = Jmx.copyContextProperties(this.getParentClassLoader());
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public void setContextPath(String contextPath) {
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            contextPath = new StringBuffer().append("/").append(contextPath).toString();
        }
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        this._contextPath = contextPath;
    }

    public String getContextPath(String uri) {
        if (this._config == null || this._config.getURLRegexp() == null) {
            return this._contextPath;
        }
        Pattern regexp = this._config.getURLRegexp();
        Matcher matcher = regexp.matcher(uri);
        int tail = 0;
        while (tail >= 0 && tail <= uri.length()) {
            String prefix = uri.substring(0, tail);
            matcher.reset(prefix);
            if (matcher.find() && matcher.start() == 0) {
                return matcher.group();
            }
            if (tail >= uri.length()) break;
            if ((tail = uri.indexOf(47, tail + 1)) >= 0) continue;
            tail = uri.length();
        }
        return this._contextPath;
    }

    public String getURL() {
        if (this._parent != null) {
            return new StringBuffer().append(this._parent.getURL()).append(this._contextPath).toString();
        }
        return this._contextPath;
    }

    public WebAppEntry getParent() {
        return this._parent;
    }

    public void setParentWebApp(WebAppEntry parent) {
        this._parent = parent;
    }

    public String getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(String type) {
        this._sourceType = type;
    }

    public void setWebAppConfig(WebAppConfig config) {
        this._config = config;
        if (config != null) {
            this.addWebAppDefault(config);
        }
    }

    public WebAppConfig getWebAppConfig() {
        return this._config;
    }

    public void addWebAppDefault(WebAppConfig config) {
        if (!this._webAppDefaults.contains(config)) {
            this._webAppDefaults.add(config);
            if (config.getStartupMode() != null) {
                this.setStartupMode(config.getStartupMode());
            }
            if (config.getRedeployMode() != null) {
                this.setRedeployMode(config.getRedeployMode());
            }
        }
    }

    public HashMap<String, Object> getVariableMap() {
        return this._variableMap;
    }

    public void setRegexpValues(ArrayList<String> values) {
        this._regexpValues = values;
    }

    public boolean isInheritSession() {
        return this._isInheritSession;
    }

    public void setInheritSession(boolean inheritSession) {
        this._isInheritSession = inheritSession;
    }

    public String getState() {
        if (this._app == null) {
            return "stopped";
        }
        return this._app.getState();
    }

    public BuilderProgram getInitProgram() {
        return this._initProgram;
    }

    public void setInitProgram(BuilderProgram initProgram) {
        this._initProgram = initProgram;
    }

    public Application getApplication() {
        return this._app;
    }

    public void setDynamicDeploy(boolean isDynamicDeploy) {
        this._isDynamicDeploy = isDynamicDeploy;
    }

    public boolean isDynamicDeploy() {
        return this._isDynamicDeploy;
    }

    Object getMBean() {
        return this._mbean;
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        try {
            if (this._mbeanName == null) {
                LinkedHashMap<String, String> properties = Jmx.copyContextProperties(this._container.getClassLoader());
                String name = this._contextPath;
                if (this._contextPath.equals("")) {
                    name = "/";
                }
                properties.put("type", "WebApp");
                properties.put("name", name);
                this._mbean = new IntrospectionMBean(new Admin(), ClassLiteral.getClass((String)"com/caucho/server/webapp/mbean/WebAppMBean"));
                this._mbeanName = Jmx.getObjectName("resin", properties);
                Jmx.register(this._mbean, this._mbeanName);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return true;
    }

    @Override
    public boolean isNameMatch(String url) {
        if (CauchoSystem.isCaseInsensitive()) {
            return url.equalsIgnoreCase(this._contextPath);
        }
        return url.equals(this._contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebAppEntry merge(WebAppEntry newEntry) {
        if (this._config != null && this._config.getURLRegexp() != null) {
            return newEntry;
        }
        if (newEntry._config != null && newEntry._config.getURLRegexp() != null) {
            return this;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            WebAppEntry mergedEntry = new WebAppEntry(this._container, this._contextPath);
            mergedEntry.setRootDirectory(this.getRootDirectory());
            mergedEntry._webAppDefaults.addAll(this._webAppDefaults);
            mergedEntry._webAppDefaults.addAll(newEntry._webAppDefaults);
            if (newEntry._config != null) {
                mergedEntry._webAppDefaults.add(newEntry._config);
            }
            mergedEntry._config = this._config;
            if (newEntry._config != null) {
                this._config = newEntry._config;
            }
            if (this.getArchivePath() != null) {
                mergedEntry.setArchivePath(this.getArchivePath());
            }
            if (newEntry.getArchivePath() != null) {
                mergedEntry.setArchivePath(newEntry.getArchivePath());
            }
            mergedEntry.setStartupMode(this.getStartupMode());
            mergedEntry.mergeStartupMode(newEntry.getStartupMode());
            mergedEntry.setRedeployMode(this.getRedeployMode());
            mergedEntry.mergeRedeployMode(newEntry.getRedeployMode());
            WebAppEntry webAppEntry = mergedEntry;
            return webAppEntry;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroy() {
        if (!super.destroy()) {
            return false;
        }
        Environment.removeEnvironmentListener(this, this.getParentClassLoader());
        this._container.removeWebApp(this);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            try {
                ObjectName mbeanName = this._mbeanName;
                this._mbeanName = null;
                if (mbeanName != null) {
                    Jmx.unregister(mbeanName);
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
            WebAppEntry webAppEntry = this;
            synchronized (webAppEntry) {
                Application app = this._app;
                if (this._isInit && app != null) {
                    this._app = null;
                    this._isInit = false;
                    app.destroy();
                }
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return true;
    }

    protected void protectedWebApp() throws Exception {
        Path root = this.getRootDirectory();
        root.lookup("WEB-INF").chmod(488);
        root.lookup("META-INF").chmod(488);
    }

    protected void addDependencies() throws Exception {
    }

    public void setApplication(Application application) {
        this._app = application;
    }

    public void addDepend(Path path) {
        this._dependPathList.add(path);
    }

    @Override
    protected Application instantiateDeployInstance() {
        return new Application(this._container, this, this._contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInstance(Application app) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        Path appDir = null;
        try {
            int i;
            thread.setContextClassLoader(app.getClassLoader());
            log.fine(new StringBuffer().append(app).append(" initializing").toString());
            Map<String, Object> varMap = app.getVariableMap();
            varMap.putAll(this._variableMap);
            app.setRegexp(this._regexpValues);
            this._app = app;
            app.setDynamicDeploy(this.isDynamicDeploy());
            appDir = this.getAppDir();
            if (appDir == null) {
                throw new NullPointerException("Null app dir");
            }
            if (appDir.isFile()) {
                if (appDir.getPath().endsWith(".jar") || appDir.getPath().endsWith(".war")) {
                    throw new ConfigException(L.l("document-directory `{0}' must specify a directory.  It may not be a .jar or .war.", appDir.getPath()));
                }
                throw new ConfigException(L.l("app-dir `{0}' may not be a file.  app-dir must specify a directory.", appDir.getPath()));
            }
            app.setAppDir(appDir);
            varMap.put("app-dir", appDir);
            ArrayList<WebAppConfig> initList = new ArrayList<WebAppConfig>();
            if (this._container != null) {
                ArrayList<WebAppConfig> defaultList = this._container.getWebAppDefaultList();
                for (int i2 = 0; i2 < defaultList.size(); ++i2) {
                    WebAppConfig init = defaultList.get(i2);
                    initList.add(init);
                }
            }
            for (i = 0; i < this._webAppDefaults.size(); ++i) {
                WebAppConfig init = this._webAppDefaults.get(i);
                initList.add(init);
            }
            thread.setContextClassLoader(app.getClassLoader());
            Vfs.setPwd(appDir);
            for (i = 0; i < this._dependPathList.size(); ++i) {
                Path path = this._dependPathList.get(i);
                Environment.addDependency(path);
            }
            if (this.getArchivePath() != null) {
                Environment.addDependency(this.getArchivePath());
            }
            this.addDependencies();
            for (i = 0; i < initList.size(); ++i) {
                WebAppConfig config = (WebAppConfig)initList.get(i);
                BuilderProgram program = config.getBuilderProgram();
                if (program == null) continue;
                program.configure(app);
            }
            app.init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected Path getAppDir() throws ELException {
        String path;
        Path appDir = null;
        if (appDir == null) {
            appDir = this.getRootDirectory();
        }
        if (appDir == null && this._config != null && (path = this._config.getAppDir()) != null) {
            appDir = PathBuilder.lookupPath(path, this._variableResolver);
        }
        if (appDir == null && this._container != null) {
            appDir = this._container.getDocumentDirectory().lookup(new StringBuffer().append("./").append(this._contextPath).toString());
        }
        if (appDir == null && this._app != null) {
            appDir = this._app.getAppDir();
        }
        return appDir;
    }

    @Override
    protected void removeExpandFile(Path path, String relPath) throws IOException {
        if (relPath.equals("./WEB-INF/resin-web.xml")) {
            return;
        }
        super.removeExpandFile(path, relPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getWebXmlSchema() {
        block6: {
            if (_webXmlSchema == null) {
                try {
                    MergePath schemaPath = new MergePath();
                    schemaPath.addClassPath();
                    Path path = schemaPath.lookup("com/caucho/server/webapp/resin-web-xml.rnc");
                    if (!path.canRead()) break block6;
                    ReadStream is = path.openRead();
                    try {
                        CompactVerifierFactoryImpl factory = new CompactVerifierFactoryImpl();
                        _webXmlSchema = factory.compileSchema(is);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        return _webXmlSchema;
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) {
        try {
            this.start();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("WebAppEntry$").append(System.identityHashCode(this)).append("[").append(this._contextPath).append("]").toString();
    }

    public class Admin
    implements WebAppMBean {
        public String getRootDirectory() {
            try {
                Path path = WebAppEntry.this.getAppDir();
                if (path != null) {
                    return path.getNativePath();
                }
                return null;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                return null;
            }
        }

        public String getContextPath() {
            return WebAppEntry.this._contextPath;
        }

        public String getState() {
            if (WebAppEntry.this._app == null) {
                return "stopped";
            }
            return WebAppEntry.this._app.getState();
        }

        public int getActiveSessionCount() {
            Application app = WebAppEntry.this.getApplication();
            if (app == null) {
                return 0;
            }
            SessionManager manager = app.getSessionManager();
            if (manager == null) {
                return 0;
            }
            return manager.getActiveSessionCount();
        }

        public Date getStartTime() {
            return new Date(WebAppEntry.this.getStartTime());
        }

        public void stop() throws Exception {
            WebAppEntry.this.stop();
        }

        public void start() throws Exception {
            WebAppEntry.this.start();
        }

        public void restart() throws Exception {
            this.stop();
            this.start();
        }
    }
}

