/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.Version;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CGIServlet
extends GenericServlet {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/servlets/CGIServlet"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/servlets/CGIServlet"));
    private static String REQUEST_URI = "javax.servlet.include.request_uri";
    private static String CONTEXT_PATH = "javax.servlet.include.context_path";
    private static String SERVLET_PATH = "javax.servlet.include.servlet_path";
    private static String PATH_INFO = "javax.servlet.include.path_info";
    private static String QUERY_STRING = "javax.servlet.include.query_string";
    private boolean _stderrIsException = true;

    public void setStderrIsException(boolean isException) {
        this._stderrIsException = isException;
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String queryString;
        String pathInfo;
        String scriptPath;
        String contextPath;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String requestURI = (String)req.getAttribute(REQUEST_URI);
        if (requestURI != null) {
            contextPath = (String)req.getAttribute(CONTEXT_PATH);
            scriptPath = (String)req.getAttribute(SERVLET_PATH);
            pathInfo = (String)req.getAttribute(PATH_INFO);
            queryString = (String)req.getAttribute(QUERY_STRING);
        } else {
            requestURI = req.getRequestURI();
            contextPath = req.getContextPath();
            scriptPath = req.getServletPath();
            pathInfo = req.getPathInfo();
            queryString = req.getQueryString();
        }
        String realPath = req.getRealPath(scriptPath);
        Path vfsPath = Vfs.lookup(realPath);
        if (vfsPath.isDirectory() && req.getPathInfo() != null) {
            int p = pathInfo.indexOf(47);
            if (p > 0) {
                scriptPath = scriptPath + pathInfo.substring(0, p);
                pathInfo = pathInfo.substring(p);
            } else {
                scriptPath = scriptPath + pathInfo;
                pathInfo = null;
            }
            realPath = req.getRealPath(scriptPath);
        }
        String[] env = this.setEnvironment(req, requestURI, contextPath, scriptPath, pathInfo, queryString);
        String[] args = this.getArgs(realPath);
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        Alarm alarm = null;
        try {
            int ch;
            process = runtime.exec(args, env);
            PrintWriter out = res.getWriter();
            InputStream inputStream = process.getInputStream();
            InputStream errorStream = process.getErrorStream();
            TimeoutAlarm timeout = new TimeoutAlarm(requestURI, process, inputStream);
            alarm = new Alarm(timeout, 360000L);
            OutputStream outputStream = process.getOutputStream();
            ServletInputStream sis = req.getInputStream();
            if (sis.available() > 0) {
                WriteStream ws = Vfs.openWrite(outputStream);
                ws.writeStream((InputStream)sis);
                ws.close();
            }
            outputStream.flush();
            outputStream.close();
            ReadStream rs = Vfs.openRead(inputStream);
            boolean hasStatus = this.parseHeaders(res, rs);
            while ((ch = rs.read()) >= 0) {
                out.print((char)ch);
            }
            rs.close();
            inputStream.close();
            CharBuffer error = CharBuffer.allocate();
            boolean hasContent = false;
            while (errorStream.available() > 0 && (ch = errorStream.read()) > 0) {
                error.append((char)ch);
                if (Character.isWhitespace((char)ch)) continue;
                hasContent = true;
            }
            errorStream.close();
            if (hasContent) {
                String errorString = error.close();
                log.warning(errorString);
                if (!hasStatus && this._stderrIsException) {
                    throw new ServletException(errorString);
                }
            }
            int status = process.waitFor();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (alarm != null) {
                alarm.dequeue();
            }
            try {
                process.destroy();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getArgs(String path) {
        ReadStream is = null;
        try {
            is = Vfs.lookup(path).openRead();
            if (is.read() != 35) {
                String[] stringArray = new String[]{path};
                return stringArray;
            }
            if (is.read() != 33) {
                String[] stringArray = new String[]{path};
                return stringArray;
            }
            CharBuffer cb = CharBuffer.allocate();
            ArrayList<String> list = new ArrayList<String>();
            int ch = is.read();
            while (ch >= 0 && ch != 13 && ch != 10) {
                while (ch == 32 || ch == 9) {
                    ch = is.read();
                }
                if (ch < 0 || ch == 13 || ch == 10) {
                    if (list.size() > 0) {
                        list.add(path);
                        String[] stringArray = list.toArray(new String[list.size()]);
                        return stringArray;
                    }
                    String[] stringArray = new String[]{path};
                    return stringArray;
                }
                cb.clear();
                while (ch > 0 && ch != 32 && ch != 9 && ch != 13 && ch != 10) {
                    cb.append((char)ch);
                    ch = is.read();
                }
                list.add(cb.toString());
                while (ch == 32 || ch == 9) {
                    ch = is.read();
                }
            }
            if (list.size() > 0) {
                list.add(path);
                String[] stringArray = list.toArray(new String[list.size()]);
                return stringArray;
            }
            String[] stringArray = new String[]{path};
            return stringArray;
        }
        catch (Exception e) {
            String[] stringArray = new String[]{path};
            return stringArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String[] setEnvironment(HttpServletRequest req, String requestURI, String contextPath, String scriptPath, String pathInfo, String queryString) {
        ArrayList<String> env = new ArrayList<String>();
        env.add("SERVER_SOFTWARE=Resin/" + Version.VERSION);
        env.add("SERVER_NAME=" + req.getServerName());
        env.add("SERVER_PORT=" + req.getServerPort());
        env.add("REMOTE_ADDR=" + req.getRemoteAddr());
        if (req.getRemoteUser() != null) {
            env.add("REMOTE_USER=" + req.getRemoteUser());
        }
        if (req.getAuthType() != null) {
            env.add("AUTH_TYPE=" + req.getAuthType());
        }
        env.add("GATEWAY_INTERFACE=CGI/1.1");
        env.add("SERVER_PROTOCOL=" + req.getProtocol());
        env.add("REQUEST_METHOD=" + req.getMethod());
        if (queryString != null) {
            env.add("QUERY_STRING=" + queryString);
        }
        env.add("REQUEST_URI=" + requestURI);
        scriptPath = contextPath + scriptPath;
        env.add("SCRIPT_NAME=" + scriptPath);
        if (pathInfo != null) {
            env.add("PATH_INFO=" + pathInfo);
            env.add("PATH_TRANSLATED=" + req.getRealPath(pathInfo));
        }
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = req.getHeader(key);
            if (key.equalsIgnoreCase("content-length")) {
                env.add("CONTENT_LENGTH=" + value);
                continue;
            }
            if (key.equalsIgnoreCase("content-type")) {
                env.add("CONTENT_TYPE=" + value);
                continue;
            }
            if (key.equalsIgnoreCase("authorization") || key.equalsIgnoreCase("proxy-authorization")) continue;
            env.add(this.convertHeader(key, value));
        }
        return env.toArray(new String[env.size()]);
    }

    private String convertHeader(String key, String value) {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("HTTP_");
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == '-') {
                cb.append('_');
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                cb.append((char)(ch + 65 - 97));
                continue;
            }
            cb.append(ch);
        }
        cb.append('=');
        cb.append(value);
        return cb.close();
    }

    private boolean parseHeaders(HttpServletResponse res, ReadStream rs) throws IOException {
        boolean hasStatus = false;
        CharBuffer key = CharBuffer.allocate();
        CharBuffer value = CharBuffer.allocate();
        while (true) {
            key.clear();
            value.clear();
            int ch = rs.read();
            while (ch >= 0 && ch != 32 && ch != 13 && ch != 10 && ch != 58) {
                key.append((char)ch);
                ch = rs.read();
            }
            while (ch >= 0 && ch == 32 || ch == 58) {
                ch = rs.read();
            }
            while (ch >= 0 && ch != 13 && ch != 10) {
                value.append((char)ch);
                ch = rs.read();
            }
            if (ch == 13 && (ch = rs.read()) != 10) {
                rs.unread();
            }
            if (key.length() == 0) {
                return hasStatus;
            }
            String keyStr = key.toString();
            String valueStr = value.toString();
            if (keyStr.equalsIgnoreCase("Status")) {
                int i;
                int status = 0;
                int len = valueStr.length();
                hasStatus = true;
                for (i = 0; i < len; ++i) {
                    char c = valueStr.charAt(i);
                    ch = c;
                    if (c < '0' || ch > 57) break;
                    status = 10 * status + ch - 48;
                }
                while (i < len) {
                    char c = valueStr.charAt(i);
                    ch = c;
                    if (c != ' ') break;
                    ++i;
                }
                res.setStatus(status, valueStr.substring(i));
                continue;
            }
            res.addHeader(keyStr, valueStr);
        }
    }

    class TimeoutAlarm
    implements AlarmListener {
        String _uri;
        Process _process;
        InputStream _is;

        TimeoutAlarm(String uri, Process process, InputStream is) {
            this._uri = uri;
            this._process = process;
            this._is = is;
        }

        public void handleAlarm(Alarm alarm) {
            log.warning("timing out CGI process for '" + this._uri + "'");
            try {
                this._is.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            try {
                this._process.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

