/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.Version;
import com.caucho.config.ConfigException;
import com.caucho.jca.mbean.ConnectionPoolMBean;
import com.caucho.jmx.Jmx;
import com.caucho.log.Log;
import com.caucho.server.cluster.mbean.ClusterClientMBean;
import com.caucho.server.cluster.mbean.ClusterMBean;
import com.caucho.server.host.mbean.HostMBean;
import com.caucho.server.port.mbean.PortMBean;
import com.caucho.server.resin.mbean.ResinServerMBean;
import com.caucho.server.resin.mbean.ServletServerMBean;
import com.caucho.server.resin.mbean.ThreadPoolMBean;
import com.caucho.server.webapp.mbean.WebAppMBean;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResinStatusServlet
extends GenericServlet {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/servlets/ResinStatusServlet"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/servlets/ResinStatusServlet"));
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private String _enable;
    private MBeanServer _mbeanServer;
    private ResinServerMBean _resinServer;
    private ServletServerMBean _servletServer;

    public void setEnable(String enable) throws ConfigException {
        if (!"read".equals(enable) && !"write".equals(enable)) {
            throw new ConfigException(L.l("enable value '{0}' must either be read or write.", enable));
        }
        this._enable = enable;
    }

    public void init() throws ServletException {
        if (this._enable == null) {
            throw new ServletException(L.l("ResinStatusServlet requires an explicit enable attribute."));
        }
        try {
            this._mbeanServer = Jmx.getMBeanServer();
            this._resinServer = (ResinServerMBean)Jmx.find("resin:type=ResinServer");
            this._servletServer = (ServletServerMBean)Jmx.find("resin:name=default,type=Server");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            res.setContentType("text/html");
            PrintWriter out = res.getWriter();
            this.printHeader(out);
            String hostName = req.getParameter("host");
            String appName = req.getParameter("app");
            this.printServerHeader(out);
            this.printPorts(out);
            this.printSrun(out);
            this.printApplicationSummary(out, req.getRequestURI());
            this.printFooter(out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printHeader(PrintWriter out) throws IOException, ServletException {
    }

    public void printServerHeader(PrintWriter out) throws Exception {
        String configFile;
        out.println("<b>resin-status</b><br><br>");
        String id = this._resinServer.getServerId();
        out.println("<table border=\"0\">");
        if (id != null) {
            out.println("<tr><td><b>Server:</b><td>" + id);
        }
        if ((configFile = this._resinServer.getConfigFile()) != null) {
            out.println("<tr><td><b>Config:</b><td>" + configFile);
        }
        long initialStartTime = this._resinServer.getInitialStartTime().getTime();
        long startTime = this._resinServer.getStartTime().getTime();
        out.println("<tr><td><b>Server Start:</b><td>" + QDate.formatLocal(initialStartTime));
        out.println("<tr><td><b>Server Reload:</b><td> " + QDate.formatLocal(startTime));
        long totalMemory = Runtime.getRuntime().totalMemory();
        out.println("<tr><td><b>Total Memory:</b><td> " + totalMemory / 1000000L + "." + totalMemory / 100000L % 10L + totalMemory / 10000L % 10L + "Meg");
        long freeMemory = Runtime.getRuntime().freeMemory();
        out.println("<tr><td><b>Free Memory:</b><td> " + freeMemory / 1000000L + "." + freeMemory / 100000L % 10L + freeMemory / 10000L % 10L + "Meg");
        long invocationHitCount = this._servletServer.getInvocationCacheHitCount();
        long invocationMissCount = this._servletServer.getInvocationCacheMissCount();
        long totalCount = invocationHitCount + invocationMissCount;
        if (totalCount == 0L) {
            totalCount = 1L;
        }
        long hitRatio = 10000L * invocationHitCount / totalCount;
        out.print("<tr><td><b>Invocation Hit Ratio:</b><td> " + hitRatio / 100L + "." + hitRatio / 10L % 10L + hitRatio % 10L + "%");
        out.println(" (" + invocationHitCount + "/" + totalCount + ")");
        long proxyHitCount = this._servletServer.getProxyCacheHitCount();
        long proxyMissCount = this._servletServer.getProxyCacheMissCount();
        totalCount = proxyHitCount + proxyMissCount;
        if (totalCount == 0L) {
            totalCount = 1L;
        }
        hitRatio = 10000L * proxyHitCount / totalCount;
        out.print("<tr><td><b>Proxy Cache Hit Ratio:</b><td> " + hitRatio / 100L + "." + hitRatio / 10L % 10L + hitRatio % 10L + "%");
        out.println(" (" + proxyHitCount + "/" + totalCount + ")");
        out.println("</table>");
        this.printThreadHeader(out);
        this.printConnectionPools(out, "");
    }

    public void printThreadHeader(PrintWriter out) throws Exception {
        out.println("<table border='3'>");
        ThreadPoolMBean threadPool = (ThreadPoolMBean)Jmx.find("resin:type=ThreadPool");
        out.println("<tr><th colspan='3'>Threads");
        out.println("    <th colspan='3'>Config");
        out.println("<tr><th>Active<th>Idle<th>Total");
        out.println("    <th>thread-max<th>spare-thread-min");
        out.println("<tr align='right'>");
        out.println("    <td>" + threadPool.getActiveThreadCount());
        out.println("    <td>" + threadPool.getIdleThreadCount());
        out.println("    <td>" + threadPool.getThreadCount());
        out.println("    <td>" + threadPool.getThreadMax());
        out.println("    <td>" + threadPool.getSpareThreadMin());
        out.println("</table>");
    }

    public void printPorts(PrintWriter out) throws IOException, ServletException {
        try {
            ObjectName[] portList = this._servletServer.getPortObjectNames();
            if (portList.length > 0) {
                out.println("<h3>TCP ports</h3>");
                out.println("<table border='2'>");
                out.println("<tr><th><th colspan='3'>Threads<th>&nbsp;");
                out.println("<tr><th>Protocol:Port");
                out.println("    <th>Active<th>Idle<th>Total");
                out.println("    <th>Keepalive<th>Select");
                for (int i = 0; i < portList.length; ++i) {
                    PortMBean port = (PortMBean)Jmx.find(portList[i]);
                    if (port == null || !port.isActive()) continue;
                    String host = port.getHost();
                    if (host == null) {
                        host = "*";
                    }
                    out.print("<tr><td>");
                    out.print(port.getProtocolName() + "://" + host + ":" + port.getPort());
                    out.println();
                    out.print("    <td>" + port.getActiveThreadCount());
                    out.print("<td>" + port.getIdleThreadCount());
                    out.print("<td>" + port.getThreadCount());
                    out.print("<td>" + port.getKeepaliveCount());
                    out.print("<td>" + port.getSelectConnectionCount());
                    out.println();
                    out.println();
                }
                out.println("</table>");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printSrun(PrintWriter out) throws IOException, ServletException {
        try {
            ObjectName[] clusterList = this._servletServer.getClusterObjectNames();
            for (int i = 0; i < clusterList.length; ++i) {
                ClusterMBean cluster = (ClusterMBean)Jmx.find(clusterList[i]);
                if (cluster == null) {
                    out.println("<h3>Cluster " + clusterList[i] + " null</h3>");
                    continue;
                }
                ObjectName objectName = cluster.getObjectName();
                String clusterName = objectName.getKeyProperty("name");
                out.println("<h3>Cluster " + clusterName + "</h3>");
                out.println("<table border='2'>");
                out.println("<tr><th>Host");
                out.println("    <th>Active");
                ObjectName[] srunNames = cluster.getClientObjectNames();
                for (int j = 0; j < srunNames.length; ++j) {
                    ObjectName srunName = srunNames[j];
                    ClusterClientMBean client = (ClusterClientMBean)Jmx.find(srunName);
                    String host = srunName.getKeyProperty("host");
                    String port = srunName.getKeyProperty("port");
                    out.println("<tr>");
                    boolean canConnect = client.canConnect();
                    if (canConnect) {
                        out.print("<td bgcolor='#80ff80'>");
                    } else {
                        out.print("<td>");
                    }
                    out.print(host + ":" + port);
                    if (canConnect) {
                        out.println(" (up)");
                    } else {
                        out.println(" (down)");
                    }
                    out.println("<td>" + client.getActiveCount());
                }
                out.println("</table>");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void printConnectionPools(PrintWriter out, String context) throws Exception {
        ObjectName pattern = new ObjectName("resin:*,type=ConnectionPool" + context);
        Set<ObjectName> poolNames = this._mbeanServer.queryNames(pattern, null);
        if (poolNames.size() == 0) {
            return;
        }
        out.println("<h3>Connection Pools</h3>");
        out.println("<table border='2'>");
        out.println("<tr><th>&nbsp;<th colspan='3'>Connections<th colspan='2'>Config");
        out.println("<tr><th>Name<th>Active<th>Idle<th>Total");
        out.println("    <th>max-connections<th>idle-time");
        Iterator<ObjectName> iter = poolNames.iterator();
        while (iter.hasNext()) {
            ObjectName name = iter.next();
            ConnectionPoolMBean pool = (ConnectionPoolMBean)Jmx.find(name, ClassLoader.getSystemClassLoader());
            out.println("<tr><td>" + pool.getName());
            out.println("    <td>" + pool.getActiveConnectionCount());
            out.println("    <td>" + pool.getIdleConnectionCount());
            out.println("    <td>" + pool.getConnectionCount());
            out.println("    <td>" + pool.getMaxConnections());
            out.println("    <td>" + this.periodToString(pool.getMaxIdleTime()));
        }
        out.println("</table>");
    }

    private String periodToString(long time) {
        if (time == 0L) {
            return "0s";
        }
        if (time % 86400000L == 0L) {
            return time / 86400000L + "d";
        }
        if (time % 3600000L == 0L) {
            return time / 3600000L + "h";
        }
        if (time % 60000L == 0L) {
            return time / 60000L + "min";
        }
        if (time % 1000L == 0L) {
            return time / 1000L + "s";
        }
        return time + "ms";
    }

    public void printApplicationSummary(PrintWriter out, String pwd) throws Exception {
        HostMBean host;
        out.println("<h3>Hosts and Applications</h3>");
        out.println("<table border=\"2\">");
        out.println("<tr><th>Host<th>Web-App<th>State<th>Sessions");
        ObjectName hostPattern = new ObjectName("resin:*,type=Host");
        Set<ObjectName> names = this._mbeanServer.queryNames(hostPattern, null);
        Iterator<ObjectName> iter = names.iterator();
        ArrayList<HostMBean> hosts = new ArrayList<HostMBean>();
        while (iter.hasNext()) {
            ObjectName name = iter.next();
            if ("current".equals(name.getKeyProperty("name")) || (host = (HostMBean)Jmx.find(name)) == null) continue;
            hosts.add(host);
        }
        Collections.sort(hosts, new HostCompare());
        for (int i = 0; i < hosts.size(); ++i) {
            WebAppMBean app;
            host = (HostMBean)hosts.get(i);
            out.println("<tr><td><b>" + host.getURL() + "</b>");
            String hostName = host.getHostName();
            if (hostName.equals("")) {
                hostName = "default";
            }
            ObjectName appPattern = new ObjectName("resin:*,Host=" + hostName + ",type=WebApp");
            names = this._mbeanServer.queryNames(appPattern, null);
            iter = names.iterator();
            ArrayList<WebAppMBean> apps = new ArrayList<WebAppMBean>();
            while (iter.hasNext()) {
                ObjectName name = iter.next();
                try {
                    app = (WebAppMBean)Jmx.find(name);
                    if (app == null) continue;
                    apps.add(app);
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString());
                    out.println("<tr><td>" + name + "<td>" + e.toString());
                }
            }
            Collections.sort(apps, new AppCompare());
            for (int j = 0; j < apps.size(); ++j) {
                app = (WebAppMBean)apps.get(j);
                String contextPath = app.getContextPath();
                if (contextPath.equals("")) {
                    contextPath = "/";
                }
                out.print("<tr><td><td>");
                out.print("<a href=\"" + pwd + "?host=" + host.getHostName() + "&app=" + app.getContextPath() + "\">");
                out.print(contextPath);
                out.print("</a>");
                String state = app.getState();
                if (state.equals("active")) {
                    out.print("<td bgcolor='#80ff80'>" + app.getState());
                } else {
                    out.print("<td>" + app.getState());
                }
                out.print("<td>" + app.getActiveSessionCount());
            }
        }
        out.println("</table>");
    }

    public void printVirtualHosts(PrintWriter out) throws IOException, ServletException {
    }

    public void printFooter(PrintWriter out) throws IOException, ServletException {
        out.println("<br><em>" + Version.FULL_VERSION + "</em>");
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AppCompare
    implements Comparator<WebAppMBean> {
        AppCompare() {
        }

        @Override
        public int compare(WebAppMBean a, WebAppMBean b) {
            String cpA = a.getContextPath();
            String cpB = b.getContextPath();
            return cpA.compareTo(cpB);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HostCompare
    implements Comparator<HostMBean> {
        HostCompare() {
        }

        @Override
        public int compare(HostMBean a, HostMBean b) {
            String urlB;
            String urlA = a.getURL();
            if (urlA == (urlB = b.getURL())) {
                return 0;
            }
            if (urlA == null) {
                return -1;
            }
            if (urlB == null) {
                return 1;
            }
            return urlA.compareTo(urlB);
        }
    }
}

