/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.soap.wsdl;

import com.caucho.config.ConfigException;
import com.caucho.soap.wsdl.WSDLDefinitions;
import com.caucho.soap.wsdl.WSDLOperation;
import com.caucho.soap.wsdl.WSDLPortType;
import com.caucho.util.L10N;
import com.caucho.xml.XmlUtil;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLBinding {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/soap/wsdl/WSDLBinding"));
    private WSDLDefinitions _defs;
    private QName _name;
    private WSDLPortType _portType;
    private Node _node;
    private HashMap<QName, WSDLOperation> _opMap = new HashMap();
    private ArrayList<Param> _params = new ArrayList();

    WSDLBinding(WSDLDefinitions defs) {
        this._defs = defs;
    }

    public void setConfigNode(Node node) {
        this._node = node;
    }

    public void setName(String name) {
        this._name = new QName(this._defs.getTargetNamespace(), name);
    }

    public QName getName() {
        return this._name;
    }

    public void setType(String type) throws ConfigException {
        QName qName;
        int p = type.indexOf(58);
        if (p < 0) {
            String uri = XmlUtil.getNamespace(this._node, "");
            if (uri == null) {
                uri = this._defs.getTargetNamespace();
            }
            qName = new QName(uri, type);
        } else {
            String prefix = type.substring(0, p);
            String uri = XmlUtil.getNamespace(this._node, prefix);
            qName = new QName(uri, type.substring(p + 1), prefix);
        }
        this._portType = this._defs.getPortType(qName);
        if (this._portType == null) {
            throw new ConfigException(L.l("{0} is an unknown portType.", this._portType));
        }
    }

    public WSDLPortType getPortType() {
        return this._portType;
    }

    public Operation createOperation() {
        return new Operation();
    }

    public void addOperation(Operation op) {
        this._opMap.put(op.getName(), op.getOp());
    }

    public Iterator<QName> getOperationNames() {
        return this._opMap.keySet().iterator();
    }

    public WSDLOperation getOperation(QName name) {
        return this._opMap.get(name);
    }

    public String toString() {
        return new StringBuffer().append("WSDLBinding[").append(this.getName()).append("]").toString();
    }

    public static class Output
    extends Param {
    }

    public static class Input
    extends Param {
    }

    public static class Param {
    }

    public class Operation {
        private QName _name;
        private WSDLOperation _op;

        Operation() {
        }

        public void setName(String name) {
            this._name = new QName(WSDLBinding.this._defs.getTargetNamespace(), name);
            this._op = WSDLBinding.this._portType.getOperation(this._name);
        }

        public QName getName() {
            return this._name;
        }

        public WSDLOperation getOp() {
            return this._op;
        }

        public void addInput(Input input) {
        }

        public void addOutput(Output output) {
        }
    }
}

