/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.spy.SpyConnection;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SpyPooledConnection
implements PooledConnection {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyPooledConnection"));
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyPooledConnection"));
    protected int _id;
    private int _connCount;
    private PooledConnection _pconn;

    public SpyPooledConnection(PooledConnection conn, int id) {
        this._pconn = conn;
        this._id = id;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._pconn.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._pconn.removeConnectionEventListener(listener);
    }

    public Connection getConnection() throws SQLException {
        try {
            Connection conn = this._pconn.getConnection();
            int connId = this._connCount++;
            log.info(this._id + ":connect() -> " + connId + ":" + conn);
            return new SpyConnection(conn, connId);
        }
        catch (SQLException e) {
            log.info(this._id + ":exn-connect(" + e + ")");
            throw e;
        }
    }

    public void close() throws SQLException {
        try {
            this._pconn.close();
            log.info(this._id + ":close()");
        }
        catch (SQLException e) {
            log.info(this._id + ":exn-close(" + e + ")");
            throw e;
        }
    }

    public String toString() {
        return "SpyPooledConnection[id=" + this._id + ",conn=" + this._pconn + "]";
    }
}

