/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.log.Log;
import com.caucho.sql.spy.SpyXAConnection;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SpyXADataSource
implements XADataSource {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyXADataSource"));
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/sql/spy/SpyXADataSource"));
    private static int _staticId;
    private int _id;
    private int _connCount;
    private XADataSource _dataSource;

    public SpyXADataSource(XADataSource dataSource) {
        this._dataSource = dataSource;
        this._id = _staticId++;
    }

    public XAConnection getXAConnection() throws SQLException {
        try {
            XAConnection conn = this._dataSource.getXAConnection();
            int connId = this._connCount++;
            log.info(this._id + ":getXAConnection() -> " + connId + ":" + conn);
            return new SpyXAConnection(conn, connId);
        }
        catch (SQLException e) {
            log.info(this._id + ":exn-connect(" + e + ")");
            throw e;
        }
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        try {
            XAConnection conn = this._dataSource.getXAConnection(user, password);
            int connId = this._connCount++;
            log.info(this._id + ":getXAConnection(" + user + ") -> " + connId + ":" + conn);
            return new SpyXAConnection(conn, connId);
        }
        catch (SQLException e) {
            log.info(this._id + ":exn-connect(" + e + ")");
            throw e;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this._dataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this._dataSource.setLoginTimeout(timeout);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._dataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter log) throws SQLException {
        this._dataSource.setLogWriter(log);
    }

    public String toString() {
        return "SpyXADataSource[id=" + this._id + ",data-source=" + this._dataSource + "]";
    }
}

