/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

public class IntMap {
    public static final int NULL = -65536;
    private static int DELETED = 1;
    private Object[] keys;
    private int nullValue;
    private int[] values;
    private byte[] flags;
    private int size;
    private int mask;

    public IntMap() {
        this.keys = new Object[16];
        this.values = new int[16];
        this.flags = new byte[16];
        this.mask = this.keys.length - 1;
        this.size = 0;
        this.nullValue = -65536;
    }

    private IntMap(boolean dummy) {
    }

    public void clear() {
        this.nullValue = -65536;
        for (int i = 0; i < this.values.length; ++i) {
            this.keys[i] = null;
            this.flags[i] = 0;
            this.values[i] = 0;
        }
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public int get(Object key) {
        if (key == null) {
            return this.nullValue;
        }
        int hash = key.hashCode() & this.mask;
        Object mapKey;
        while ((mapKey = this.keys[hash]) != key) {
            if (mapKey == null) {
                if ((this.flags[hash] & DELETED) == 0) {
                    return -65536;
                }
            } else if (mapKey.equals(key)) {
                return this.values[hash];
            }
            hash = hash + 1 & this.mask;
        }
        return this.values[hash];
    }

    private void resize(int newSize) {
        Object[] newKeys = new Object[newSize];
        int[] newValues = new int[newSize];
        byte[] newFlags = new byte[newSize];
        this.mask = newKeys.length - 1;
        block0: for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null || (this.flags[i] & DELETED) != 0) continue;
            int hash = this.keys[i].hashCode() & this.mask;
            while (true) {
                if (newKeys[hash] == null) {
                    newKeys[hash] = this.keys[i];
                    newValues[hash] = this.values[i];
                    newFlags[hash] = this.flags[i];
                    continue block0;
                }
                hash = hash + 1 & this.mask;
            }
        }
        this.keys = newKeys;
        this.values = newValues;
        this.flags = newFlags;
    }

    public int put(Object key, int value) {
        if (key == null) {
            int old = this.nullValue;
            this.nullValue = value;
            return old;
        }
        int hash = key.hashCode() & this.mask;
        while (true) {
            Object testKey;
            if ((testKey = this.keys[hash]) == null || (this.flags[hash] & DELETED) != 0) {
                this.keys[hash] = key;
                this.values[hash] = value;
                this.flags[hash] = 0;
                ++this.size;
                if (this.keys.length <= 2 * this.size) {
                    this.resize(2 * this.keys.length);
                }
                return -65536;
            }
            if (key == testKey || testKey.equals(key)) break;
            hash = hash + 1 & this.mask;
        }
        int old = this.values[hash];
        this.values[hash] = value;
        return old;
    }

    public int remove(Object key) {
        if (key == null) {
            int old = this.nullValue;
            this.nullValue = -65536;
            return old;
        }
        int hash = key.hashCode() & this.mask;
        Object mapKey;
        while ((mapKey = this.keys[hash]) != null) {
            if (mapKey.equals(key)) {
                int n = hash;
                this.flags[n] = (byte)(this.flags[n] | DELETED);
                --this.size;
                this.keys[hash] = null;
                return this.values[hash];
            }
            hash = hash + 1 & this.mask;
        }
        return -65536;
    }

    public Iterator iterator() {
        return new IntMapIterator();
    }

    public Object clone() {
        IntMap clone = new IntMap(true);
        clone.keys = new Object[this.keys.length];
        System.arraycopy(this.keys, 0, clone.keys, 0, this.keys.length);
        clone.values = new int[this.values.length];
        System.arraycopy(this.values, 0, clone.values, 0, this.values.length);
        clone.flags = new byte[this.flags.length];
        System.arraycopy(this.flags, 0, clone.flags, 0, this.flags.length);
        clone.mask = this.mask;
        clone.size = this.size;
        clone.nullValue = this.nullValue;
        return clone;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("IntMap[");
        boolean isFirst = true;
        for (int i = 0; i <= this.mask; ++i) {
            if ((this.flags[i] & DELETED) != 0 || this.keys[i] == null) continue;
            if (!isFirst) {
                sbuf.append(", ");
            }
            isFirst = false;
            sbuf.append(this.keys[i]);
            sbuf.append(":");
            sbuf.append(this.values[i]);
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    class IntMapIterator
    implements Iterator {
        int index;

        IntMapIterator() {
        }

        public boolean hasNext() {
            while (this.index < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.index] != null && (IntMap.this.flags[this.index] & DELETED) == 0) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object next() {
            while (this.index < IntMap.this.keys.length) {
                if (IntMap.this.keys[this.index] != null && (IntMap.this.flags[this.index] & DELETED) == 0) {
                    return IntMap.this.keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }

        public void remove() {
            throw new RuntimeException();
        }
    }
}

