/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongKeyHashMap<E> {
    private long[] _keys;
    private E[] _values;
    private int _size;
    private int _mask;

    public LongKeyHashMap(int initialCapacity) {
        int capacity;
        for (capacity = 8; capacity < 2 * initialCapacity; capacity *= 2) {
        }
        this._keys = new long[capacity];
        this._values = new Object[capacity];
        this._mask = capacity - 1;
    }

    public int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LongKeyHashMap longKeyHashMap = this;
        synchronized (longKeyHashMap) {
            for (int i = 0; i < this._values.length; ++i) {
                this._values[i] = null;
            }
            this._size = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(long key) {
        int hash = this.getHash(key);
        LongKeyHashMap longKeyHashMap = this;
        synchronized (longKeyHashMap) {
            for (int count = this._size + 1; count > 0; --count) {
                E item = this._values[hash];
                if (item == null) {
                    return null;
                }
                if (this._keys[hash] == key) {
                    return item;
                }
                hash = hash + 1 & this._mask;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E put(long key, E value) {
        E item = this.putImpl(key, value);
        if (this._values.length <= 2 * this._size) {
            LongKeyHashMap longKeyHashMap = this;
            synchronized (longKeyHashMap) {
                long[] oldKeys = this._keys;
                E[] oldValues = this._values;
                this._keys = new long[2 * oldKeys.length];
                this._values = new Object[2 * oldValues.length];
                this._mask = this._values.length - 1;
                for (int i = oldValues.length - 1; i >= 0; --i) {
                    long oldKey = oldKeys[i];
                    E oldValue = oldValues[i];
                    if (oldValue == null) continue;
                    this.putImpl(oldKey, oldValue);
                }
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E putImpl(long key, E value) {
        E item = null;
        int hash = this.getHash(key);
        LongKeyHashMap longKeyHashMap = this;
        synchronized (longKeyHashMap) {
            for (int count = this._size + 1; count > 0; --count) {
                item = this._values[hash];
                if (item == null) {
                    this._keys[hash] = key;
                    this._values[hash] = value;
                    ++this._size;
                    return null;
                }
                if (this._keys[hash] == key) {
                    this._values[hash] = value;
                    return item;
                }
                hash = hash + 1 & this._mask;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove(long key) {
        int count;
        int hash = this.getHash(key);
        E item = null;
        LongKeyHashMap longKeyHashMap = this;
        synchronized (longKeyHashMap) {
            for (count = this._size + 1; count > 0; --count) {
                item = this._values[hash];
                if (item == null) {
                    return null;
                }
                if (this._keys[hash] == key) {
                    this._values[hash] = null;
                    --this._size;
                    this.refillEntries(hash);
                    break;
                }
                hash = hash + 1 & this._mask;
            }
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        return item;
    }

    private void refillEntries(int hash) {
        for (int count = this._size; count >= 0; --count) {
            if (this._values[hash = hash + 1 & this._mask] == null) {
                return;
            }
            this._values[hash] = null;
            this.refillEntry(hash);
        }
    }

    private void refillEntry(int baseHash) {
        long key = this._keys[baseHash];
        E value = this._values[baseHash];
        int hash = this.getHash(key);
        for (int count = this._size; count >= 0; --count) {
            if (this._values[hash] == null) {
                this._keys[hash] = key;
                this._values[hash] = value;
                return;
            }
            hash = hash + 1 & this._mask;
        }
    }

    private int getHash(long key) {
        long hash = key;
        hash = hash * 25214903917L + 11L + (hash >>> 32) * 137L;
        return (int)hash & this._mask;
    }

    public Iterator<E> valueIterator() {
        return new ValueIterator();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueIterator
    implements Iterator<E> {
        private E[] _values;
        private int _index;
        private E _value;

        ValueIterator() {
            this._values = LongKeyHashMap.this._values;
            this._index = -1;
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this._value != null;
        }

        @Override
        public E next() {
            Object value = this._value;
            this.findNext();
            return value;
        }

        @Override
        public void remove() {
        }

        private void findNext() {
            this._value = null;
            ++this._index;
            while (this._index < this._values.length) {
                this._value = this._values[this._index];
                if (this._value != null) {
                    return;
                }
                ++this._index;
            }
        }
    }
}

