/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongMap<K> {
    public static final long NULL = -19L;
    private static int DELETED = 1;
    private K[] _keys;
    private long _nullValue;
    private long[] _values;
    private byte[] _flags;
    private int _size;
    private int _mask;

    public LongMap() {
        this._keys = new Object[16];
        this._values = new long[16];
        this._flags = new byte[16];
        this._mask = this._keys.length - 1;
        this._size = 0;
        this._nullValue = -19L;
    }

    private LongMap(boolean dummy) {
    }

    public void clear() {
        this._nullValue = -19L;
        for (int i = 0; i < this._values.length; ++i) {
            this._keys[i] = null;
            this._flags[i] = 0;
            this._values[i] = 0L;
        }
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public long get(K key) {
        if (key == null) {
            return this._nullValue;
        }
        int hash = key.hashCode() & this._mask;
        K mapKey;
        while ((mapKey = this._keys[hash]) != key) {
            if (mapKey == null) {
                if ((this._flags[hash] & DELETED) == 0) {
                    return -19L;
                }
            } else if (mapKey.equals(key)) {
                return this._values[hash];
            }
            hash = hash + 1 & this._mask;
        }
        return this._values[hash];
    }

    private void resize(int newSize) {
        Object[] newKeys = new Object[newSize];
        long[] newValues = new long[newSize];
        byte[] newFlags = new byte[newSize];
        this._mask = newKeys.length - 1;
        block0: for (int i = 0; i < this._keys.length; ++i) {
            if (this._keys[i] == null || (this._flags[i] & DELETED) != 0) continue;
            int hash = this._keys[i].hashCode() & this._mask;
            while (true) {
                if (newKeys[hash] == null) {
                    newKeys[hash] = this._keys[i];
                    newValues[hash] = this._values[i];
                    newFlags[hash] = this._flags[i];
                    continue block0;
                }
                hash = hash + 1 & this._mask;
            }
        }
        this._keys = newKeys;
        this._values = newValues;
        this._flags = newFlags;
    }

    public long put(K key, long value) {
        return this.put(key, value, false);
    }

    public long putIfNew(K key, long value) {
        return this.put(key, value, true);
    }

    private long put(K key, long value, boolean ifNew) {
        if (key == null) {
            long old = this._nullValue;
            this._nullValue = value;
            return old;
        }
        int hash = key.hashCode() & this._mask;
        while (true) {
            K testKey;
            if ((testKey = this._keys[hash]) == null || (this._flags[hash] & DELETED) != 0) {
                this._keys[hash] = key;
                this._values[hash] = value;
                this._flags[hash] = 0;
                ++this._size;
                if (this._keys.length <= 2 * this._size) {
                    this.resize(2 * this._keys.length);
                }
                return -19L;
            }
            if (key == testKey || testKey.equals(key)) break;
            hash = hash + 1 & this._mask;
        }
        if (ifNew) {
            return this._values[hash];
        }
        long old = this._values[hash];
        this._values[hash] = value;
        return old;
    }

    public long remove(K key) {
        if (key == null) {
            long old = this._nullValue;
            this._nullValue = -19L;
            return old;
        }
        int hash = key.hashCode() & this._mask;
        K mapKey;
        while ((mapKey = this._keys[hash]) != null) {
            if (mapKey.equals(key)) {
                int n = hash;
                this._flags[n] = (byte)(this._flags[n] | DELETED);
                --this._size;
                this._keys[hash] = null;
                return this._values[hash];
            }
            hash = hash + 1 & this._mask;
        }
        return -19L;
    }

    public Iterator iterator() {
        return new LongMapIterator();
    }

    public Object clone() {
        LongMap<K> clone = new LongMap<K>(true);
        clone._keys = new Object[this._keys.length];
        System.arraycopy(this._keys, 0, clone._keys, 0, this._keys.length);
        clone._values = new long[this._values.length];
        System.arraycopy(this._values, 0, clone._values, 0, this._values.length);
        clone._flags = new byte[this._flags.length];
        System.arraycopy(this._flags, 0, clone._flags, 0, this._flags.length);
        clone._mask = this._mask;
        clone._size = this._size;
        clone._nullValue = this._nullValue;
        return clone;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("LongMap[");
        boolean isFirst = true;
        for (int i = 0; i <= this._mask; ++i) {
            if ((this._flags[i] & DELETED) != 0 || this._keys[i] == null) continue;
            if (!isFirst) {
                sbuf.append(", ");
            }
            isFirst = false;
            sbuf.append(this._keys[i]);
            sbuf.append(":");
            sbuf.append(this._values[i]);
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    class LongMapIterator
    implements Iterator {
        int _index;

        LongMapIterator() {
        }

        public boolean hasNext() {
            while (this._index < LongMap.this._keys.length) {
                if (LongMap.this._keys[this._index] != null && (LongMap.this._flags[this._index] & DELETED) == 0) {
                    return true;
                }
                ++this._index;
            }
            return false;
        }

        public Object next() {
            while (this._index < LongMap.this._keys.length) {
                if (LongMap.this._keys[this._index] != null && (LongMap.this._flags[this._index] & DELETED) == 0) {
                    return LongMap.this._keys[this._index++];
                }
                ++this._index;
            }
            return null;
        }

        public void remove() {
            throw new RuntimeException();
        }
    }
}

