/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.config.types.Period;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.jsp.el.VariableResolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryNode {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/util/RegistryNode"));
    private static final long DAY = 86400000L;
    private static QDate _calendar = new QDate();
    private Registry _root;
    RegistryNode _parent;
    private ArrayList<RegistryNode> _children;
    String _name;
    String _id;
    String _value;
    private String _filename;
    private int _line;

    public RegistryNode() {
    }

    RegistryNode(Registry root, String name, String value, String filename, int line) {
        this._root = root;
        this._name = name;
        this._value = value;
        this._filename = filename;
        this._line = line;
    }

    public boolean isModified() {
        return this._root.isModified();
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLine() {
        return this._line;
    }

    public RegistryNode getParent() {
        return this._parent;
    }

    public RegistryNode getFirstChild() {
        if (this._children != null && this._children.size() > 0) {
            return this._children.get(0);
        }
        return null;
    }

    public Registry getRoot() {
        return this._root;
    }

    public void setRoot(Registry root) {
        this._root = root;
    }

    public ArrayList<Depend> getDependList() {
        if (this._root != null) {
            return this._root.getDependList();
        }
        return null;
    }

    public void append(RegistryNode next) {
        if (next == null || next._children == null) {
            return;
        }
        for (int i = 0; i < next._children.size(); ++i) {
            RegistryNode child = next._children.get(i);
            if (this._children == null) {
                this._children = new ArrayList();
            }
            this._children.add(child);
        }
    }

    public void addChild(RegistryNode child) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(child);
    }

    public boolean getBoolean() throws RegistryException {
        String value = this.getValue();
        if (value == null || value.equals("") || value.equals(this.getName())) {
            return true;
        }
        if (value.equals("true") || value.equals("yes")) {
            return true;
        }
        if (value.equals("false") || value.equals("no")) {
            return false;
        }
        throw this.error(L.l("expected `true' or 'false' for boolean value"));
    }

    public boolean getBoolean(String path, boolean deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getBoolean();
    }

    public RegistryNode lookup(String path) {
        int tail;
        int head;
        if (path == null) {
            return this;
        }
        int length = path.length();
        for (head = 0; head < length && path.charAt(head) == '/'; ++head) {
        }
        for (tail = head; tail < length && path.charAt(tail) != '/'; ++tail) {
        }
        if (tail <= head) {
            return this;
        }
        if (this._children == null || this._children.size() == 0) {
            return null;
        }
        String seq = path.substring(head, tail);
        String end = tail < length ? path.substring(tail + 1) : "";
        for (int i = 0; i < this._children.size(); ++i) {
            RegistryNode match;
            RegistryNode child = this._children.get(i);
            if (!child._name.equals(seq) || (match = child.lookup(end)) == null) continue;
            return match;
        }
        return null;
    }

    private RegistryNode getLink(String name) {
        int length = this._children == null ? 0 : this._children.size();
        for (int i = 0; i < length; ++i) {
            RegistryNode child = this._children.get(i);
            if (!child._name.equals(name)) continue;
            return child;
        }
        return null;
    }

    public int getInt() throws RegistryException {
        String value = this.getValue();
        if (value == null || value.equals("") || value.equals(this.getName())) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public int getInt(String path, int deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getInt();
    }

    public double getDouble() throws RegistryException {
        String value = this.getValue();
        if (value == null || value.equals("") || value.equals(this.getName())) {
            return 0.0;
        }
        try {
            return Double.valueOf(value);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public double getDouble(String path, double deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getDouble();
    }

    public String getString() {
        String value = this.getValue();
        return value;
    }

    public String getString(String path, String deflt) {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getString();
    }

    public String getPath() {
        String value = this.getValue();
        if (value.startsWith("$")) {
            int p = value.indexOf(47);
            if (p > 0) {
                String name = value.substring(1, p);
                String property = System.getProperty(name);
                if (property != null) {
                    value = new StringBuffer().append(property).append(value.substring(p)).toString();
                }
            } else {
                String name = value.substring(1);
                String property = System.getProperty(name);
                if (property != null) {
                    value = property;
                }
            }
        }
        return value;
    }

    public String getPath(String path, String deflt) {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getPath();
    }

    public QDate getDate() throws RegistryException {
        String value = this.getValue();
        throw this.error("no date");
    }

    public QDate getDate(String path, QDate deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getDate();
    }

    public long getPeriod() throws RegistryException {
        try {
            return RegistryNode.calculatePeriod(this.getValue());
        }
        catch (RegistryException e) {
            throw this.error(e.getMessage());
        }
    }

    public static long calculatePeriod(String value) throws RegistryException {
        try {
            return Period.toPeriod(value);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public long getPeriod(String path, long deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getPeriod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long periodEnd(long now, long period) {
        if (period < 0L) {
            return Long.MAX_VALUE;
        }
        if (period == 0L) {
            return now;
        }
        if (period < 2592000000L) {
            return now + (period - (now + 345600000L) % period);
        }
        if (period % 2592000000L == 0L) {
            int months = (int)(period / 2592000000L);
            QDate qDate = _calendar;
            synchronized (qDate) {
                _calendar.setGMTTime(now);
                long year = _calendar.getYear();
                int month = _calendar.getMonth();
                _calendar.setGMTTime(0L);
                return _calendar.setDate(year, month + months, 0L);
            }
        }
        if (period % 31536000000L == 0L) {
            long years = period / 31536000000L;
            QDate qDate = _calendar;
            synchronized (qDate) {
                _calendar.setGMTTime(now);
                long year = _calendar.getYear();
                _calendar.setGMTTime(0L);
                long newYear = year + (years - year % years);
                return _calendar.setDate(newYear, 0L, 0L);
            }
        }
        return now + (period - (now + 345600000L) % period);
    }

    public InetNetwork getNetwork(String path, InetNetwork deflt) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getNetwork();
    }

    public InetNetwork getNetwork() throws RegistryException {
        try {
            return RegistryNode.parseNetwork(this.getValue());
        }
        catch (RegistryException e) {
            throw this.error(e.getMessage());
        }
    }

    public static InetNetwork parseNetwork(String network) throws RegistryException {
        return InetNetwork.create(network);
    }

    public boolean getELBoolean(VariableResolver env) throws RegistryException {
        String value = this.getValue();
        if (value == null || value.equals("") || value.equals(this.getName())) {
            return true;
        }
        if (value.equals("true") || value.equals("yes")) {
            return true;
        }
        if (value.equals("false") || value.equals("no")) {
            return false;
        }
        try {
            Expr expr = new ELParser(value).parse();
            return expr.evalBoolean(env);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public String getELString(VariableResolver env) throws RegistryException {
        try {
            String value = this.getValue();
            if (value == null || value.equals("")) {
                return value;
            }
            Expr expr = new ELParser(value).parse();
            return expr.evalString(env);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public boolean getELBoolean(String path, boolean deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            return node.getELBoolean(env);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public String getELString(String path, String deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        return node.getELString(env);
    }

    public int getELInt(String path, int deflt, VariableResolver env) throws RegistryException {
        return (int)this.getELLong(path, deflt, env);
    }

    public long getELLong(String path, long deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            return expr.evalLong(env);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public double getELDouble(String path, double deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            return expr.evalDouble(env);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public Path getELPath(String path, Path deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            Object obj = expr.evalObject(env);
            if (obj instanceof Path) {
                return (Path)obj;
            }
            String value = Expr.toString(obj, null);
            Path pwd = (Path)env.resolveVariable("resin:pwd");
            if (pwd != null) {
                return pwd.lookup(value);
            }
            return Vfs.lookup(value);
        }
        catch (Exception e) {
            throw node.error(e);
        }
    }

    public long getELPeriod(String path, long deflt, VariableResolver env) throws RegistryException {
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            return expr.evalPeriod(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public long getELBytes(String path, long deflt, VariableResolver env) throws RegistryException {
        char ch;
        String bytes;
        RegistryNode node = this.lookup(path);
        if (node == null) {
            return deflt;
        }
        try {
            Expr expr = new ELParser(node.getString()).parse();
            bytes = expr.evalString(env);
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
        long value = 0L;
        long sign = 1L;
        int i = 0;
        int length = bytes.length();
        if (length == 0) {
            return -1L;
        }
        if (bytes.charAt(i) == '-') {
            sign = -1L;
            ++i;
        } else if (bytes.charAt(i) == '+') {
            ++i;
        }
        if (length <= i) {
            return -1L;
        }
        while (i < length && (ch = bytes.charAt(i)) >= '0' && ch <= '9') {
            value = 10L * value + (long)ch - 48L;
            ++i;
        }
        value = sign * value;
        if (bytes.endsWith("gb") || bytes.endsWith("g")) {
            return value * 1024L * 1024L * 1024L;
        }
        if (bytes.endsWith("mb") || bytes.endsWith("m")) {
            return value * 1024L * 1024L;
        }
        if (bytes.endsWith("kb") || bytes.endsWith("k")) {
            return value * 1024L;
        }
        if (bytes.endsWith("b")) {
            return value;
        }
        return value;
    }

    public Iterator<RegistryNode> iterator() {
        return new RegistryIterator();
    }

    public Iterator<RegistryNode> select(String key) {
        return new RegistryIterator(key);
    }

    public List<RegistryNode> getChildren() {
        return this._children;
    }

    public boolean hasChildren() {
        return this._children != null && this._children.size() > 0;
    }

    RegistryNode add(String name, String value, String filename, int line) {
        RegistryNode child = new RegistryNode(this._root, name, value, filename, line);
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(child);
        child._parent = this;
        return child;
    }

    RegistryNode add(RegistryNode child) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(child);
        child._parent = this;
        return child;
    }

    private RegistryNode getLink(String name, String value) {
        int length = this._children == null ? 0 : this._children.size();
        for (int i = 0; i < length; ++i) {
            RegistryNode child = this._children.get(i);
            if (!child._name.equals(name) || child._value == null || !child._value.equals(value)) continue;
            return child;
        }
        return null;
    }

    public RegistryException error(String msg) {
        return new RegistryException(this.getErrorMessage(msg));
    }

    public RegistryException error(Exception e) {
        if (e instanceof RegistryException) {
            return (RegistryException)e;
        }
        return new RegistryException(this.getErrorMessage(e.toString()), e);
    }

    public String getErrorMessage(String message) {
        return new StringBuffer().append(this._filename).append(":").append(this._line).append(": ").append(message).toString();
    }

    public void print(WriteStream os) throws IOException {
        this.print(os, 0);
    }

    private void print(WriteStream os, int depth) throws IOException {
        this.printSpaces(os, depth);
        os.print(new StringBuffer().append("<").append(this.getName()).toString());
        if (this.getValue() != null) {
            os.print(new StringBuffer().append(" id=\"").append(this.getValue()).append("\"").toString());
        }
        int length = this._children == null ? 0 : this._children.size();
        boolean hasElementChildren = false;
        for (int i = 0; i < length; ++i) {
            RegistryNode child = this._children.get(i);
            if (child.hasChildren()) {
                hasElementChildren = true;
                break;
            }
            os.print(new StringBuffer().append(" ").append(child.getName()).append("=\"").append(child.getValue()).append("\"").toString());
        }
        if (!hasElementChildren) {
            os.println("/>");
            return;
        }
        os.println(">");
        boolean printChild = false;
        for (int i = 0; i < length; ++i) {
            RegistryNode child = this._children.get(i);
            if (!printChild && !child.hasChildren()) continue;
            printChild = true;
            child.print(os, depth + 2);
        }
        this.printSpaces(os, depth);
        os.println(new StringBuffer().append("</").append(this.getName()).append(">").toString());
    }

    private void printSpaces(WriteStream os, int depth) throws IOException {
        for (int i = 0; i < depth; ++i) {
            os.print(' ');
        }
    }

    public Object clone() {
        RegistryNode clone = new RegistryNode(this._root, this._name, this._value, this._filename, this._line);
        clone._parent = this._parent;
        if (this._children != null) {
            clone._children = new ArrayList();
            for (int i = 0; i < this._children.size(); ++i) {
                clone._children.add(this._children.get(i));
            }
        }
        return clone;
    }

    public String toString() {
        return new StringBuffer().append("RegistryNode[").append(this._name).append(" ").append(this._value).append("]").toString();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RegistryIterator
    implements Iterator<RegistryNode> {
        int _i;
        String _key;

        public RegistryIterator() {
        }

        public RegistryIterator(String key) {
            this._key = key;
            this.findNext();
        }

        private void findNext() {
            if (this._key == null || RegistryNode.this._children == null) {
                return;
            }
            while (this._i < RegistryNode.this._children.size()) {
                RegistryNode registry = (RegistryNode)RegistryNode.this._children.get(this._i);
                if (registry._name.equals(this._key)) {
                    return;
                }
                ++this._i;
            }
        }

        @Override
        public boolean hasNext() {
            return RegistryNode.this._children != null && this._i < RegistryNode.this._children.size();
        }

        @Override
        public RegistryNode next() {
            if (RegistryNode.this._children == null || RegistryNode.this._children.size() <= this._i) {
                return null;
            }
            RegistryNode next = (RegistryNode)RegistryNode.this._children.get(this._i);
            ++this._i;
            this.findNext();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

