/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.config.types.Period;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class RotateStream
extends StreamImpl {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/vfs/RotateStream"));
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long ROLLOVER_SIZE = 0x6400000L;
    private static HashMap<Path, SoftReference<RotateStream>> _streams = new HashMap();
    private Path _path;
    private String _archiveFormat;
    private long _rolloverPeriod = -1L;
    private long _rolloverSize = 0x6400000L;
    private long _updateInterval = 60000L;
    private int _maxRolloverCount;
    private StreamImpl _source;
    private QDate _calendar = new QDate(true);
    private long _nextTime = -1L;
    private volatile boolean _isInit;

    private RotateStream(Path path) {
        this._path = path;
        this._rolloverSize = 0x6400000L;
        this._maxRolloverCount = 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RotateStream create(Path path) {
        HashMap<Path, SoftReference<RotateStream>> hashMap = _streams;
        synchronized (hashMap) {
            RotateStream stream;
            SoftReference<RotateStream> ref = _streams.get(path);
            RotateStream rotateStream = stream = ref != null ? ref.get() : null;
            if (stream == null) {
                stream = new RotateStream(path);
                _streams.put(path, new SoftReference<RotateStream>(stream));
            }
            return stream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        HashMap<Path, SoftReference<RotateStream>> hashMap = _streams;
        synchronized (hashMap) {
            _streams.clear();
        }
    }

    public void setMaxRolloverCount(int count) {
        if (count < 0) {
            count = 1;
        }
        this._maxRolloverCount = count;
    }

    public void setRolloverPeriod(long period) {
        if (period > 0L) {
            this._rolloverPeriod = period;
            this._rolloverPeriod += 3599999L;
            this._rolloverPeriod -= this._rolloverPeriod % 3600000L;
        } else {
            this._rolloverPeriod = 0x3FFFFFFFFFFFFFFFL;
        }
    }

    public void setArchiveFormat(String format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this._archiveFormat = format;
    }

    public void setRolloverSize(long size) {
        this._rolloverSize = size <= 0L ? 0x3FFFFFFFFFFFFFFFL : size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        RotateStream rotateStream = this;
        synchronized (rotateStream) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        if (this._rolloverPeriod < 0L && this._rolloverSize < 0L) {
            this._rolloverPeriod = 2592000000L;
        }
        if (this._archiveFormat == null) {
            this._archiveFormat = this._rolloverPeriod <= 0L || this._rolloverPeriod % 86400000L != 0L ? this._path.getTail() + ".%Y%m%d.%H" : this._path.getTail() + ".%Y%m%d";
        }
        this.handleCron();
        new RotateAlarm(this);
    }

    private void open() {
        if (this._source != null) {
            return;
        }
        try {
            this._path.getParent().mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this._source = this._path.openAppendImpl();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean canWrite() {
        return this._path != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        RotateStream rotateStream = this;
        synchronized (rotateStream) {
            if (this._source == null) {
                this.init();
                this.open();
            }
            if (this._source != null) {
                this._source.write(buffer, offset, length, isEnd);
            }
        }
    }

    public WriteStream getStream() {
        return new WriteStream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long handleCron() {
        RotateStream rotateStream = this;
        synchronized (rotateStream) {
            return this.rotateLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long rotateLog() {
        long now = Alarm.getCurrentTime();
        if (now < this._nextTime && this._path.getLength() < this._rolloverSize) {
            return this._nextTime;
        }
        this.closeImpl();
        try {
            Path savedPath = null;
            this._calendar.setGMTTime(now);
            if (this._nextTime < 0L && this._rolloverPeriod > 0L) {
                long modifiedTime = this._path.getLastModified();
                if (modifiedTime <= 0L) {
                    long l = this._nextTime = Period.periodEnd(now, this._rolloverPeriod);
                    return l;
                }
                this._nextTime = Period.periodEnd(modifiedTime, this._rolloverPeriod);
                if (now < this._nextTime && this._path.getLength() < this._rolloverSize) {
                    long l = this._nextTime;
                    return l;
                }
            }
            Path parent = this._path.getParent();
            long lastTime = this._nextTime;
            if (this._rolloverPeriod > 0L) {
                this._nextTime = Period.periodEnd(now, this._rolloverPeriod);
            } else if (this._path.getLength() < this._rolloverSize) {
                long l = this._nextTime = now + this._updateInterval;
                return l;
            }
            String date = QDate.formatLocal(lastTime - 1L, this._archiveFormat);
            savedPath = parent.lookup(date);
            if (savedPath.exists()) {
                String extArchive = this._archiveFormat;
                if (extArchive.indexOf("%H") < 0) {
                    extArchive = extArchive + "-.%H";
                }
                if ((savedPath = parent.lookup(date = QDate.formatLocal(lastTime - 1L, extArchive))).exists()) {
                    for (int i = 1; i < this._maxRolloverCount && (savedPath = parent.lookup(date + '-' + i)).exists(); ++i) {
                    }
                }
            }
            try {
                String savedName = savedPath.getTail();
                try {
                    savedPath.getParent().mkdirs();
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                WriteStream os = savedPath.openWrite();
                OutputStream out = savedName.endsWith(".gz") ? new GZIPOutputStream(os) : (savedName.endsWith(".zip") ? new ZipOutputStream(os) : os);
                try {
                    this._path.writeToStream(out);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                    }
                    os.close();
                }
                this._path.remove();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            long l = this._nextTime;
            return l;
        }
        finally {
            this.init();
            this.open();
        }
    }

    public void flush() {
        StreamImpl source = this._source;
        try {
            if (source != null) {
                source.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeImpl() {
        try {
            StreamImpl source = this._source;
            this._source = null;
            if (source != null) {
                source.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void finalize() {
        this.closeImpl();
    }

    static class RotateAlarm
    implements AlarmListener {
        SoftReference<RotateStream> _ref;

        RotateAlarm(RotateStream stream) {
            this._ref = new SoftReference<RotateStream>(stream);
            this.handleAlarm(new Alarm("rotate-alarm", this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAlarm(Alarm alarm) {
            RotateStream stream = this._ref.get();
            if (stream != null) {
                try {
                    stream.handleCron();
                }
                finally {
                    long now = Alarm.getCurrentTime();
                    long nextTime = now + 3600000L;
                    nextTime = nextTime - nextTime % 3600000L + 1000L;
                    alarm.queue(nextTime - now);
                }
            }
        }
    }
}

