/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BooleanExpr
extends Expr {
    private int _code;
    private Expr _left;
    private Expr _right;
    private boolean _value;
    private ArrayList _args;
    static final Predicate P_EQ = new Predicate(){

        public boolean test(Object lobj, Object robj) throws XPathException {
            if (lobj instanceof Boolean || robj instanceof Boolean) {
                return Expr.toBoolean(lobj) == Expr.toBoolean(robj);
            }
            if (lobj instanceof Double || robj instanceof Double) {
                return Expr.toDouble(lobj) == Expr.toDouble(robj);
            }
            return BooleanExpr.toString(lobj).equals(BooleanExpr.toString(robj));
        }
    };
    static final Predicate P_NEQ = new Predicate(){

        public boolean test(Object lobj, Object robj) throws XPathException {
            if (lobj instanceof Boolean || robj instanceof Boolean) {
                return Expr.toBoolean(lobj) != Expr.toBoolean(robj);
            }
            if (lobj instanceof Double || robj instanceof Double) {
                return Expr.toDouble(lobj) != Expr.toDouble(robj);
            }
            return !BooleanExpr.toString(lobj).equals(BooleanExpr.toString(robj));
        }
    };
    static final Predicate P_LT = new Predicate(){

        public boolean test(Object lobj, Object robj) throws XPathException {
            return Expr.toDouble(lobj) < Expr.toDouble(robj);
        }
    };
    static final Predicate P_LE = new Predicate(){

        public boolean test(Object lobj, Object robj) throws XPathException {
            return Expr.toDouble(lobj) <= Expr.toDouble(robj);
        }
    };
    static final Predicate P_GT = new Predicate(){

        public boolean test(Object lobj, Object robj) throws XPathException {
            return Expr.toDouble(lobj) > Expr.toDouble(robj);
        }
    };
    static final Predicate P_GE = new Predicate(){

        public boolean test(Object lobj, Object robj) throws XPathException {
            return Expr.toDouble(lobj) >= Expr.toDouble(robj);
        }
    };

    public BooleanExpr(int code, Expr left, Expr right) {
        this._code = code;
        this._left = left;
        this._right = right;
        if (code == 5) {
            this._code = this._left.isNodeSet() || this._right.isNodeSet() ? 5 : (this._left.isBoolean() || this._right.isBoolean() ? 11 : (left.isNumber() || right.isNumber() ? 13 : (left.isString() && right.isString() ? 19 : 5)));
        } else if (code == 6) {
            this._code = left.isNodeSet() || right.isNodeSet() ? 6 : (left.isBoolean() || right.isBoolean() ? 12 : (left.isNumber() || right.isNumber() ? 14 : (left.isString() && right.isString() ? 20 : 6)));
        } else if (code == 7) {
            this._code = left.isNodeSet() || right.isNodeSet() ? 7 : (left.isNumber() || right.isNumber() ? 15 : 7);
        } else if (code == 8) {
            this._code = left.isNodeSet() || right.isNodeSet() ? 8 : (left.isNumber() || right.isNumber() ? 16 : 8);
        } else if (code == 9) {
            this._code = left.isNodeSet() || right.isNodeSet() ? 9 : (left.isNumber() || right.isNumber() ? 17 : 9);
        } else if (code == 10) {
            this._code = left.isNodeSet() || right.isNodeSet() ? 10 : (left.isNumber() || right.isNumber() ? 18 : 10);
        }
    }

    public BooleanExpr(int code, Expr expr) {
        this._code = code;
        this._left = expr;
    }

    public BooleanExpr(boolean value) {
        this._code = 0;
        this._value = value;
    }

    public BooleanExpr(int code, ArrayList args) {
        this._code = code;
        this._args = args;
        if (args.size() > 0) {
            this._left = (Expr)args.get(0);
        }
        if (args.size() > 1) {
            this._right = (Expr)args.get(1);
        }
    }

    public boolean isBoolean() {
        return true;
    }

    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        switch (this._code) {
            case 0: {
                return this._value;
            }
            case 11: {
                return this._left.evalBoolean(node, env) == this._right.evalBoolean(node, env);
            }
            case 13: {
                return this._left.evalNumber(node, env) == this._right.evalNumber(node, env);
            }
            case 19: {
                String lstr = this._left.evalString(node, env);
                String rstr = this._right.evalString(node, env);
                return lstr.equals(rstr);
            }
            case 5: {
                Object lobj = this._left.evalObject(node, env);
                Object robj = this._right.evalObject(node, env);
                if (lobj == robj) {
                    return true;
                }
                return this.cmp(P_EQ, lobj, robj);
            }
            case 12: {
                return this._left.evalBoolean(node, env) != this._right.evalBoolean(node, env);
            }
            case 14: {
                return this._left.evalNumber(node, env) != this._right.evalNumber(node, env);
            }
            case 20: {
                String lstr = this._left.evalString(node, env);
                String rstr = this._right.evalString(node, env);
                return !lstr.equals(rstr);
            }
            case 6: {
                Object lobj = this._left.evalObject(node, env);
                Object robj = this._right.evalObject(node, env);
                if (lobj == robj) {
                    return false;
                }
                return this.cmp(P_NEQ, lobj, robj);
            }
            case 7: {
                return this.cmp(P_LT, this._left.evalObject(node, env), this._right.evalObject(node, env));
            }
            case 8: {
                return this.cmp(P_LE, this._left.evalObject(node, env), this._right.evalObject(node, env));
            }
            case 9: {
                return this.cmp(P_GT, this._left.evalObject(node, env), this._right.evalObject(node, env));
            }
            case 10: {
                return this.cmp(P_GE, this._left.evalObject(node, env), this._right.evalObject(node, env));
            }
            case 15: {
                return this._left.evalNumber(node, env) < this._right.evalNumber(node, env);
            }
            case 16: {
                return this._left.evalNumber(node, env) <= this._right.evalNumber(node, env);
            }
            case 17: {
                return this._left.evalNumber(node, env) > this._right.evalNumber(node, env);
            }
            case 18: {
                return this._left.evalNumber(node, env) >= this._right.evalNumber(node, env);
            }
            case 3: {
                return this._left.evalBoolean(node, env) || this._right.evalBoolean(node, env);
            }
            case 4: {
                return this._left.evalBoolean(node, env) && this._right.evalBoolean(node, env);
            }
            case 28: {
                return true;
            }
            case 29: {
                return false;
            }
            case 30: {
                return !this._left.evalBoolean(node, env);
            }
            case 31: {
                return this._left.evalBoolean(node, env);
            }
            case 43: {
                String lstr = this._left.evalString(node, env);
                String rstr = this._right.evalString(node, env);
                return lstr.startsWith(rstr);
            }
            case 44: {
                String lstr = this._left.evalString(node, env);
                String rstr = this._right.evalString(node, env);
                return lstr.indexOf(rstr) >= 0;
            }
            case 32: {
                String lstr = this._left.evalString(node, env);
                while (node != null) {
                    String lang;
                    if (node instanceof Element && (lang = ((Element)node).getAttribute("xml:lang")) != null && lang.equals(lstr)) {
                        return true;
                    }
                    node = node.getParentNode();
                }
                return false;
            }
            case 56: {
                return false;
            }
        }
        throw new RuntimeException("unknown code: " + this._code);
    }

    private boolean cmp(Predicate test, Object lobj, Object robj) throws XPathException {
        if (lobj instanceof NodeList) {
            NodeList list = (NodeList)lobj;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                if (!this.cmp(test, list.item(i), robj)) continue;
                return true;
            }
            return false;
        }
        if (lobj instanceof ArrayList) {
            ArrayList list = (ArrayList)lobj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.cmp(test, list.get(i), robj)) continue;
                return true;
            }
            return false;
        }
        if (lobj instanceof Iterator) {
            Iterator iter = (Iterator)lobj;
            while (iter.hasNext()) {
                if (!this.cmp(test, iter.next(), robj)) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof NodeList) {
            NodeList list = (NodeList)robj;
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                if (!this.cmp(test, lobj, list.item(i))) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof ArrayList) {
            ArrayList list = (ArrayList)robj;
            for (int i = 0; i < list.size(); ++i) {
                if (!this.cmp(test, lobj, list.get(i))) continue;
                return true;
            }
            return false;
        }
        if (robj instanceof NodeIterator) {
            Iterator iter = null;
            iter = (Iterator)((NodeIterator)robj).clone();
            while (iter.hasNext()) {
                if (!this.cmp(test, lobj, iter.next())) continue;
                return true;
            }
            return false;
        }
        return test.test(lobj, robj);
    }

    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        if (this.evalBoolean(node, env)) {
            return 1.0;
        }
        return 0.0;
    }

    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        if (this.evalBoolean(node, env)) {
            return "true";
        }
        return "false";
    }

    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        return new Boolean(this.evalBoolean(node, env));
    }

    public String toString() {
        switch (this._code) {
            case 0: {
                return String.valueOf(this._value);
            }
            case 5: 
            case 11: 
            case 13: 
            case 19: {
                return "(" + this._left.toString() + " = " + this._right.toString() + ")";
            }
            case 6: 
            case 12: 
            case 14: 
            case 20: {
                return "(" + this._left.toString() + " != " + this._right.toString() + ")";
            }
            case 7: 
            case 15: {
                return "(" + this._left.toString() + " < " + this._right.toString() + ")";
            }
            case 8: 
            case 16: {
                return "(" + this._left.toString() + " <= " + this._right.toString() + ")";
            }
            case 9: 
            case 17: {
                return "(" + this._left.toString() + " > " + this._right.toString() + ")";
            }
            case 10: 
            case 18: {
                return "(" + this._left.toString() + " >= " + this._right.toString() + ")";
            }
            case 3: {
                return "(" + this._left.toString() + " or " + this._right.toString() + ")";
            }
            case 4: {
                return "(" + this._left.toString() + " and " + this._right.toString() + ")";
            }
            case 28: {
                return "true()";
            }
            case 29: {
                return "false()";
            }
            case 30: {
                return "not(" + this._left.toString() + ")";
            }
            case 31: {
                return "boolean(" + this._left.toString() + ")";
            }
            case 43: {
                return "starts-with(" + this._left + ", " + this._right + ")";
            }
            case 44: {
                return "contains(" + this._left + ", " + this._right + ")";
            }
            case 32: {
                return "lang(" + this._left + ")";
            }
            case 56: {
                return "function-available(" + this._left + ")";
            }
        }
        return super.toString();
    }

    static abstract class Predicate {
        public abstract boolean test(Object var1, Object var2) throws XPathException;

        Predicate() {
        }
    }
}

