/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import org.w3c.dom.Node;

public class SelectedNode {
    protected Node _node;
    protected int _depth;
    protected int _level;

    public SelectedNode(Node node) {
        Node ptr;
        this._node = node;
        this._depth = 0;
        for (ptr = node; ptr != null; ptr = ptr.getParentNode()) {
            ++this._depth;
        }
        this._level = 0;
        for (ptr = node; ptr != null; ptr = ptr.getPreviousSibling()) {
            ++this._level;
        }
    }

    public Node getNode() {
        return this._node;
    }

    public int compareTo(SelectedNode b) {
        int aDepth = this._depth;
        int bDepth = b._depth;
        Node aPtr = this.getNode();
        Node bPtr = b.getNode();
        if (aDepth == bDepth && aPtr.getParentNode() == bPtr.getParentNode()) {
            return this._level - b._level;
        }
        return SelectedNode.compareTo(aPtr, aDepth, bPtr, bDepth);
    }

    static int compareTo(Node aPtr, int aDepth, Node bPtr, int bDepth) {
        Node bParent;
        Node aParent;
        int depth;
        for (depth = aDepth; bDepth < depth; --depth) {
            aPtr = aPtr.getParentNode();
        }
        for (depth = bDepth; aDepth < depth; --depth) {
            bPtr = bPtr.getParentNode();
        }
        while ((aParent = aPtr.getParentNode()) != (bParent = bPtr.getParentNode())) {
            aPtr = aParent;
            bPtr = bParent;
        }
        if (aPtr == bPtr) {
            return aDepth - bDepth;
        }
        while (aPtr != null) {
            if (aPtr == bPtr) {
                return 1;
            }
            aPtr = aPtr.getPreviousSibling();
        }
        return -1;
    }
}

