/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.util.LineCompileException;
import com.caucho.xml.QName;
import com.caucho.xml.XmlChar;
import com.caucho.xpath.Expr;
import com.caucho.xpath.NamespaceContext;
import com.caucho.xpath.XPath;
import com.caucho.xpath.expr.NumericExpr;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.FilterPattern;
import com.caucho.xpath.pattern.FromChildren;
import com.caucho.xpath.pattern.FromContext;
import com.caucho.xpath.pattern.FromNextSibling;
import com.caucho.xpath.pattern.FromRoot;
import com.caucho.xpath.pattern.NodePattern;
import com.caucho.xpath.pattern.NodeTypePattern;
import com.caucho.xsl.JavaGenerator;
import com.caucho.xsl.XslParseException;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XslNode {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/xsl/java/XslNode"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/xsl/java/XslNode"));
    protected String _systemId;
    protected String _filename;
    protected int _startLine;
    protected int _endLine;
    protected JavaGenerator _gen;
    protected QName _name;
    protected XslNode _parent;
    protected ArrayList<XslNode> _children;
    protected NamespaceContext _namespace;
    private int _varCount;

    public abstract void generate(JavaWriter var1) throws Exception;

    protected XslNode() {
    }

    public void setGenerator(JavaGenerator gen) {
        this._gen = gen;
    }

    public QName getQName() {
        return this._name;
    }

    public void setQName(QName name) {
        this._name = name;
    }

    public String getTagName() {
        if (this._name != null) {
            return this._name.getName();
        }
        return this.getClass().getName();
    }

    public XslNode getParent() {
        return this._parent;
    }

    public void setParent(XslNode parent) {
        this._parent = parent;
        if (parent != null) {
            this._namespace = parent.getNamespace();
        }
    }

    public void addVariableCount() {
        if (this._parent != null) {
            ++this._parent._varCount;
        }
    }

    public void setStartLocation(String systemId, String filename, int line) {
        this._systemId = systemId;
        this._filename = filename;
        this._startLine = line;
    }

    public void setEndLocation(String filename, int line) {
        if (this._filename != null && this._filename.equals(filename)) {
            this._endLine = line;
        }
    }

    public String getSystemId() {
        return this._systemId;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getStartLine() {
        return this._startLine;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public String getBaseURI() {
        return this._filename;
    }

    public NamespaceContext getNamespace() {
        return this._namespace;
    }

    public String getNamespace(String prefix) {
        return NamespaceContext.find(this.getNamespace(), prefix);
    }

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().startsWith("xmlns")) {
            this.addNamespaceAttribute(name, value);
            return;
        }
        if (name.getName().startsWith("xml")) {
            return;
        }
        throw this.error(L.l("attribute `{0}' is not allowed in <{1}>.", (Object)name.getName(), this.getTagName()));
    }

    protected void addNamespaceAttribute(QName name, String url) throws XslParseException {
        String localName = name.getLocalName();
        if (localName.equals("xmlns")) {
            localName = "";
        }
        this._namespace = new NamespaceContext(this._namespace, localName, url);
    }

    public void endAttributes() throws XslParseException {
    }

    public void addText(String text) throws XslParseException {
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (XmlChar.isWhitespace(ch)) continue;
            throw this.error(L.l("Text is not allowed in <{0}> at `{1}'.", (Object)this._name.getName(), text));
        }
    }

    public void addChild(XslNode node) throws XslParseException {
        if (node == null) {
            return;
        }
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(node);
    }

    public void endElement() throws Exception {
    }

    public ArrayList<XslNode> getChildren() {
        return this._children;
    }

    public boolean hasChildren() {
        return this._children != null && this._children.size() > 0;
    }

    public void generateChildren(JavaWriter out) throws Exception {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            XslNode child = this._children.get(i);
            out.setLocation(child.getFilename(), child.getStartLine());
            child.generate(out);
        }
        this.popScope(out);
    }

    public void generateDeclaration(JavaWriter out) throws Exception {
        this.generateDeclarationChildren(out);
    }

    public void generateDeclarationChildren(JavaWriter out) throws Exception {
        if (this._children == null) {
            return;
        }
        for (int i = 0; i < this._children.size(); ++i) {
            XslNode child = this._children.get(i);
            child.generateDeclaration(out);
        }
    }

    protected void printAttributeValue(JavaWriter out, String name, String value) throws Exception {
        out.print("out.attribute(");
        out.print(name == null ? "null" : new StringBuffer().append("\"").append(name).append("\"").toString());
        out.print(", ");
        if (value == null) {
            out.print("null");
        } else {
            out.print("\"");
            out.printJavaString(value);
            out.print("\"");
        }
        out.println(");");
    }

    protected void printAttributeValue(JavaWriter out, String value) throws Exception {
        if (value == null) {
            out.print("null");
            return;
        }
        if (value.indexOf("{") < 0) {
            out.print("\"");
            out.printJavaString(value);
            out.print("\"");
        } else {
            this.generateString(out, value);
        }
    }

    void generateString(JavaWriter out, String string) throws Exception {
        boolean first = true;
        int length = string.length();
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                cb.append("\\n");
                continue;
            }
            if (ch == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    cb.append('{');
                    ++i;
                    continue;
                }
                if (cb.length() > 0) {
                    out.print("out.print(\"");
                    out.printJavaString(cb.toString());
                    out.println("\");");
                }
                cb.clear();
                ++i;
                while (i < length && string.charAt(i) != '}') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                this.printStringExpr(out, cb.toString());
                cb.clear();
                first = false;
                continue;
            }
            if (ch == '}' && i + 1 < length) {
                if (string.charAt(i + 1) == '}') {
                    cb.append('}');
                    ++i;
                    continue;
                }
                cb.append('}');
                continue;
            }
            if (i + 2 < length && ch == '<' && string.charAt(i + 1) == '#' && string.charAt(i + 2) == '=') {
                if (cb.length() > 0) {
                    out.print("out.print(\"");
                    out.printJavaString(cb.toString());
                    out.println("\");");
                }
                cb.clear();
                i += 3;
                while (i + 1 < length && string.charAt(i) != '#' && string.charAt(i + 1) != '>') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                ++i;
                out.println(new StringBuffer().append("out.print(").append((Object)cb).append(");").toString());
                cb.clear();
                first = false;
                continue;
            }
            cb.append(ch);
        }
        if (cb.length() > 0) {
            out.println(new StringBuffer().append("out.print(\"").append((Object)cb).append("\");").toString());
        }
    }

    void generateString(JavaWriter out, String string, int mode) throws Exception {
        CharBuffer cb = new CharBuffer();
        boolean first = true;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            if (ch == '\n') {
                cb.append("\\n");
                continue;
            }
            if (ch == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (ch == '{' && i + 1 < length) {
                if (string.charAt(i + 1) == '{') {
                    cb.append('{');
                    ++i;
                    continue;
                }
                if (mode == 44) {
                    if (cb.length() > 0) {
                        out.println(new StringBuffer().append("out.print(\"").append(cb.toString()).append("\");").toString());
                    }
                } else {
                    if (!first) {
                        out.print((char)mode);
                    }
                    if (cb.length() > 0) {
                        out.print("\"");
                        out.print(cb.toString());
                        out.print("\"");
                        out.print((char)mode);
                    }
                }
                cb.clear();
                ++i;
                while (i < length && string.charAt(i) != '}') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                if (mode == 44) {
                    this.printStringExpr(out, cb.toString());
                } else {
                    this.stringExpr(out, cb.toString());
                }
                cb.clear();
                first = false;
                continue;
            }
            if (ch == '}' && i + 1 < length) {
                if (string.charAt(i + 1) == '}') {
                    cb.append('}');
                    ++i;
                    continue;
                }
                cb.append('}');
                continue;
            }
            if (i + 2 < length && ch == '<' && string.charAt(i + 1) == '#' && string.charAt(i + 2) == '=') {
                if (mode == 44) {
                    if (cb.length() > 0) {
                        out.println(new StringBuffer().append("out.print(\"").append(cb.toString()).append("\");").toString());
                    }
                } else {
                    if (!first) {
                        out.print((char)mode);
                    }
                    if (cb.length() > 0) {
                        out.print("\"");
                        out.print(cb.toString());
                        out.print("\"");
                        out.print((char)mode);
                    }
                }
                cb.clear();
                i += 3;
                while (i + 1 < length && string.charAt(i) != '#' && string.charAt(i + 1) != '>') {
                    cb.append(string.charAt(i));
                    ++i;
                }
                ++i;
                if (mode == 44) {
                    out.println(new StringBuffer().append("out.print(").append((Object)cb).append(");").toString());
                } else {
                    out.print(new StringBuffer().append("(").append((Object)cb).append(")").toString());
                }
                cb.clear();
                first = false;
                continue;
            }
            cb.append(ch);
        }
        if (cb.length() > 0) {
            if (mode == 44) {
                out.println(new StringBuffer().append("out.print(\"").append((Object)cb).append("\");").toString());
            } else {
                if (!first) {
                    out.print((char)mode);
                }
                out.print(new StringBuffer().append("\"").append((Object)cb).append("\"").toString());
            }
        } else if (first && mode == 43) {
            out.print("\"\"");
        }
    }

    protected void printStringExpr(JavaWriter out, String exprString) throws Exception {
        if (exprString == null) {
            return;
        }
        int length = exprString.length();
        if (length == 0) {
            return;
        }
        AbstractPattern select = null;
        try {
            select = this.parseSelect(exprString);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exprString.equals(".")) {
            out.println("out.valueOf(node);");
            return;
        }
        if (exprString.charAt(0) == '@') {
            boolean isSimple = true;
            for (int i = 1; i < length; ++i) {
                char ch = exprString.charAt(i);
                if (XmlChar.isNameChar(ch) && ch != ':') continue;
                isSimple = false;
            }
            if (isSimple) {
                out.println("if (node instanceof Element)");
                out.print("  out.print(((Element) node).getAttribute(\"");
                out.print(exprString.substring(1));
                out.println("\"));");
                return;
            }
        } else if (this.allowJavaSelect(select)) {
            int oldSelectDepth = this._gen.getSelectDepth();
            String loop = new StringBuffer().append("_xsl_loop").append(this._gen.generateId()).toString();
            this._gen.setSelectLoopDepth(0);
            String ptr = this.printSelectBegin(out, select, true, loop);
            out.println(new StringBuffer().append("out.valueOf(").append(ptr).append(");").toString());
            out.println(new StringBuffer().append("break ").append(loop).append(";").toString());
            for (int selectDepth = this._gen.getSelectDepth(); oldSelectDepth < selectDepth; --selectDepth) {
                out.popDepth();
                out.println("}");
            }
            this._gen.setSelectDepth(oldSelectDepth);
            return;
        }
        out.println(new StringBuffer().append("out.valueOf(_exprs[").append(this.addExpr(exprString)).append("].evalObject(node, ").append(this._gen.getEnv()).append("));").toString());
    }

    protected void stringExpr(JavaWriter out, String exprString) throws Exception, XslParseException {
        out.print(new StringBuffer().append("_exprs[").append(this._gen.addExpr(this.parseExpr(exprString))).append("].evalString(node, ").append(this.getEnv()).append(")").toString());
    }

    protected void pushCall(JavaWriter out) throws IOException {
        out.println("{");
        out.pushDepth();
        int callDepth = this._gen.pushCallDepth();
        out.println(new StringBuffer().append("Env _xsl_arg").append(callDepth).append(" = XPath.createCall(env);").toString());
    }

    protected void popCall(JavaWriter out) throws IOException {
        int callDepth = this._gen.popCallDepth();
        out.println(new StringBuffer().append("_xsl_arg").append(callDepth).append(".free();").toString());
        out.popDepth();
        out.println("}");
    }

    protected String printSelectBegin(JavaWriter out, AbstractPattern select, boolean isForEach, String loopVar) throws IOException, XslParseException {
        if (select == null) {
            throw new NullPointerException();
        }
        if (select instanceof FromContext && ((FromContext)select).getCount() == 0) {
            return "node";
        }
        if (select instanceof FromRoot) {
            return "ownerDocument(node)";
        }
        boolean useXPath = this.allowJavaSelect(select);
        String name = "node";
        if (!useXPath) {
            String iterName = new StringBuffer().append("_xsl_iter").append(this._gen.generateId()).toString();
            String ptrName = new StringBuffer().append("_xsl_ptr").append(this._gen.generateId()).toString();
            if (isForEach) {
                out.println("env.setCurrentNode(node);");
            }
            out.println(new StringBuffer().append("Iterator ").append(iterName).append(" = _select_patterns[").append(this._gen.addSelect(select)).append("].select(").append(name).append(", env);").toString());
            if (loopVar != null && this._gen.getSelectLoopDepth() == 0) {
                out.println(new StringBuffer().append(loopVar).append(":").toString());
            }
            out.println(new StringBuffer().append("while (").append(iterName).append(".hasNext()) {").toString());
            out.pushDepth();
            this._gen.pushSelectDepth();
            this._gen.pushSelectLoopDepth();
            out.println(new StringBuffer().append("Node ").append(ptrName).append(" = (Node) ").append(iterName).append(".next();").toString());
            return ptrName;
        }
        if (select instanceof FromChildren) {
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            String ptrName = new StringBuffer().append("_xsl_ptr").append(this._gen.generateId()).toString();
            if (loopVar != null && this._gen.getSelectLoopDepth() == 0) {
                out.println(new StringBuffer().append(loopVar).append(":").toString());
            }
            out.println(new StringBuffer().append("for (Node ").append(ptrName).append(" = ").append(name).append(".getFirstChild();").toString());
            out.println(new StringBuffer().append("     ").append(ptrName).append(" != null;").toString());
            out.println(new StringBuffer().append("     ").append(ptrName).append(" = ").append(ptrName).append(".getNextSibling()) {").toString());
            out.pushDepth();
            this._gen.pushSelectDepth();
            this._gen.pushSelectLoopDepth();
            return ptrName;
        }
        if (select instanceof FromNextSibling) {
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            String ptrName = new StringBuffer().append("_xsl_ptr").append(this._gen.generateId()).toString();
            if (loopVar != null && this._gen.getSelectLoopDepth() == 0) {
                out.println(new StringBuffer().append(loopVar).append(":").toString());
            }
            out.println(new StringBuffer().append("for (Node ").append(ptrName).append(" = ").append(name).append(".getNextSibling();").toString());
            out.println(new StringBuffer().append("     ").append(ptrName).append(" != null;").toString());
            out.println(new StringBuffer().append("     ").append(ptrName).append(" = ").append(ptrName).append(".getNextSibling()) {").toString());
            out.pushDepth();
            this._gen.pushSelectDepth();
            this._gen.pushSelectLoopDepth();
            return ptrName;
        }
        if (select instanceof NodePattern) {
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            NodePattern pat = (NodePattern)select;
            out.println(new StringBuffer().append("if (").append(name).append(".getNodeName() == \"").append(pat.getNodeName()).append("\" &&").toString());
            out.println(new StringBuffer().append("    ").append(name).append(" instanceof Element) {").toString());
            out.pushDepth();
            this._gen.pushSelectDepth();
            return name;
        }
        if (select instanceof NodeTypePattern) {
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            NodeTypePattern pat = (NodeTypePattern)select;
            if (pat.getNodeType() >= 0) {
                out.println(new StringBuffer().append("if (").append(name).append(".getNodeType() == ").append(pat.getNodeType()).append(") {").toString());
                out.pushDepth();
                this._gen.pushSelectDepth();
            }
            return name;
        }
        if (select instanceof FilterPattern) {
            NumericExpr num;
            String posId = new StringBuffer().append("_xsl_pos").append(this._gen.generateId()).toString();
            out.println(new StringBuffer().append("int ").append(posId).append(" = 0;").toString());
            name = this.printSelectBegin(out, select.getParent(), isForEach, loopVar);
            out.println(new StringBuffer().append(posId).append("++;").toString());
            FilterPattern pat = (FilterPattern)select;
            Expr expr = pat.getExpr();
            if (expr instanceof NumericExpr && (num = (NumericExpr)expr).isConstant()) {
                out.println(new StringBuffer().append("if (").append(posId).append(" > ").append((int)num.getValue()).append(")").toString());
                out.println("  break;");
                out.println(new StringBuffer().append("else if (").append(posId).append(" == ").append((int)num.getValue()).append(") {").toString());
                out.pushDepth();
                this._gen.pushSelectDepth();
                return name;
            }
            throw new RuntimeException();
        }
        throw new RuntimeException(String.valueOf(select));
    }

    protected boolean allowJavaSelect(AbstractPattern select) {
        if (select == null) {
            return false;
        }
        if (!select.isStrictlyAscending()) {
            return false;
        }
        if (select instanceof FromContext) {
            return ((FromContext)select).getCount() == 0;
        }
        if (select instanceof FromRoot) {
            return true;
        }
        if (select instanceof NodePattern) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof NodeTypePattern) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FromChildren) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FromNextSibling) {
            return this.allowJavaSelect(select.getParent());
        }
        if (select instanceof FilterPattern) {
            if (!this.allowJavaSelect(select.getParent())) {
                return false;
            }
            Expr expr = ((FilterPattern)select).getExpr();
            return expr instanceof NumericExpr && ((NumericExpr)expr).isConstant();
        }
        return false;
    }

    protected void printNamespace(JavaWriter out, NamespaceContext namespace) throws Exception {
        int index = this._gen.addNamespace(namespace);
        out.print(new StringBuffer().append("_namespaces[").append(index).append("]").toString());
    }

    protected void printFragmentString(JavaWriter out, String id) throws Exception {
        String fragId = new StringBuffer().append("_frag_").append(this._gen.generateId()).toString();
        out.println(new StringBuffer().append("XMLWriter ").append(fragId).append(" = out.pushFragment();").toString());
        this.generateChildren(out);
        out.println(new StringBuffer().append(id).append(" = com.caucho.xml.XmlUtil.textValue(out.popFragment(").append(fragId).append("));").toString());
    }

    protected void printFragmentValue(JavaWriter out, String id) throws Exception {
        String fragId = new StringBuffer().append("_frag_").append(this._gen.generateId()).toString();
        out.println(new StringBuffer().append("XMLWriter ").append(fragId).append(" = out.pushFragment();").toString());
        this.generateChildren(out);
        out.println(new StringBuffer().append(id).append(" = out.popFragment(").append(fragId).append(");").toString());
    }

    protected void popScope(JavaWriter out) throws Exception {
        this.printPopScope(out);
    }

    protected void printPopScope(JavaWriter out) throws Exception {
        if (this._varCount > 0) {
            out.println(new StringBuffer().append("env.popVars(").append(this._varCount).append(");").toString());
        }
    }

    protected void printExprTest(JavaWriter out, int id, String node) throws IOException {
        out.print(new StringBuffer().append("_exprs[").append(id).append("].evalBoolean(").append(node).append(", ").append(this.getEnv()).append(")").toString());
    }

    public AbstractPattern parseMatch(String pattern) throws XslParseException, IOException {
        try {
            return XPath.parseMatch(pattern, this.getNamespace()).getPattern();
        }
        catch (Exception e) {
            throw this.error(L.l("{0} in pattern `{1}'", (Object)e.toString(), pattern));
        }
    }

    protected AbstractPattern parseSelect(String pattern) throws XslParseException {
        try {
            return XPath.parseSelect(pattern, this.getNamespace()).getPattern();
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    protected int addExpr(String pattern) throws XslParseException {
        return this._gen.addExpr(this.parseExpr(pattern));
    }

    protected Expr parseExpr(String pattern) throws XslParseException {
        try {
            return XPath.parseExpr(pattern, this.getNamespace(), this._gen.getNodeListContext());
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    protected int generateId() {
        return this._gen.generateId();
    }

    protected String getEnv() {
        return this._gen.getEnv();
    }

    public String escapeJavaString(String s) {
        if (s == null) {
            return "";
        }
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                cb.append("\\\\");
                continue;
            }
            if (s.charAt(i) == '\"') {
                cb.append("\\\"");
                continue;
            }
            if (s.charAt(i) == '\n') {
                cb.append("\\n");
                continue;
            }
            if (s.charAt(i) == '\r') {
                cb.append("\\r");
                continue;
            }
            cb.append(s.charAt(i));
        }
        return cb.close();
    }

    protected XslParseException error(String msg) {
        String filename = this._filename;
        if (filename == null) {
            filename = this._systemId;
        }
        if (filename != null) {
            return new XslParseException(new StringBuffer().append(filename).append(":").append(this._startLine).append(": ").append(msg).toString());
        }
        return new XslParseException(msg);
    }

    protected XslParseException error(Throwable e) {
        String filename = this._filename;
        if (filename == null) {
            filename = this._systemId;
        }
        if (filename == null || e instanceof LineCompileException) {
            return new XslParseException(e);
        }
        if (e instanceof CompileException) {
            return new XslParseException(new StringBuffer().append(filename).append(":").append(this._startLine).append(": ").append(e.getMessage()).toString(), e);
        }
        return new XslParseException(new StringBuffer().append(this._filename).append(":").append(this._startLine).append(": ").append(String.valueOf(e)).toString(), e);
    }

    public String toString() {
        if (this._name == null) {
            return new StringBuffer().append("<").append(this.getClass().getName()).append(">").toString();
        }
        return new StringBuffer().append("<").append(this._name.getName()).append(">").toString();
    }
}

