/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslStylesheet;
import com.caucho.xsl.java.XslTopNode;

public class XslParam
extends XslNode
implements XslTopNode {
    private String _name;
    private String _select;
    private String _as;
    private String _require;
    private boolean _isGlobal;

    public String getTagName() {
        return "xsl:param";
    }

    public String getName() {
        return this._name;
    }

    public void setParent(XslNode parent) {
        super.setParent(parent);
        if (parent instanceof XslStylesheet) {
            this._isGlobal = true;
        }
    }

    public void setGlobal(boolean isGlobal) {
        this._isGlobal = true;
    }

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("name")) {
            this._name = value;
        } else if (name.getName().equals("select")) {
            this._select = value;
        } else if (name.getName().equals("as")) {
            this._as = value;
        } else if (name.getName().equals("require")) {
            this._require = value;
        } else {
            super.addAttribute(name, value);
        }
    }

    public void endAttributes() throws XslParseException {
        if (this._name == null) {
            throw this.error(L.l("xsl:param needs a 'name' attribute."));
        }
        if (this._isGlobal) {
            this._gen.addGlobalParameter(this._name);
        }
    }

    public void generate(JavaWriter out) throws Exception {
        if (this._isGlobal) {
            out.println("if (out.getParameter(\"" + this._name + "\") != null)");
            out.println("  env.setGlobal(\"" + this._name + "\", out.getParameter(\"" + this._name + "\"));");
            out.println("else {");
            out.pushDepth();
        }
        if (this._select != null) {
            if (this._isGlobal) {
                out.print("env.setGlobal(\"" + this._name + "\", ");
                out.println("_exprs[" + this.addExpr(this._select) + "].evalObject(node, env));");
            } else {
                out.print("_exprs[" + this.addExpr(this._select) + "]");
                out.println(".addParam(env, \"" + this._name + "\", " + "node, env);");
            }
        } else if (this.hasChildren()) {
            out.println("if (env.getVar(\"" + this._name + "\") == null) {");
            out.pushDepth();
            String id = "frag" + this._gen.generateId();
            out.println("XMLWriter " + id + " = out.pushFragment();");
            this.generateChildren(out);
            if (this._isGlobal) {
                out.print("env.setGlobal(\"");
            } else {
                out.print("env.addVar(\"");
            }
            out.printJavaString(this._name);
            out.println("\", out.popFragment(" + id + "));");
            out.popDepth();
            out.println("}");
        }
        if (this._isGlobal) {
            out.popDepth();
            out.println("}");
        }
    }
}

