/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xsl.java;

import com.caucho.java.JavaWriter;
import com.caucho.xml.QName;
import com.caucho.xsl.XslParseException;
import com.caucho.xsl.java.TextNode;
import com.caucho.xsl.java.XslElementNode;
import com.caucho.xsl.java.XslNode;
import com.caucho.xsl.java.XslParam;
import com.caucho.xsl.java.XslTopNode;
import com.caucho.xsl.java.XslVariable;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class XslStylesheet
extends XslNode {
    private String _version;
    private String _id;
    private String _extensionElementPrefixes;
    private String _excludeResultPrefixes;
    private String _xpathDefaultNamespace;
    private String _defaultValidation;
    private boolean _isStyleScript;
    private boolean _isDisableOutputEscaping;
    private ArrayList<XslNode> _init = new ArrayList();
    private ArrayList<XslNode> _imports = new ArrayList();

    public String getTagName() {
        return "xsl:stylesheet";
    }

    public void setDisableOutputEscaping(boolean disable) {
        this._isDisableOutputEscaping = disable;
    }

    public void addImport(XslNode node) {
        this._imports.add(node);
    }

    public void addAttribute(QName name, String value) throws XslParseException {
        if (name.getName().equals("version")) {
            this._version = value;
        } else if (name.getName().equals("extension-element-prefixes")) {
            this._extensionElementPrefixes = value;
        } else if (name.getName().equals("exclude-result-prefixes")) {
            this._excludeResultPrefixes = value;
        } else if (name.getName().equals("xpath-default-namespace")) {
            this._xpathDefaultNamespace = value;
        } else if (name.getName().equals("default-validation")) {
            this._defaultValidation = value;
        } else if (name.getName().equals("resin:stylescript")) {
            this._gen.setStyleScript(true);
        } else {
            super.addAttribute(name, value);
        }
    }

    public void endAttributes() throws XslParseException {
        if (this._excludeResultPrefixes != null) {
            this.addExcludeResultPrefixes(this._excludeResultPrefixes);
        }
    }

    public void addChild(XslNode node) throws XslParseException {
        if (node instanceof XslVariable) {
            ((XslVariable)node).setGlobal(true);
            this._gen.addInit(node);
        } else if (node instanceof XslParam) {
            ((XslParam)node).setGlobal(true);
            this._gen.addInit(node);
        } else if (node instanceof TextNode) {
            TextNode text = (TextNode)node;
            if (!text.isWhitespace()) {
                throw this.error(L.l("text not allowed in the top level."));
            }
        } else if (!(node instanceof XslElementNode)) {
            if (!(node instanceof XslTopNode)) {
                throw this.error(L.l("<{0}> is not allowed in the top level.", node.getTagName()));
            }
            super.addChild(node);
        }
    }

    public void generate(JavaWriter out) throws Exception {
        for (int i = 0; i < this._imports.size(); ++i) {
            int oldMinImportance = this._gen.getMinImportance();
            this._gen.setMinImportance(this._gen.getImportance());
            this._imports.get(i).generate(out);
            this._gen.setMinImportance(oldMinImportance);
            this._gen.incrementImportance();
        }
        this.generateChildren(out);
    }

    public void generateDeclaration(JavaWriter out) throws Exception {
        for (int i = 0; i < this._imports.size(); ++i) {
            this._imports.get(i).generateDeclaration(out);
        }
        super.generateDeclaration(out);
    }

    private void addExcludeResultPrefixes(String prefixes) throws XslParseException {
        if (prefixes == null) {
            return;
        }
        Pattern regexp = Pattern.compile("[,\\s]+");
        String[] strings = regexp.split(prefixes);
        for (int i = 0; i < strings.length; ++i) {
            String prefix = strings[i];
            String ns = this.getNamespace(prefix);
            if (ns == null) {
                throw this.error(L.l("`{0}' must be a namespace prefix", prefix));
            }
            this._gen.addExcludedNamespace(ns);
        }
    }

    protected void printPopScope(JavaWriter out) throws Exception {
    }
}

