/*
 * Copyright (c) 1998-2012 Caucho Technology -- all rights reserved
 *
 * This file is part of Resin(R) Open Source
 *
 * Each copy or derived work must preserve the copyright notice and this
 * notice unmodified.
 *
 * Resin Open Source is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Resin Open Source is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, or any warranty
 * of NON-INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Resin Open Source; if not, write to the
 *   Free SoftwareFoundation, Inc.
 *   59 Temple Place, Suite 330
 *   Boston, MA 02111-1307  USA
 *
 * @author Scott Ferguson
 */

package com.caucho.config.types;

import com.caucho.config.xml.XmlConfigContext;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;

/**
 * Variable for __DIR__
 */
public class DirVar {
  private static final L10N L = new L10N(DirVar.class);

  public static final DirVar __DIR__ = new DirVar();
    
  private DirVar()
  {
  }
  
  public String toString()
  {
    XmlConfigContext env = XmlConfigContext.getCurrent();

    if (env != null) {
      String file = env.getBaseUri();

      if (file != null) {
        String dir = Vfs.lookup(file).getParent().getURL();

        return Vfs.decode(dir);
      }
      else
        return null;
    }
    else
      throw new IllegalStateException(L.l("__DIR__ is only available during configuration"));
  }
}
