/*
 * Copyright (c) 1998-2012 Caucho Technology -- all rights reserved
 *
 * This file is part of Resin(R) Open Source
 *
 * Each copy or derived work must preserve the copyright notice and this
 * notice unmodified.
 *
 * Resin Open Source is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Resin Open Source is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, or any warranty
 * of NON-INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Resin Open Source; if not, write to the
 *
 *   Free SoftwareFoundation, Inc.
 *   59 Temple Place, Suite 330
 *   Boston, MA 02111-1307  USA
 *
 * @author Rodrigo Westrupp
 */

package com.caucho.ejb.cfg;

import java.util.concurrent.TimeUnit;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;

/**
 * Configuration for remove-method.
 */
public class EjbTimeout {
  private static final L10N L = new L10N(EjbTimeout.class);
  
  private long _timeout;
  private TimeUnit _unit = TimeUnit.SECONDS;
  
  public void setTimeout(long timeout)
  {
    _timeout = timeout;
  }
  
  public void setUnit(String unit)
  {
    if ("Nanoseconds".equalsIgnoreCase(unit))
      _unit = TimeUnit.NANOSECONDS;
    else if ("Microseconds".equalsIgnoreCase(unit))
      _unit = TimeUnit.MICROSECONDS;
    else if ("Milliseconds".equalsIgnoreCase(unit))
      _unit = TimeUnit.MILLISECONDS;
    else if ("Seconds".equalsIgnoreCase(unit))
      _unit = TimeUnit.SECONDS;
    else if ("Minutes".equalsIgnoreCase(unit))
      _unit = TimeUnit.MINUTES;
    else if ("Hours".equalsIgnoreCase(unit))
      _unit = TimeUnit.HOURS;
    else if ("Days".equalsIgnoreCase(unit))
      _unit = TimeUnit.DAYS;
    else
      throw new ConfigException(L.l("'{0}' is an illegal unit", unit));
  }

  public long getTimeoutValue()
  {
    long value = _unit.toMillis(_timeout);
    
    return value;
  }
}
