/*
 * Copyright (c) 1998-2012 Caucho Technology -- all rights reserved
 *
 * This file is part of Resin(R) Open Source
 *
 * Each copy or derived work must preserve the copyright notice and this
 * notice unmodified.
 *
 * Resin Open Source is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Resin Open Source is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, or any warranty
 * of NON-INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Resin Open Source; if not, write to the
 *   Free SoftwareFoundation, Inc.
 *   59 Temple Place, Suite 330
 *   Boston, MA 02111-1307  USA
 *
 * @author Scott Ferguson
 */

package com.caucho.jca.cfg;

import com.caucho.config.ConfigException;

/**
 * Configuration for a connector.
 */
public class InboundResourceAdapterConfig {
  private ResourceAdapterConfig _resourceAdapter;
  
  InboundResourceAdapterConfig(ResourceAdapterConfig ra)
  {
    _resourceAdapter = ra;
  }

  /**
   * Returns the message adapter.
   */
  public MessageAdapterConfig createMessageadapter()
  {
    MessageAdapterConfig msg = new MessageAdapterConfig();

    return msg;
  }

  public class MessageAdapterConfig {
    public void addMessagelistener(MessageListenerConfig listener)
      throws ConfigException
    {
      _resourceAdapter.addMessageListener(listener);
    }
  }
}
