/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.KeyManyToOneExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.IdentifyingKeyPropertyField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.field.ManyToOneField;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

public class KeyManyToOneField
extends ManyToOneField
implements IdField {
    private static final L10N L = new L10N(KeyManyToOneField.class);
    protected static final Logger log = Logger.getLogger(KeyManyToOneField.class.getName());
    private ArrayList<KeyPropertyField> _idFields = new ArrayList();
    private boolean _isKeyField;

    public KeyManyToOneField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public KeyManyToOneField(EntityType entityType, String name, LinkColumns columns) throws ConfigException {
        super(entityType, name);
        this.setLinkColumns(columns);
        this.setSourceCascadeDelete(true);
    }

    @Override
    public String getGenerator() {
        return null;
    }

    public EntityType getEntityType() {
        return this.getEntityTargetType();
    }

    @Override
    public AmberType getType() {
        return this.getEntityTargetType();
    }

    @Override
    public AmberColumn getColumn() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAutoGenerate() {
        return false;
    }

    @Override
    public void setKeyField(boolean isKeyField) {
        this._isKeyField = isKeyField;
    }

    @Override
    public String getForeignTypeName() {
        return this.getJavaTypeName();
    }

    @Override
    public boolean isTargetCascadeDelete() {
        return false;
    }

    @Override
    public boolean isSourceCascadeDelete() {
        return true;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
        ArrayList<IdField> keys = this.getEntityTargetType().getId().getKeys();
        ArrayList<ForeignColumn> columns = this.getLinkColumns().getColumns();
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            ForeignColumn column = columns.get(i);
            IdentifyingKeyPropertyField field = new IdentifyingKeyPropertyField(this.getEntitySourceType(), column);
            this._idFields.add(field);
        }
    }

    @Override
    public int getComponentCount() {
        return this.getEntityTargetType().getId().getKeyCount();
    }

    @Override
    public ArrayList<AmberColumn> getColumns() {
        ArrayList<AmberColumn> columns = new ArrayList<AmberColumn>();
        columns.addAll(this.getLinkColumns().getColumns());
        return columns;
    }

    public KeyPropertyField getIdField(IdField field) {
        ArrayList<IdField> keys = this.getEntityTargetType().getId().getKeys();
        if (this._idFields.size() != keys.size()) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (int i = 0; i < keys.size(); ++i) {
            if (keys.get(i) != field) continue;
            return this._idFields.get(i);
        }
        throw new IllegalStateException(field.toString());
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new KeyManyToOneExpr(parent, this);
    }

    @Override
    public String generateMatchArgWhere(String id) {
        return this.getLinkColumns().generateMatchArgSQL(id);
    }

    @Override
    public String generateRawWhere(String id) {
        CharBuffer cb = new CharBuffer();
        String prefix = id + "." + this.getName();
        ArrayList<IdField> keys = this.getEntityTargetType().getId().getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(" and ");
            }
            cb.append(keys.get(i).generateRawWhere(prefix));
        }
        return cb.toString();
    }

    @Override
    public String generateGetProxyProperty(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateJoin(CharBuffer cb, String table1, String table2) {
        cb.append(this.getLinkColumns().generateJoin(table1, table2));
    }

    @Override
    public ForeignColumn getColumn(AmberColumn key) {
        return this.getLinkColumns().getSourceColumn(key);
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.generateLoadForeign(out, rs, indexVar, index, this.getForeignTypeName().replace('.', '_'));
    }

    @Override
    public String generateSuperGetter(String objThis) {
        if (this.isAbstract() || this.getGetterMethod() == null) {
            return this.getFieldName();
        }
        return this.getGetterMethod().getName() + "()";
    }

    @Override
    public String generateSuperSetter(String objThis, String value) {
        if (this.isAbstract() || this.getGetterMethod() == null || this.getSetterMethod() == null) {
            return objThis + '.' + this.getFieldName() + " = " + value + ";";
        }
        return objThis + '.' + this.getSetterMethod().getName() + "(" + value + ")";
    }

    @Override
    public void generateCopy(JavaWriter out, String dest, String source) throws IOException {
        out.println(this.generateSet(dest, this.generateGet(source)) + ";");
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        out.print("(" + this.getForeignTypeName() + ") ");
        out.print("aConn.loadProxy(\"" + this.getEntityTargetType().getName() + "\", ");
        index = this.getEntityTargetType().getId().generateLoadForeign(out, rs, indexVar, index, this.getName());
        out.println(");");
        return index;
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        if (this.isAbstract()) {
            out.println();
            out.println();
            out.println("public " + this.getJavaTypeName() + " " + this.getGetterName() + "()");
            out.println("{");
            out.println("  return " + this.getFieldName() + ";");
            out.println("}");
            out.println();
            out.println("public void " + this.getSetterName() + "(" + this.getJavaTypeName() + " v)");
            out.println("{");
            out.println("  " + this.getFieldName() + " = v;");
            out.println("}");
        }
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        ArrayList<ForeignColumn> columns = this.getLinkColumns().getColumns();
        Id id = this.getEntityTargetType().getId();
        ArrayList<IdField> keys = id.getKeys();
        String prop = value != null ? this.generateGet(value) : null;
        for (int i = 0; i < columns.size(); ++i) {
            IdField key = keys.get(i);
            ForeignColumn column = columns.get(i);
            column.generateSet(out, pstmt, index, key.generateGet(prop));
        }
    }

    @Override
    public void generateStatementSet(JavaWriter out, String pstmt, String index) throws IOException {
        String var = this.getFieldName();
        Id id = this.getEntityTargetType().getId();
        ArrayList<IdField> keys = id.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            key.getType().generateSet(out, pstmt, index, key.generateGet(var));
        }
    }

    @Override
    public void generateSetInsert(JavaWriter out, String pstmt, String index) throws IOException {
        String value = this.generateSuperGetter("this");
        out.println("if (" + this.getEntityTargetType().generateIsNull(value) + ") {");
        out.pushDepth();
        this.getEntityTargetType().generateSetNull(out, pstmt, index);
        out.popDepth();
        out.println("} else {");
        out.pushDepth();
        this.generateStatementSet(out, pstmt, index);
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateSetKeyProperty(String key, String value) throws IOException {
        if (this._isKeyField) {
            return key + "." + this.getName() + " = " + value;
        }
        return this.generateSet(key, value);
    }

    @Override
    public String generateGetKeyProperty(String key) throws IOException {
        if (this._isKeyField) {
            return key + "." + this.getName();
        }
        return this.generateGet(key);
    }

    @Override
    public void generateSetGeneratedKeys(JavaWriter out, String pstmt) throws IOException {
    }

    @Override
    public void generateCheckCreateKey(JavaWriter out) throws IOException {
        out.println("if (" + this.generateSuperGetter("this") + " == null)");
        out.println("  throw new com.caucho.amber.AmberException(\"primary key must not be null on creation.  " + this.getGetterName() + "() must not return null.\");");
    }

    @Override
    public String generateIsNull(String value) {
        return "(" + value + " == null)";
    }

    @Override
    public String toValue(String value) {
        return "((" + this.getJavaTypeName() + ") " + value + ")";
    }
}

