/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.actor;

import com.caucho.bam.BamError;
import com.caucho.bam.BamException;
import com.caucho.bam.Message;
import com.caucho.bam.MessageError;
import com.caucho.bam.Query;
import com.caucho.bam.QueryError;
import com.caucho.bam.QueryResult;
import com.caucho.bam.actor.SkeletonInvocationException;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.stream.MessageStream;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BamSkeleton<S> {
    private static final L10N L = new L10N(BamSkeleton.class);
    private static final Logger log = Logger.getLogger(BamSkeleton.class.getName());
    private static final WeakHashMap<Class<?>, SoftReference<BamSkeleton<?>>> _skeletonRefMap = new WeakHashMap();
    private Class<?> _cl;
    private final HashMap<Class<?>, Method> _messageHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _messageErrorHandlers = new HashMap();
    private final HashMap<Class<?>, QueryInvoker> _queryHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _queryResultHandlers = new HashMap();
    private final HashMap<Class<?>, Method> _queryErrorHandlers = new HashMap();

    private BamSkeleton(Class<S> cl) {
        this._cl = cl;
        log.finest(L.l("{0} introspecting class {1}", (Object)this, (Object)cl.getName()));
        this.introspect(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> BamSkeleton<T> getSkeleton(Class<T> cl) {
        WeakHashMap<Class<?>, SoftReference<BamSkeleton<?>>> weakHashMap = _skeletonRefMap;
        synchronized (weakHashMap) {
            SoftReference<BamSkeleton<?>> skeletonRef = _skeletonRefMap.get(cl);
            BamSkeleton<Object> skeleton = null;
            if (skeletonRef != null) {
                skeleton = skeletonRef.get();
            }
            if (skeleton == null) {
                skeleton = new BamSkeleton<T>(cl);
                _skeletonRefMap.put(cl, new SoftReference(skeleton));
            }
            return skeleton;
        }
    }

    public void message(S actor, MessageStream fallback, String to, String from, Serializable payload) {
        Method handler = payload != null ? this._messageHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " message " + payload + " {from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, to, from, payload);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.message(to, from, payload);
        }
    }

    public void messageError(S actor, MessageStream fallback, String to, String from, Serializable payload, BamError error) {
        Method handler = payload != null ? this._messageErrorHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " messageError " + error + " " + payload + " {from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, to, from, payload, error);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.messageError(to, from, payload, error);
        }
    }

    public void query(S actor, MessageStream fallback, Broker broker, long id, String to, String from, Serializable payload) {
        QueryInvoker handler = payload != null ? this._queryHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " query " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, broker, id, to, from, payload);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.query(id, to, from, payload);
        }
    }

    public void queryResult(S actor, MessageStream fallback, long id, String to, String from, Serializable payload) {
        Method handler = payload != null ? this._queryResultHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " queryResult " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, id, to, from, payload);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.queryResult(id, to, from, payload);
        }
    }

    public void queryError(S actor, MessageStream fallback, long id, String to, String from, Serializable payload, BamError error) {
        Method handler = payload != null ? this._queryErrorHandlers.get(payload.getClass()) : null;
        if (handler != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(actor + " queryError " + error + " " + payload + " {id: " + id + ", from:" + from + ", to:" + to + "}");
            }
            try {
                handler.invoke(actor, id, to, from, payload, error);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw SkeletonInvocationException.createRuntimeException(cause);
            }
            catch (Exception e) {
                throw SkeletonInvocationException.createRuntimeException(e);
            }
        } else {
            fallback.queryError(id, to, from, payload, error);
        }
    }

    protected void introspect(Class<?> cl) {
        if (cl == null) {
            return;
        }
        this.introspect(cl.getSuperclass());
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?> payloadType = this.getPayloadType(Message.class, method);
            if (payloadType != null) {
                log.log(Level.ALL, L.l("{0} introspect @Message {1} method={2}", (Object)this, (Object)payloadType.getName(), (Object)method));
                method.setAccessible(true);
                this._messageHandlers.put(payloadType, method);
                continue;
            }
            payloadType = this.getPayloadType(MessageError.class, method);
            if (payloadType != null) {
                log.log(Level.ALL, L.l("{0} introspect @MessageError {1} method={2}", (Object)this, (Object)payloadType.getName(), (Object)method));
                method.setAccessible(true);
                this._messageErrorHandlers.put(payloadType, method);
                continue;
            }
            payloadType = this.getQueryPayloadType(Query.class, method);
            if (payloadType != null) {
                log.log(Level.ALL, L.l("{0} @Query {1} method={2}", (Object)this, (Object)payloadType.getName(), (Object)method));
                method.setAccessible(true);
                if (method.getParameterTypes().length == 1) {
                    this._queryHandlers.put(payloadType, new QueryShortMethodInvoker(method));
                    continue;
                }
                if (method.getParameterTypes().length == 4) {
                    this._queryHandlers.put(payloadType, new QueryMethodInvoker(method));
                    continue;
                }
                throw new IllegalStateException(String.valueOf(method));
            }
            payloadType = this.getQueryPayloadType(QueryResult.class, method);
            if (payloadType != null) {
                log.log(Level.ALL, L.l("{0} @QueryResult {1} method={2}", (Object)this, (Object)payloadType.getName(), (Object)method));
                method.setAccessible(true);
                this._queryResultHandlers.put(payloadType, method);
                continue;
            }
            payloadType = this.getQueryErrorPayloadType(QueryError.class, method);
            if (payloadType == null) continue;
            log.log(Level.ALL, L.l("{0} @QueryError {1} method={2}", (Object)this, (Object)payloadType.getName(), (Object)method));
            method.setAccessible(true);
            this._queryErrorHandlers.put(payloadType, method);
        }
    }

    private Class<?> getPayloadType(Class<? extends Annotation> annotationType, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length < 3) {
            return null;
        }
        if (method.isAnnotationPresent(annotationType)) {
            return paramTypes[2];
        }
        return null;
    }

    private Class<?> getQueryPayloadType(Class<? extends Annotation> annotationType, Method method) {
        if (!method.isAnnotationPresent(annotationType)) {
            return null;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 1 && Serializable.class.isAssignableFrom(paramTypes[0])) {
            return paramTypes[0];
        }
        if (paramTypes.length == 4 && Long.TYPE.equals(paramTypes[0]) && String.class.equals(paramTypes[1]) && String.class.equals(paramTypes[2]) && Serializable.class.isAssignableFrom(paramTypes[3])) {
            return paramTypes[3];
        }
        throw new BamException(method + " is an invalid  @" + annotationType.getSimpleName() + " because queries require (long, String, String, MyPayload)");
    }

    private Class<?> getQueryErrorPayloadType(Class<? extends Annotation> annotationType, Method method) {
        if (!method.isAnnotationPresent(annotationType)) {
            return null;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (!(paramTypes.length == 5 && Long.TYPE.equals(paramTypes[0]) && String.class.equals(paramTypes[1]) && String.class.equals(paramTypes[2]) && Serializable.class.isAssignableFrom(paramTypes[3]) && BamError.class.isAssignableFrom(paramTypes[4]))) {
            throw new BamException(method + " is an invalid  @" + annotationType.getSimpleName() + " because queries require (long, String, String, MyPayload, ActorError)");
        }
        return paramTypes[3];
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cl.getName() + "]";
    }

    static class QueryShortMethodInvoker
    extends QueryInvoker {
        private final Method _method;

        QueryShortMethodInvoker(Method method) {
            this._method = method;
        }

        @Override
        public void invoke(Object actor, Broker broker, long id, String to, String from, Serializable payload) throws IllegalAccessException, InvocationTargetException {
            Object result = this._method.invoke(actor, payload);
            broker.queryResult(id, from, to, (Serializable)result);
        }
    }

    static class QueryMethodInvoker
    extends QueryInvoker {
        private final Method _method;

        QueryMethodInvoker(Method method) {
            this._method = method;
        }

        @Override
        public void invoke(Object actor, Broker broker, long id, String to, String from, Serializable payload) throws IllegalAccessException, InvocationTargetException {
            this._method.invoke(actor, id, to, from, payload);
        }
    }

    static abstract class QueryInvoker {
        QueryInvoker() {
        }

        public abstract void invoke(Object var1, Broker var2, long var3, String var5, String var6, Serializable var7) throws IllegalAccessException, InvocationTargetException;
    }
}

