/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.proxy;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.Actor;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.SimpleActorSender;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.proxy.ProxySkeleton;
import com.caucho.bam.stream.MessageStream;
import com.caucho.bam.stream.NullMessageStream;
import java.io.Serializable;
import java.util.logging.Logger;

public class ProxyActor<T>
implements Actor {
    private static final Logger log = Logger.getLogger(ProxyActor.class.getName());
    private String _address;
    private T _bean;
    private Broker _broker;
    private ProxySkeleton<T> _skeleton;
    private SimpleActorSender _sender;
    private MessageStream _fallback;

    public ProxyActor(T bean, String address, Broker broker) {
        this._address = address;
        this._bean = bean;
        this._broker = broker;
        this._skeleton = ProxySkeleton.getSkeleton(bean.getClass());
        this._fallback = new NullMessageStream(address, broker);
        this._sender = new SimpleActorSender(address, this, this._broker);
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    public ActorSender getSender() {
        return this._sender;
    }

    @Override
    public Broker getBroker() {
        return this._broker;
    }

    public Actor getActor() {
        return this._sender.getActor();
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        this._skeleton.message(this._bean, this._fallback, to, from, payload);
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        this._skeleton.query(this._bean, this._fallback, this.getBroker(), id, to, from, payload);
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._address + "," + this._bean + "]";
    }
}

