/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.query;

import com.caucho.bam.BamError;
import com.caucho.bam.BamException;
import com.caucho.bam.ErrorPacketException;
import com.caucho.bam.TimeoutException;
import com.caucho.bam.query.QueryCallback;
import com.caucho.bam.query.QueryFuture;
import com.caucho.bam.stream.MessageStream;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.WeakAlarm;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class QueryManager {
    private final String _id;
    private final AtomicLong _qId = new AtomicLong();
    private final QueryMap _queryMap = new QueryMap();
    private AlarmListener _listener = new TimeoutAlarmListener();
    private Alarm _alarm = new WeakAlarm(this._listener);
    private long _timeout = 900000L;

    public QueryManager(String id) {
        this._id = id;
    }

    public QueryManager(String id, long seed) {
        this(id);
        this._qId.set(seed);
    }

    public boolean isEmpty() {
        return this._queryMap.isEmpty();
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public final long nextQueryId() {
        return this._qId.incrementAndGet();
    }

    public void addQueryCallback(long id, QueryCallback callback, long timeout) {
        this._queryMap.add(id, callback, timeout);
        Alarm alarm = this._alarm;
        long expireTime = timeout + CurrentTime.getCurrentTime();
        if (!(alarm == null || alarm.isQueued() && expireTime >= alarm.getWakeTime())) {
            alarm.queueAt(expireTime);
        }
    }

    public QueryFuture addQueryFuture(long id, String to, String from, Serializable payload, long timeout) {
        QueryFutureImpl future = new QueryFutureImpl(id, to, from, payload, timeout);
        this.addQueryCallback(id, future, timeout);
        return future;
    }

    public void query(MessageStream stream, String to, String from, Serializable payload, QueryCallback cb, long timeout) {
        long id = this.nextQueryId();
        this.addQueryCallback(id, cb, timeout);
        stream.query(id, to, from, payload);
    }

    public Serializable query(MessageStream stream, String to, String from, Serializable payload, long timeout) {
        long id = this.nextQueryId();
        QueryFuture future = this.addQueryFuture(id, to, from, payload, timeout);
        stream.query(id, to, from, payload);
        return future.get();
    }

    public final boolean onQueryResult(long id, String to, String from, Serializable payload) {
        QueryItem item = this._queryMap.remove(id);
        if (item != null) {
            item.onQueryResult(to, from, payload);
            return true;
        }
        return false;
    }

    public final boolean onQueryError(long id, String to, String from, Serializable payload, BamError error) {
        QueryItem item = this._queryMap.remove(id);
        if (item != null) {
            item.onQueryError(to, from, payload, error);
            return true;
        }
        return false;
    }

    void checkTimeout(long now) {
        this._queryMap.checkTimeout(now);
    }

    public void close() {
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }

    class TimeoutAlarmListener
    implements AlarmListener {
        TimeoutAlarmListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleAlarm(Alarm alarm) {
            try {
                long now = CurrentTime.getCurrentTime();
                QueryManager.this.checkTimeout(now);
            }
            finally {
                if (QueryManager.this._alarm == alarm && !QueryManager.this.isEmpty()) {
                    alarm.queue(QueryManager.this.getTimeout());
                }
            }
        }
    }

    static final class QueryFutureImpl
    implements QueryCallback,
    QueryFuture {
        private final long _id;
        private final String _to;
        private final String _from;
        private final Serializable _payload;
        private final long _timeout;
        private volatile Serializable _result;
        private volatile BamError _error;
        private final AtomicBoolean _isResult = new AtomicBoolean();
        private volatile Thread _thread;

        QueryFutureImpl(long id, String to, String from, Serializable payload, long timeout) {
            this._id = id;
            this._to = to;
            this._from = from;
            this._payload = payload;
            this._timeout = timeout;
        }

        public Serializable getResult() {
            return this._result;
        }

        @Override
        public Serializable get() throws TimeoutException, BamException {
            if (!this.waitFor(this._timeout)) {
                throw new TimeoutException(this + " query timeout " + this._timeout + "ms for " + this._payload + " {to:" + this._to + "}");
            }
            if (this.getError() != null) {
                ErrorPacketException exn = this.getError().createException();
                if (exn.getSourceException() instanceof RuntimeException) {
                    throw (RuntimeException)exn.getSourceException();
                }
                throw exn;
            }
            return this.getResult();
        }

        public BamError getError() {
            return this._error;
        }

        boolean waitFor(long timeout) {
            this._thread = Thread.currentThread();
            long now = CurrentTime.getCurrentTimeActual();
            long expires = now + timeout;
            while (!this._isResult.get() && CurrentTime.getCurrentTimeActual() <= expires) {
                try {
                    Thread.interrupted();
                    LockSupport.parkUntil(expires);
                }
                catch (Exception exception) {}
            }
            this._thread = null;
            return this._isResult.get();
        }

        @Override
        public void onQueryResult(String fromAddress, String toAddress, Serializable payload) {
            this._result = payload;
            this._isResult.set(true);
            Thread thread = this._thread;
            if (thread != null) {
                LockSupport.unpark(thread);
            }
        }

        @Override
        public void onQueryError(String fromAddress, String toAddress, Serializable payload, BamError error) {
            this._error = error;
            this._isResult.set(true);
            Thread thread = this._thread;
            if (thread != null) {
                LockSupport.unpark(thread);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[to=" + this._to + ",from=" + this._from + ",payload=" + this._payload + "]";
        }
    }

    static final class QueryItem {
        private final long _id;
        private final QueryCallback _callback;
        private final long _expires;
        private QueryItem _next;

        QueryItem(long id, QueryCallback callback, long expires, QueryItem next) {
            this._id = id;
            this._callback = callback;
            this._expires = expires;
            this._next = next;
        }

        final long getId() {
            return this._id;
        }

        final QueryItem getNext() {
            return this._next;
        }

        final void setNext(QueryItem next) {
            this._next = next;
        }

        final long getExpires() {
            return this._expires;
        }

        void onQueryResult(String to, String from, Serializable value) {
            if (this._callback != null) {
                this._callback.onQueryResult(to, from, value);
            }
        }

        void onQueryError(String to, String from, Serializable value, BamError error) {
            if (this._callback != null) {
                this._callback.onQueryError(to, from, value, error);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._id + "," + this._callback + "]";
        }
    }

    static final class QueryMap {
        private final QueryItem[] _entries = new QueryItem[128];
        private final int _mask = this._entries.length - 1;

        QueryMap() {
        }

        boolean isEmpty() {
            for (QueryItem item : this._entries) {
                if (item == null) continue;
                return false;
            }
            return true;
        }

        void checkTimeout(long now) {
            for (QueryItem item : this._entries) {
                while (item != null) {
                    QueryItem next = item.getNext();
                    if (item._expires < now && (item = this.remove(item.getId())) != null) {
                        QueryCallback cb = item._callback;
                        TimeoutException exn = new TimeoutException(item.toString());
                        BamError error = BamError.create(exn);
                        cb.onQueryError(null, null, null, error);
                    }
                    item = next;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(long id, QueryCallback callback, long timeout) {
            long expires = timeout + CurrentTime.getCurrentTime();
            int hash = (int)(id & (long)this._mask);
            QueryItem[] queryItemArray = this._entries;
            synchronized (this._entries) {
                this._entries[hash] = new QueryItem(id, callback, expires, this._entries[hash]);
                // ** MonitorExit[var9_6] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        QueryItem remove(long id) {
            int hash = (int)(id & (long)this._mask);
            QueryItem[] queryItemArray = this._entries;
            synchronized (this._entries) {
                QueryItem prev = null;
                QueryItem next = null;
                QueryItem ptr = this._entries[hash];
                while (ptr != null) {
                    next = ptr.getNext();
                    if (id == ptr.getId()) {
                        if (prev != null) {
                            prev.setNext(next);
                        } else {
                            this._entries[hash] = next;
                        }
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        return ptr;
                    }
                    prev = ptr;
                    ptr = next;
                    ptr = next;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
        }
    }
}

