/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.Version;
import com.caucho.boot.BootCommand;
import com.caucho.boot.BootOption;
import com.caucho.boot.FlagBootOption;
import com.caucho.boot.ResinBoot;
import com.caucho.boot.SpacerBootOption;
import com.caucho.boot.SubsectionBootOption;
import com.caucho.boot.ValueBootOption;
import com.caucho.boot.ValueIntBootOption;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogManager;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractBootCommand
implements BootCommand {
    private static final L10N L = new L10N(AbstractBootCommand.class);
    private final Map<String, BootOption> _optionMap = new LinkedHashMap<String, BootOption>();

    protected AbstractBootCommand() {
        this.initBootOptions();
    }

    protected void initBootOptions() {
        this.addSubsectionHeaderOption("general options:");
        this.addValueOption("conf", "file", "alternate resin.xml file");
        this.addValueOption("user-properties", "file", "select an alternate $HOME/.resin file");
        this.addValueOption("mode", "string", "select .resin properties mode");
        this.addSpacerOption();
        this.addValueOption("resin-home", "dir", "alternate resin home");
        this.addValueOption("root-directory", "dir", "alternate root directory");
        this.addValueOption("resin-root", "dir", "alternate root directory", true);
        this.addValueOption("server-root", "dir", "alternate root directory", true);
        this.addValueOption("log-directory", "dir", "alternate log directory");
        this.addValueOption("license-directory", "dir", "alternate license directory");
        this.addValueOption("data-directory", "dir", "alternate resin-data directory");
        this.addSpacerOption();
        this.addFlagOption("verbose", "produce verbose output");
    }

    @Override
    public String getName() {
        String name = this.getClass().getSimpleName();
        int p = name.indexOf("Command");
        if (p >= 0) {
            name = name.substring(0, p);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public boolean isProOnly() {
        return false;
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return false;
    }

    @Override
    public int doCommand(ResinBoot boot, WatchdogArgs args) {
        WatchdogClient client = this.findClient(boot, args);
        return this.doCommand(args, client);
    }

    @Override
    public void doWatchdogStart(WatchdogManager manager) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected WatchdogClient findClient(ResinBoot boot, WatchdogArgs args) {
        WatchdogClient client = this.findNamedClient(boot, args, args.getServerId());
        if (client != null) {
            return client;
        }
        client = this.findLocalClient(boot, args);
        if (client == null) {
            client = this.findWatchdogClient(boot, args);
        }
        if (client == null) {
            throw new ConfigException(L.l("No <server> can be found listening to a local IP address"));
        }
        return client;
    }

    protected WatchdogClient findNamedClient(ResinBoot boot, WatchdogArgs args, String serverId) {
        return this.findNamedClientImpl(boot, args, args.getServerId());
    }

    protected WatchdogClient findNamedClientImpl(ResinBoot boot, WatchdogArgs args, String serverId) {
        return boot.findClient(serverId, args);
    }

    protected WatchdogClient findLocalClient(ResinBoot boot, WatchdogArgs args) {
        return this.findLocalClientImpl(boot, args);
    }

    protected WatchdogClient findLocalClientImpl(ResinBoot boot, WatchdogArgs args) {
        ArrayList<WatchdogClient> clients = boot.findLocalClients();
        if (clients == null) {
            return null;
        }
        for (WatchdogClient client : clients) {
            if (client.getConfig().isRequireExplicitId()) continue;
            return client;
        }
        return null;
    }

    protected WatchdogClient findUniqueLocalClient(ResinBoot boot, WatchdogArgs args) {
        ArrayList<WatchdogClient> clients = boot.findLocalClients();
        if (clients == null) {
            return null;
        }
        WatchdogClient foundClient = null;
        for (WatchdogClient client : clients) {
            if (client.getConfig().isRequireExplicitId()) continue;
            if (foundClient == null) {
                foundClient = client;
                continue;
            }
            throw new ConfigException(L.l("Resin/{0}: server '{1}' does not match a unique <server> or <server-multi>\nwith a unique local IP in {2}.\n  server ids: {3}", (Object)Version.VERSION, (Object)"", (Object)args.getResinConf().getNativePath(), (Object)boot.findLocalClientIds()));
        }
        return foundClient;
    }

    protected WatchdogClient findWatchdogClient(ResinBoot boot, WatchdogArgs args) {
        return this.findWatchdogClientImpl(boot, args);
    }

    protected WatchdogClient findWatchdogClientImpl(ResinBoot boot, WatchdogArgs args) {
        return boot.findWatchdogClient(args);
    }

    protected int doCommand(WatchdogArgs args, WatchdogClient client) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    protected void addOption(BootOption option) {
        this.addOption(option, 0);
    }

    protected void addOption(BootOption option, int orderOffset) {
        this._optionMap.put(option.getName(), option);
    }

    protected void addFlagOption(String name, String description) {
        this.addOption(new FlagBootOption(name, description));
    }

    protected void addValueOption(String name, String value, String description) {
        this.addValueOption(name, value, description, false);
    }

    protected void addValueOption(String name, String value, String description, boolean deprecated) {
        this.addOption(new ValueBootOption(name, value, description, deprecated));
    }

    protected void addIntValueOption(String name, String value, String description) {
        this.addOption(new ValueIntBootOption(name, value, description));
    }

    protected void addSpacerOption() {
        this.addOption(new SpacerBootOption());
    }

    protected void addSubsectionHeaderOption(String header) {
        this.addOption(new SubsectionBootOption(header));
    }

    public String getOptionUsage(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        BootOption lastOption = null;
        for (BootOption option : this._optionMap.values()) {
            if (option instanceof SpacerBootOption && lastOption instanceof SpacerBootOption || !verbose && option.isDeprecated()) continue;
            sb.append(option.getUsage() + "\n");
            lastOption = option;
        }
        return sb.toString();
    }

    @Override
    public boolean isValueOption(String key) {
        BootOption option = this.getBootOption(key);
        return option != null && option.isValue();
    }

    @Override
    public boolean isIntValueOption(String key) {
        BootOption option = this.getBootOption(key);
        return option != null && option.isIntValue();
    }

    @Override
    public boolean isFlag(String key) {
        BootOption option = this.getBootOption(key);
        return option != null && option.isFlag();
    }

    private BootOption getBootOption(String key) {
        if (key.length() == 0 || key.charAt(0) != '-') {
            return null;
        }
        String cleanKey = key.length() > 1 && key.charAt(0) == '-' && key.charAt(1) == '-' ? key.substring(2) : key.substring(1);
        BootOption option = this._optionMap.get(cleanKey);
        return option;
    }

    @Override
    public boolean isRetry() {
        return false;
    }

    @Override
    public int retryCount() {
        return this.isRetry() ? 5 : 0;
    }

    @Override
    public final void usage(boolean verbose) {
        System.err.println("usage: resinctl " + this.getName() + " [--options]" + this.getUsageArgs());
        System.err.println();
        System.err.println("  " + this.getDescription() + (this.isProOnly() ? " (Resin Pro)" : ""));
        System.err.println();
        System.err.println("where command options include:");
        System.err.println();
        System.err.print(this.getOptionUsage(verbose));
    }

    public String getUsageArgs() {
        return "";
    }

    @Override
    public boolean isStart() {
        return false;
    }

    @Override
    public boolean isStartAll() {
        return false;
    }

    @Override
    public boolean isConsole() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isRemote(WatchdogArgs args) {
        return args.getArg("-address") != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

