/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.BootCommand;
import com.caucho.boot.ConfigUndeployCommand;
import com.caucho.boot.ConsoleCommand;
import com.caucho.boot.DeployCatCommand;
import com.caucho.boot.DeployCommand;
import com.caucho.boot.DeployCopyCommand;
import com.caucho.boot.DeployListCommand;
import com.caucho.boot.DeployLsCommand;
import com.caucho.boot.DisableCommand;
import com.caucho.boot.DisableSoftCommand;
import com.caucho.boot.EnableCommand;
import com.caucho.boot.GuiCommand;
import com.caucho.boot.HeapDumpCommand;
import com.caucho.boot.JmxCallCommand;
import com.caucho.boot.JmxDumpCommand;
import com.caucho.boot.JmxListCommand;
import com.caucho.boot.JmxSetCommand;
import com.caucho.boot.JspcCommand;
import com.caucho.boot.KillCommand;
import com.caucho.boot.LicenseAddCommand;
import com.caucho.boot.ListRestartsCommand;
import com.caucho.boot.LogLevelCommand;
import com.caucho.boot.PasswordEncryptCommand;
import com.caucho.boot.PasswordGenerateCommand;
import com.caucho.boot.PdfReportCommand;
import com.caucho.boot.ProfileCommand;
import com.caucho.boot.RestartCommand;
import com.caucho.boot.ScoreboardCommand;
import com.caucho.boot.ShutdownCommand;
import com.caucho.boot.StartAllCommand;
import com.caucho.boot.StartCommand;
import com.caucho.boot.StartWithForegroundCommand;
import com.caucho.boot.StatusCommand;
import com.caucho.boot.StopCommand;
import com.caucho.boot.ThreadDumpCommand;
import com.caucho.boot.UndeployCommand;
import com.caucho.boot.WatchdogCommand;
import com.caucho.boot.WebAppDeployCommand;
import com.caucho.boot.WebAppRestartClusterCommand;
import com.caucho.boot.WebAppRestartCommand;
import com.caucho.boot.WebAppStartCommand;
import com.caucho.boot.WebAppStopCommand;
import com.caucho.boot.WebAppUndeployCommand;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.license.LicenseCheck;
import com.caucho.loader.Environment;
import com.caucho.server.resin.ResinELContext;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CurrentTime;
import com.caucho.util.HostUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class WatchdogArgs {
    private static L10N L = new L10N(WatchdogArgs.class);
    private static final Logger log = Logger.getLogger(WatchdogArgs.class.getName());
    private static final HashMap<String, BootCommand> _commandMap = new HashMap();
    private final String _clientServerId;
    private Path _javaHome;
    private Path _resinHome;
    private Path _rootDirectory;
    private Path _dataDirectory;
    private String[] _argv;
    private Path _resinConf;
    private Path _userProperties;
    private String _mode;
    private Path _logDirectory;
    private Path _licenseDirectory;
    private String _serverId = null;
    private String _clusterId;
    private int _watchdogPort;
    private boolean _isVerbose;
    private boolean _isHelp;
    private BootCommand _command;
    private ArrayList<String> _tailArgs = new ArrayList();
    private String[] _defaultArgs;
    private boolean _isElasticServer;
    private boolean _isElasticIp;
    private String _elasticAddress;
    private int _elasticPort;
    private ResinBootELContext _resinBootELContext = null;
    private boolean _is64bit;

    WatchdogArgs(String[] argv) {
        this(argv, true);
    }

    WatchdogArgs(String[] argv, boolean isTop) {
        this(argv, System.getProperty("resin.watchdog"), isTop);
    }

    WatchdogArgs(String[] argv, String serverId, boolean isTop) {
        this._clientServerId = serverId;
        String logLevel = System.getProperty("resin.log.level");
        if (isTop) {
            this.setLogLevel(logLevel);
        }
        this.setResinHome(WatchdogArgs.calculateResinHome());
        this.setRootDirectory(WatchdogArgs.calculateResinRoot(this._resinHome));
        this._javaHome = Vfs.lookup(System.getProperty("java.home"));
        this._is64bit = CauchoSystem.is64Bit();
        this._resinConf = this._resinHome.lookup("conf/resin.conf");
        if (!this._resinConf.canRead()) {
            this._resinConf = this._resinHome.lookup("conf/resin.xml");
        }
        this._userProperties = Vfs.lookup(System.getProperty("user.home") + "/.resin");
        this._argv = this.fillArgv(argv);
        this.parseCommandLine(this._argv);
    }

    String[] getRawArgv() {
        return this._argv;
    }

    Path getJavaHome() {
        return this._javaHome;
    }

    Path getResinHome() {
        return this._resinHome;
    }

    Path getRootDirectory() {
        return this._rootDirectory;
    }

    Path getDataDirectory() {
        return this._dataDirectory;
    }

    Path getLogDirectory() {
        return this._logDirectory;
    }

    Path getLicenseDirectory() {
        return this._licenseDirectory;
    }

    Path getResinConf() {
        return this._resinConf;
    }

    Path getUserProperties() {
        return this._userProperties;
    }

    String getMode() {
        return this._mode;
    }

    String getClientServerId() {
        return this._clientServerId;
    }

    String getServerId() {
        return this._serverId;
    }

    void setElasticServerId(String serverId) {
        this._serverId = serverId;
        this.setElasticServer(true);
    }

    void setElasticServer(boolean isElastic) {
        this._isElasticServer = isElastic;
    }

    String getClusterId() {
        return this._clusterId;
    }

    String[] getArgv() {
        return this._argv;
    }

    boolean isElasticServer() {
        return this._isElasticServer;
    }

    boolean isElasticDns() {
        return this.getArgBoolean("-elastic-dns", false);
    }

    String getDynamicAddress() {
        if (!this._isElasticServer) {
            return null;
        }
        if (this._elasticAddress != null) {
            return this._elasticAddress;
        }
        try {
            return HostUtil.getLocalHostAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    String getDynamicDisplayAddress() {
        if (this._elasticAddress != null) {
            return this._elasticAddress;
        }
        if (CurrentTime.isTest()) {
            return "192.168.1.x";
        }
        try {
            return HostUtil.getLocalHostAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    int getDynamicPort() {
        return this._elasticPort;
    }

    String getElasticServerId() {
        if (this._serverId != null) {
            return this._serverId;
        }
        return "dyn-" + this.getDynamicDisplayAddress() + ":" + this.getDynamicPort();
    }

    boolean isVerbose() {
        return this._isVerbose;
    }

    void setWatchdogPort(int port) {
        this._watchdogPort = port;
    }

    int getWatchdogPort() {
        return this._watchdogPort;
    }

    void setResinHome(Path resinHome) {
        this._resinHome = resinHome;
        System.setProperty("resin.home", resinHome.getNativePath());
    }

    void setRootDirectory(Path resinRoot) {
        this._rootDirectory = resinRoot;
        System.setProperty("resin.root", resinRoot.getNativePath());
    }

    boolean is64Bit() {
        return this._is64bit;
    }

    BootCommand getCommand() {
        return this._command;
    }

    public ArrayList<String> getTailArgs() {
        return this._tailArgs;
    }

    public String getArg(String arg) {
        int i = 0;
        while (i + 1 < this._argv.length) {
            if (this._argv[i].equals(arg) || this._argv[i].equals("-" + arg)) {
                return this._argv[i + 1];
            }
            ++i;
        }
        return null;
    }

    public String getArgFlag(String arg) {
        for (int i = 0; i < this._argv.length; ++i) {
            if (this._argv[i].equals(arg) || this._argv[i].equals("-" + arg)) {
                return this._argv[i];
            }
            if (this._argv[i].startsWith(arg + "=")) {
                return this._argv[i].substring(arg.length() + 1);
            }
            if (!this._argv[i].startsWith("-" + arg + "=")) continue;
            return this._argv[i].substring(arg.length() + 2);
        }
        return null;
    }

    public boolean getArgBoolean(String arg, boolean defaultValue) {
        String value = this.getArgFlag(arg);
        if (value == null) {
            return defaultValue;
        }
        return !"no".equals(value) && !"false".equals(value);
    }

    public int getArgInt(String arg, int defaultValue) {
        String value = this.getArg(arg);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            NumberFormatException e1 = new NumberFormatException(WatchdogArgs.L().l("{0} argument is not a number '{1}'", (Object)arg, (Object)value));
            e1.setStackTrace(e.getStackTrace());
            throw e;
        }
    }

    public boolean hasOption(String option) {
        for (String arg : this._argv) {
            if (!arg.equals(option) && !arg.equals('-' + option)) continue;
            return true;
        }
        return false;
    }

    public boolean isResinProfessional() {
        return this.getELContext().isResinProfessional();
    }

    public ResinELContext getELContext() {
        if (this._resinBootELContext == null) {
            this._resinBootELContext = new ResinBootELContext();
        }
        return this._resinBootELContext;
    }

    public String getDefaultArg() {
        String defaultArg = null;
        if (this._defaultArgs.length > 0) {
            defaultArg = this._defaultArgs[0];
        }
        return defaultArg;
    }

    public String[] getDefaultArgs() {
        return this._defaultArgs;
    }

    public boolean isHelp() {
        return this._isHelp;
    }

    private void setLogLevel(String levelName) {
        Level level = Level.INFO;
        if ("off".equals(levelName)) {
            level = Level.OFF;
        } else if ("all".equals(levelName)) {
            level = Level.ALL;
        } else if ("severe".equals(levelName)) {
            level = Level.SEVERE;
        } else if ("warning".equals(levelName)) {
            level = Level.WARNING;
        } else if ("info".equals(levelName)) {
            level = Level.INFO;
        } else if ("config".equals(levelName)) {
            level = Level.CONFIG;
        } else if ("fine".equals(levelName)) {
            level = Level.FINE;
        } else if ("finer".equals(levelName)) {
            level = Level.FINER;
        } else if ("finest".equals(levelName)) {
            level = Level.FINEST;
        }
        Logger.getLogger("").setLevel(level);
    }

    private void parseCommandLine(String[] argv) {
        String resinConf = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            String resinArg = arg;
            if (resinArg.startsWith("-") && !resinArg.startsWith("--")) {
                resinArg = "-" + resinArg;
            }
            if ("--conf".equals(resinArg)) {
                resinConf = argv[i + 1];
                ++i;
                continue;
            }
            if ("--user-properties".equals(resinArg)) {
                this._userProperties = Vfs.lookup(argv[i + 1]);
                ++i;
                continue;
            }
            if ("--mode".equals(resinArg)) {
                this._mode = argv[i + 1];
                ++i;
                continue;
            }
            if ("--join-cluster".equals(resinArg)) {
                this.setElasticServer(true);
                this._clusterId = argv[i + 1];
                ++i;
                continue;
            }
            if ("--elastic-server".equals(resinArg)) {
                this.setElasticServer(true);
                continue;
            }
            if ("--cluster".equals(resinArg)) {
                this._clusterId = argv[i + 1];
                ++i;
                continue;
            }
            if ("--data-directory".equals(resinArg)) {
                this._dataDirectory = Vfs.lookup(argv[i + 1]);
                argv[i + 1] = this._dataDirectory.getFullPath();
                ++i;
                continue;
            }
            if ("--log-directory".equals(resinArg)) {
                this._logDirectory = this._rootDirectory.lookup(argv[i + 1]);
                ++i;
                continue;
            }
            if ("--license-directory".equals(resinArg)) {
                this._licenseDirectory = this._rootDirectory.lookup(argv[i + 1]);
                ++i;
                continue;
            }
            if ("--resin-home".equals(resinArg)) {
                this.setResinHome(Vfs.lookup(argv[i + 1]));
                argv[i + 1] = this._resinHome.getFullPath();
                ++i;
                continue;
            }
            if ("--root-directory".equals(resinArg) || "--server-root".equals(resinArg) || "--resin-root".equals(resinArg)) {
                this.setRootDirectory(Vfs.lookup(argv[i + 1]));
                argv[i + 1] = this._rootDirectory.getFullPath();
                ++i;
                continue;
            }
            if ("--server".equals(resinArg)) {
                this._serverId = argv[i + 1];
                if ("".equals(this._serverId)) {
                    this._serverId = "default";
                }
                ++i;
                continue;
            }
            if ("--stage".equals(resinArg)) {
                ++i;
                continue;
            }
            if ("--preview".equals(resinArg)) continue;
            if ("--watchdog-port".equals(resinArg)) {
                this._watchdogPort = Integer.parseInt(argv[i + 1]);
                ++i;
                continue;
            }
            if (arg.startsWith("-J") || arg.startsWith("-D") || arg.startsWith("-X")) {
                if (!arg.equals("-J-d64")) continue;
                this._is64bit = true;
                continue;
            }
            if (arg.equals("-d64")) {
                this._is64bit = true;
                continue;
            }
            if (arg.equals("-d32")) {
                this._is64bit = false;
                continue;
            }
            if ("--debug-port".equals(resinArg)) {
                ++i;
                continue;
            }
            if ("--jmx-port".equals(resinArg)) {
                ++i;
                continue;
            }
            if ("--dump-heap-on-exit".equals(resinArg)) continue;
            if ("--verbose".equals(resinArg)) {
                this._isVerbose = true;
                Logger.getLogger("").setLevel(Level.CONFIG);
                continue;
            }
            if ("help".equals(resinArg) || "--help".equals(resinArg)) {
                this._isHelp = true;
                continue;
            }
            if ("version".equals(resinArg)) {
                System.out.println(VersionFactory.getFullVersion());
                System.exit(0);
                continue;
            }
            if (_commandMap.get(arg) != null) {
                this._command = _commandMap.get(arg);
                continue;
            }
            if (this._command != null) {
                if (this._command.isFlag(arg)) continue;
                if (this._command.isValueOption(arg)) {
                    ++i;
                    continue;
                }
                this._tailArgs.add(arg);
                continue;
            }
            if (!this._isHelp) continue;
        }
        if (this._isHelp && this._command == null) {
            WatchdogArgs.usage();
            System.exit(1);
        } else if (this._isHelp && this._command != null) {
            this._command.usage(this.isVerbose());
            System.exit(0);
        } else if (this._command == null) {
            System.out.println(WatchdogArgs.L().l("Resin requires a command:{0}", (Object)WatchdogArgs.getCommandList()));
            System.exit(1);
        } else if (!this._isHelp) {
            try {
                this.validateArgs(argv);
            }
            catch (BootArgumentException e) {
                if (this._command != null) {
                    System.err.println(this._command.getName() + ": " + e.getMessage());
                } else {
                    System.err.println("unknown: " + e.getMessage());
                }
                System.err.println();
                this._command.usage(this.isVerbose());
                System.exit(14);
            }
        }
        List<String> defaultArgs = this.parseDefaultArgs();
        this._defaultArgs = defaultArgs.toArray(new String[defaultArgs.size()]);
        if (resinConf != null) {
            this._resinConf = Vfs.getPwd().lookup(resinConf);
            if (!this._resinConf.exists() && this._rootDirectory != null) {
                this._resinConf = this._rootDirectory.lookup(resinConf);
            }
            if (!this._resinConf.exists() && this._resinHome != null) {
                this._resinConf = this._resinHome.lookup(resinConf);
            }
            if (!this._resinConf.exists()) {
                throw new ConfigException(WatchdogArgs.L().l("Resin/{0} can't find configuration file '{1}'", (Object)VersionFactory.getVersion(), (Object)this._resinConf.getNativePath()));
            }
        }
    }

    private List<String> parseDefaultArgs() {
        String arg;
        LinkedList<String> defaultArgs = new LinkedList<String>();
        for (int i = this._tailArgs.size() - 1; i >= 0 && !this._command.isFlag(arg = this._tailArgs.get(i)); --i) {
            String xarg = null;
            if (i > 0) {
                xarg = this._tailArgs.get(i - 1);
            }
            if (xarg != null && (this._command.isValueOption(xarg) || this._command.isIntValueOption(xarg))) break;
            defaultArgs.addFirst(arg);
        }
        return defaultArgs;
    }

    private boolean matchName(BootCommand command, String name) {
        Set<Map.Entry<String, BootCommand>> entries = _commandMap.entrySet();
        for (Map.Entry<String, BootCommand> entry : entries) {
            if (!command.getClass().equals(entry.getValue().getClass()) || !name.equals(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private void validateArgs(String[] argv) throws BootArgumentException {
        boolean defaultArgEncountered = false;
        for (int i = 0; i < argv.length; ++i) {
            String value;
            String arg = argv[i];
            if (this.matchName(this._command, arg)) continue;
            if (arg.charAt(0) != '-' && this._command.isDefaultArgsAccepted()) {
                defaultArgEncountered = true;
                continue;
            }
            if (defaultArgEncountered && arg.charAt(0) == '-') {
                throw new BootArgumentException(L.l("Only default arguments are expected at '{0}'", (Object)arg));
            }
            if (arg.startsWith("-J") || arg.startsWith("-D") || arg.startsWith("-X") || arg.equals("-d64") || arg.equals("-d32") || this._command.isFlag(arg)) continue;
            if (!this._command.isValueOption(arg) && !this._command.isIntValueOption(arg)) {
                throw new BootArgumentException(L.l("unknown argument '{0}'", (Object)arg));
            }
            if (i + 1 == argv.length) {
                throw new BootArgumentException(L.l("option '{0}' requires a value", (Object)arg));
            }
            if (this._command.isFlag(value = argv[++i]) || this._command.isValueOption(value) || this._command.isIntValueOption(value)) {
                throw new BootArgumentException(L.l("option '{0}' requires a value", (Object)arg));
            }
            if (!this._command.isIntValueOption(arg)) continue;
            try {
                Long.parseLong(value);
                continue;
            }
            catch (NumberFormatException e) {
                throw new BootArgumentException(L.l("'{0}' argument must be a number: `{1}'", (Object)arg, (Object)value));
            }
        }
    }

    private static void usage() {
        System.err.println(WatchdogArgs.L().l("usage: bin/resin.sh [-options] <command> [values]"));
        System.err.println(WatchdogArgs.L().l("       bin/resin.sh help <command>"));
        System.err.println(WatchdogArgs.L().l(""));
        System.err.println(WatchdogArgs.L().l("where command is one of:"));
        System.err.println(WatchdogArgs.getCommandList());
    }

    private static String getCommandList() {
        StringBuilder sb = new StringBuilder();
        ArrayList<BootCommand> commands = new ArrayList<BootCommand>();
        commands.addAll(_commandMap.values());
        Collections.sort(commands, new CommandNameComparator());
        Object lastCommand = null;
        for (BootCommand command : commands) {
            if (lastCommand != null && lastCommand.getClass() == command.getClass()) continue;
            sb.append("\n  ");
            sb.append(command.getName());
            sb.append(" - ");
            sb.append(command.getDescription());
            if (command.isProOnly()) {
                sb.append(" (Resin-Pro)");
            }
            lastCommand = command;
        }
        sb.append("\n  help <command> - prints command usage message");
        sb.append("\n  version - prints version");
        return sb.toString();
    }

    private String[] fillArgv(String[] argv) {
        int i;
        ArrayList<String> args = new ArrayList<String>();
        Environment.init();
        String[] jvmArgs = this.getJvmArgs();
        if (jvmArgs != null) {
            for (i = 0; i < jvmArgs.length; ++i) {
                String arg = jvmArgs[i];
                if (args.contains(arg) || arg.startsWith("-Djava.class.path=") || !arg.startsWith("-D")) continue;
                int eqlSignIdx = arg.indexOf(61);
                if (eqlSignIdx == -1) {
                    args.add("-J" + arg);
                    continue;
                }
                String key = arg.substring(2, eqlSignIdx);
                String value = System.getProperty(key);
                if (value == null) {
                    value = "";
                }
                args.add("-J-D" + key + "=" + value);
            }
        }
        for (i = 0; i < argv.length; ++i) {
            args.add(argv[i]);
        }
        argv = new String[args.size()];
        args.toArray(argv);
        return argv;
    }

    private String[] getJvmArgs() {
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("java.lang:type=Runtime");
            return (String[])mbeanServer.getAttribute(name, "InputArguments");
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    private static L10N L() {
        if (L == null) {
            L = new L10N(WatchdogArgs.class);
        }
        return L;
    }

    static Path calculateResinHome() {
        String resinHome = System.getProperty("resin.home");
        if (resinHome != null) {
            return Vfs.lookup(resinHome);
        }
        String classPath = System.getProperty("java.class.path");
        if (classPath.indexOf("resin.jar") >= 0) {
            int q = classPath.indexOf("resin.jar") + "resin.jar".length();
            int p = classPath.lastIndexOf(File.pathSeparatorChar, q - 1);
            String resinJar = p >= 0 ? classPath.substring(p + 1, q) : classPath.substring(0, q);
            return Vfs.lookup(resinJar).lookup("../..");
        }
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        URL url = loader.getResource("com/caucho/boot/ResinBoot.class");
        String path = url.toString();
        if (!path.startsWith("jar:")) {
            throw new RuntimeException(WatchdogArgs.L().l("Resin/{0}: can't find jar for ResinBoot in {1}", (Object)VersionFactory.getVersion(), (Object)path));
        }
        int p = path.indexOf(58);
        int q = path.indexOf(33);
        path = path.substring(p + 1, q);
        Path pwd = Vfs.lookup(path).getParent().getParent();
        return pwd;
    }

    static Path calculateResinRoot(Path resinHome) {
        String resinRoot = System.getProperty("resin.root");
        if (resinRoot != null) {
            return Vfs.lookup(resinRoot);
        }
        resinRoot = System.getProperty("server.root");
        if (resinRoot != null) {
            return Vfs.lookup(resinRoot);
        }
        return resinHome;
    }

    static String calculateClassPath(Path resinHome) throws IOException {
        ArrayList<String> classPath = new ArrayList<String>();
        return WatchdogArgs.calculateClassPath(classPath, resinHome);
    }

    static String calculateClassPath(ArrayList<String> classPath, Path resinHome) throws IOException {
        Path resinLib;
        Path javaHome;
        String oldClassPath = System.getProperty("java.class.path");
        if (oldClassPath != null) {
            for (String item : oldClassPath.split("[" + File.pathSeparatorChar + "]")) {
                WatchdogArgs.addClassPath(classPath, item);
            }
        }
        if ((oldClassPath = System.getenv("CLASSPATH")) != null) {
            for (String item : oldClassPath.split("[" + File.pathSeparatorChar + "]")) {
                WatchdogArgs.addClassPath(classPath, item);
            }
        }
        if ((javaHome = Vfs.lookup(System.getProperty("java.home"))).lookup("lib/tools.jar").canRead()) {
            WatchdogArgs.addClassPath(classPath, javaHome.lookup("lib/tools.jar").getNativePath());
        } else if (javaHome.getTail().startsWith("jre")) {
            String tail = javaHome.getTail();
            tail = "jdk" + tail.substring(3);
            Path jdkHome = javaHome.getParent().lookup(tail);
            if (jdkHome.lookup("lib/tools.jar").canRead()) {
                WatchdogArgs.addClassPath(classPath, jdkHome.lookup("lib/tools.jar").getNativePath());
            }
        }
        if (javaHome.lookup("../lib/tools.jar").canRead()) {
            WatchdogArgs.addClassPath(classPath, javaHome.lookup("../lib/tools.jar").getNativePath());
        }
        if ((resinLib = resinHome.lookup("lib")).lookup("pro.jar").canRead()) {
            WatchdogArgs.addClassPath(classPath, resinLib.lookup("pro.jar").getNativePath());
        }
        WatchdogArgs.addClassPath(classPath, resinLib.lookup("resin.jar").getNativePath());
        String[] list = resinLib.list();
        for (int i = 0; i < list.length; ++i) {
            Path item;
            String pathName;
            if (!list[i].endsWith(".jar") || classPath.contains(pathName = (item = resinLib.lookup(list[i])).getNativePath())) continue;
            WatchdogArgs.addClassPath(classPath, pathName);
        }
        String cp = "";
        for (int i = 0; i < classPath.size(); ++i) {
            if (!"".equals(cp)) {
                cp = cp + File.pathSeparatorChar;
            }
            cp = cp + classPath.get(i);
        }
        return cp;
    }

    private static void addClassPath(ArrayList<String> cp, String item) {
        if (!cp.contains(item)) {
            cp.add(item);
        }
    }

    private static void addCommand(BootCommand command) {
        _commandMap.put(command.getName(), command);
    }

    static {
        WatchdogArgs.addCommand(new ConfigUndeployCommand());
        WatchdogArgs.addCommand(new ConsoleCommand());
        WatchdogArgs.addCommand(new DeployCatCommand());
        WatchdogArgs.addCommand(new DeployCopyCommand());
        WatchdogArgs.addCommand(new DeployCommand());
        WatchdogArgs.addCommand(new DeployListCommand());
        WatchdogArgs.addCommand(new DeployLsCommand());
        WatchdogArgs.addCommand(new DisableCommand());
        WatchdogArgs.addCommand(new DisableSoftCommand());
        WatchdogArgs.addCommand(new EnableCommand());
        WatchdogArgs.addCommand(new GuiCommand());
        WatchdogArgs.addCommand(new HeapDumpCommand());
        WatchdogArgs.addCommand(new JmxCallCommand());
        WatchdogArgs.addCommand(new JmxDumpCommand());
        WatchdogArgs.addCommand(new JmxListCommand());
        WatchdogArgs.addCommand(new JmxSetCommand());
        WatchdogArgs.addCommand(new JspcCommand());
        WatchdogArgs.addCommand(new KillCommand());
        WatchdogArgs.addCommand(new LicenseAddCommand());
        WatchdogArgs.addCommand(new ListRestartsCommand());
        WatchdogArgs.addCommand(new LogLevelCommand());
        WatchdogArgs.addCommand(new PasswordEncryptCommand());
        WatchdogArgs.addCommand(new PasswordGenerateCommand());
        WatchdogArgs.addCommand(new PdfReportCommand());
        WatchdogArgs.addCommand(new ProfileCommand());
        WatchdogArgs.addCommand(new RestartCommand());
        WatchdogArgs.addCommand(new ScoreboardCommand());
        WatchdogArgs.addCommand(new ShutdownCommand());
        WatchdogArgs.addCommand(new StartCommand());
        WatchdogArgs.addCommand(new StartAllCommand());
        WatchdogArgs.addCommand(new StartWithForegroundCommand());
        WatchdogArgs.addCommand(new StatusCommand());
        WatchdogArgs.addCommand(new StopCommand());
        WatchdogArgs.addCommand(new ThreadDumpCommand());
        WatchdogArgs.addCommand(new UndeployCommand());
        WatchdogArgs.addCommand(new WatchdogCommand());
        WatchdogArgs.addCommand(new WebAppDeployCommand());
        WatchdogArgs.addCommand(new WebAppRestartCommand());
        WatchdogArgs.addCommand(new WebAppRestartClusterCommand());
        WatchdogArgs.addCommand(new WebAppStartCommand());
        WatchdogArgs.addCommand(new WebAppStopCommand());
        WatchdogArgs.addCommand(new WebAppUndeployCommand());
        _commandMap.put("copy", new DeployCopyCommand());
        _commandMap.put("list", new DeployListCommand());
        _commandMap.put("deploy-start", new WebAppStartCommand());
        _commandMap.put("deploy-stop", new WebAppStopCommand());
        _commandMap.put("deploy-restart", new WebAppRestartCommand());
        _commandMap.put("deploy-restart-cluster", new WebAppRestartClusterCommand());
        _commandMap.put("generate-password", new PasswordGenerateCommand());
        _commandMap.put("start-webapp", new WebAppStartCommand());
        _commandMap.put("stop-webapp", new WebAppStopCommand());
        _commandMap.put("restart-webapp", new WebAppRestartCommand());
    }

    static class CommandNameComparator
    implements Comparator<BootCommand> {
        CommandNameComparator() {
        }

        @Override
        public int compare(BootCommand a, BootCommand b) {
            return a.getName().compareTo(b.getName());
        }
    }

    public class ResinBootELContext
    extends ResinELContext {
        private final AtomicBoolean _isLicenseCheck = new AtomicBoolean();
        private boolean _isResinProfessional;

        @Override
        public Path getResinHome() {
            return WatchdogArgs.this.getResinHome();
        }

        @Override
        public Path getRootDirectory() {
            return WatchdogArgs.this.getRootDirectory();
        }

        @Override
        public Path getLogDirectory() {
            return WatchdogArgs.this.getLogDirectory();
        }

        @Override
        public Path getResinConf() {
            return WatchdogArgs.this.getResinConf();
        }

        @Override
        public String getServerId() {
            String serverId = (String)Config.getProperty("rvar0");
            if (serverId != null) {
                return serverId;
            }
            return WatchdogArgs.this.getServerId();
        }

        @Override
        public boolean isResinProfessional() {
            return this.isProfessional();
        }

        public boolean isProfessional() {
            this.loadLicenses();
            return this._isResinProfessional;
        }

        private void loadLicenses() {
            if (this._isLicenseCheck.getAndSet(true)) {
                return;
            }
            try {
                Path path;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName("com.caucho.license.LicenseCheckImpl", false, loader);
                Constructor<?> ctor = cl.getConstructor(File[].class);
                ArrayList<File> licensePath = new ArrayList<File>();
                if (WatchdogArgs.this._licenseDirectory != null) {
                    licensePath.add(new File(WatchdogArgs.this._licenseDirectory.getNativePath()));
                }
                if ((path = this.getResinConf().getParent().lookup("licenses")).isDirectory()) {
                    File dir = new File(path.getNativePath());
                    licensePath.add(dir);
                }
                File[] files = new File[licensePath.size()];
                licensePath.toArray(files);
                LicenseCheck license = (LicenseCheck)ctor.newInstance(new Object[]{files});
                license.requireProfessional(1);
                Vfs.initJNI();
                this._isResinProfessional = true;
            }
            catch (Exception e) {
                log.finer(e.toString());
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }
}

