/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.hmtp;

import com.caucho.bam.broker.Broker;
import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.broker.PassthroughBroker;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.cloud.bam.BamSystem;
import com.caucho.cloud.hmtp.HmtpLinkActor;
import com.caucho.hemp.servlet.ClientStubManager;
import com.caucho.hemp.servlet.ServerGatewayBroker;
import com.caucho.hemp.servlet.ServerProxyBroker;
import com.caucho.hmtp.HmtpWebSocketReader;
import com.caucho.hmtp.HmtpWebSocketWriter;
import com.caucho.network.listen.AbstractProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Logger;

public class HmtpRequest
extends AbstractProtocolConnection {
    private static final Logger log = Logger.getLogger(HmtpRequest.class.getName());
    private static final L10N L = new L10N(HmtpRequest.class);
    public static final int HMUX_TO_UNIDIR_HMTP = 55;
    public static final int HMUX_SWITCH_TO_HMTP = 56;
    public static final int HMUX_HMTP_OK = 57;
    private SocketLink _conn;
    private BamSystem _bamService;
    private ReadStream _rawRead;
    private WriteStream _rawWrite;
    private boolean _isFirst;
    private HmtpWebSocketReader _hmtpReader;
    private HmtpWebSocketWriter _hmtpWriter;
    private ClientStubManager _clientManager;
    private Broker _toLinkBroker;
    private Broker _proxyBroker;
    private HmtpLinkActor _linkActor;

    public HmtpRequest(SocketLink conn, BamSystem bamService) {
        this._conn = conn;
        this._bamService = bamService;
        if (conn == null) {
            throw new NullPointerException();
        }
        if (bamService == null) {
            throw new NullPointerException();
        }
        this._rawRead = conn.getReadStream();
        this._rawWrite = conn.getWriteStream();
    }

    @Override
    public boolean isWaitForRead() {
        return true;
    }

    @Override
    public void onStartConnection() {
        this._isFirst = true;
    }

    @Override
    public boolean handleRequest() throws IOException {
        try {
            if (this._isFirst) {
                return this.handleInitialRequest();
            }
            return this.dispatchHmtp();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private boolean handleInitialRequest() throws IOException {
        this._isFirst = false;
        ReadStream is = this._rawRead;
        int ch = is.read();
        if (ch < 0) {
            return false;
        }
        boolean isUnidir = false;
        if (ch == 55) {
            isUnidir = true;
        } else if (ch == 56) {
            isUnidir = false;
        } else {
            throw new UnsupportedOperationException(L.l("0x{0} is an invalid HMUX code.", (Object)Integer.toHexString(ch)));
        }
        int len = (is.read() << 8) + is.read();
        int adminCode = is.read();
        boolean isAdmin = adminCode != 0;
        ReadStream rawIs = is;
        is.skip(len - 1);
        this._hmtpReader = new HmtpWebSocketReader(rawIs);
        this._hmtpWriter = new HmtpWebSocketWriter(this._rawWrite);
        ManagedBroker broker = this._bamService.getBroker();
        this._hmtpWriter.setAddress("hmtp-server-" + this._conn.getId() + "-hmtp");
        MultiworkerMailbox toLinkMailbox = new MultiworkerMailbox(this._hmtpWriter.getAddress(), this._hmtpWriter, broker, 1);
        this._toLinkBroker = new PassthroughBroker(toLinkMailbox);
        this._clientManager = new ClientStubManager(broker, toLinkMailbox);
        this._linkActor = new HmtpLinkActor(this._toLinkBroker, this._clientManager, this._bamService.getLinkManager(), this._conn.getRemoteHost());
        this._proxyBroker = isUnidir ? new ServerGatewayBroker(broker, this._clientManager, this._linkActor.getActor()) : new ServerProxyBroker(broker, this._clientManager, this._linkActor.getActor());
        return this.dispatchHmtp();
    }

    private boolean dispatchHmtp() throws IOException {
        HmtpWebSocketReader in = this._hmtpReader;
        do {
            Broker broker;
            if (!in.readPacket(broker = this._proxyBroker)) {
                return false;
            }
            this._bamService.addExternalMessageRead();
        } while (in.isDataAvailable());
        return true;
    }

    @Override
    public void onCloseConnection() {
        HmtpWebSocketWriter writer;
        HmtpLinkActor linkActor = this._linkActor;
        this._linkActor = null;
        Broker linkBroker = this._toLinkBroker;
        this._toLinkBroker = null;
        if (linkBroker != null) {
            linkBroker.close();
        }
        if (linkActor != null) {
            linkActor.onCloseConnection();
        }
        if ((writer = this._hmtpWriter) != null) {
            writer.close();
        }
    }

    protected String getRequestId() {
        return "hmtp:" + this._conn.getId();
    }

    public final String dbgId() {
        return "Hmtp[" + this._conn.getId() + "] ";
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.dbgId();
    }
}

