/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.cloud.network.ClusterServerAdmin;
import com.caucho.cloud.network.NetworkAddressResult;
import com.caucho.cloud.network.NetworkClusterSystem;
import com.caucho.cloud.network.ServerHeartbeatState;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.TriadOwner;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Period;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.network.balance.ClientSocketFactory;
import com.caucho.network.listen.AbstractProtocol;
import com.caucho.network.listen.TcpPort;
import com.caucho.server.cluster.ProtocolPort;
import com.caucho.server.cluster.ProtocolPortConfig;
import com.caucho.server.http.HttpProtocol;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClusterServer {
    private static final L10N L = new L10N(ClusterServer.class);
    private static final Logger log = Logger.getLogger(ClusterServer.class.getName());
    private static final int[] DECODE = new int[128];
    private final NetworkClusterSystem _clusterSystem;
    private final CloudServer _cloudServer;
    private String _serverClusterId;
    private String _serverDomainId;
    private String _bamAddress;
    private boolean _isRemotePod;
    private int _loadBalanceConnectionMin = 0;
    private long _loadBalanceIdleTime = 60000L;
    private long _loadBalanceBusyRecoverTime = 15000L;
    private long _loadBalanceRecoverTime = 15000L;
    private long _loadBalanceSocketTimeout = 600000L;
    private long _loadBalanceWarmupTime = 60000L;
    private long _loadBalanceConnectTimeout = 5000L;
    private int _loadBalanceWeight = 100;
    private boolean _isBackup;
    private long _clusterIdleTime = 180000L;
    private long _clusterSocketTimeout = 600000L;
    private ConfigProgram _portDefaults = new ContainerProgram();
    private ContainerProgram _serverProgram = new ContainerProgram();
    private String _stage;
    private ArrayList<String> _pingUrls = new ArrayList();
    private ArrayList<TcpPort> _listeners = new ArrayList();
    private String _address;
    private int _port;
    private AtomicReference<SocketPool> _clusterSocketPool = new AtomicReference();
    private AtomicReference<SocketPool> _loadBalanceSocketPool = new AtomicReference();
    private final ServerHeartbeatState _heartbeatState;
    private ClusterServerAdmin _admin = new ClusterServerAdmin(this);

    ClusterServer(NetworkClusterSystem networkService, CloudServer cloudServer) {
        this._clusterSystem = networkService;
        if (networkService == null) {
            throw new NullPointerException();
        }
        this._cloudServer = cloudServer;
        cloudServer.getIndex();
        if (this._clusterSystem == null) {
            throw new NullPointerException();
        }
        if (cloudServer.getPod() != networkService.getSelfServer().getPod()) {
            this._isRemotePod = true;
        }
        this._heartbeatState = new ServerHeartbeatState(this);
        this._serverClusterId = ClusterServer.getServerAddress(this.getIndex(), this.getCloudPod().getIndex());
        String clusterId = cloudServer.getCluster().getId();
        if (clusterId.equals("")) {
            clusterId = "default";
        }
        this._serverDomainId = this._serverClusterId + "." + clusterId.replace('.', '_');
        this._bamAddress = ClusterServer.getBamAdminName(cloudServer);
        this._port = cloudServer.getPort();
        this._address = !this.isExternal() ? cloudServer.getAddress() : (cloudServer.isSelf() ? this.lookupLocalAddress() : "127.0.0.2");
    }

    public static CloudServer getSelfServer() {
        NetworkClusterSystem system = NetworkClusterSystem.getCurrent();
        if (system == null) {
            throw new IllegalStateException();
        }
        return system.getSelfServer();
    }

    public static String getBamAdminName(CloudServer server) {
        String serverClusterId = ClusterServer.getServerAddress(server.getIndex(), server.getPod().getIndex());
        String clusterId = server.getCluster().getId();
        if (clusterId.equals("")) {
            clusterId = "default";
        }
        String serverDomainId = serverClusterId + "." + clusterId.replace('.', '_');
        return serverDomainId + ".admin.resin";
    }

    public static ClusterServer getCurrent() {
        CloudServer cloudServer = NetworkClusterSystem.getCurrentSelfServer();
        return cloudServer.getData(ClusterServer.class);
    }

    public String getId() {
        return this._cloudServer.getId();
    }

    public String getDebugId() {
        if ("".equals(this.getId())) {
            return "default";
        }
        return this.getId();
    }

    public CloudServer getCloudServer() {
        return this._cloudServer;
    }

    public String getServerClusterId() {
        return this._serverClusterId;
    }

    public String getServerDomainId() {
        return this._serverDomainId;
    }

    public String getBamAdminName() {
        return this._bamAddress;
    }

    public CloudCluster getCluster() {
        return this._cloudServer.getCluster();
    }

    public CloudPod getCloudPod() {
        return this._cloudServer.getPod();
    }

    public boolean isTriad() {
        return this._cloudServer.isTriad();
    }

    public TriadOwner getTriadOwner() {
        return TriadOwner.getOwner(this.getIndex());
    }

    public int getIndex() {
        return this._cloudServer.getIndex();
    }

    public String getAddress() {
        return this._address;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    private boolean isExternal() {
        return this._cloudServer.isExternal();
    }

    public boolean isSSL() {
        return this._cloudServer.isSSL();
    }

    public void setBackup(boolean isBackup) {
        this._isBackup = isBackup;
        if (isBackup) {
            this.setLoadBalanceWeight(1);
        }
    }

    public boolean isBackup() {
        return this._isBackup;
    }

    public boolean isDynamic() {
        return !this._cloudServer.isStatic();
    }

    public void setLoadBalanceConnectTimeout(Period period) {
        this._loadBalanceConnectTimeout = period.getPeriod();
    }

    public long getLoadBalanceConnectTimeout() {
        return this._loadBalanceConnectTimeout;
    }

    @Configurable
    public void setLoadBalanceConnectionMin(int min) {
        this._loadBalanceConnectionMin = min;
    }

    public int getLoadBalanceConnectionMin() {
        return this._loadBalanceConnectionMin;
    }

    public void setLoadBalanceSocketTimeout(Period period) {
        this._loadBalanceSocketTimeout = period.getPeriod();
    }

    public long getLoadBalanceSocketTimeout() {
        return this._loadBalanceSocketTimeout;
    }

    public void setLoadBalanceIdleTime(Period period) {
        this._loadBalanceIdleTime = period.getPeriod();
    }

    public long getLoadBalanceIdleTime() {
        return this._loadBalanceIdleTime;
    }

    public void setLoadBalanceRecoverTime(Period period) {
        this._loadBalanceRecoverTime = period.getPeriod();
    }

    public long getLoadBalanceRecoverTime() {
        return this._loadBalanceRecoverTime;
    }

    public void setLoadBalanceBusyRecoverTime(Period period) {
        this._loadBalanceBusyRecoverTime = period.getPeriod();
    }

    public long getLoadBalanceBusyRecoverTime() {
        return this._loadBalanceBusyRecoverTime;
    }

    public long getClusterIdleTime() {
        return this._clusterIdleTime;
    }

    @Configurable
    public void setClusterSocketTimeout(Period period) {
        this._clusterSocketTimeout = period.getPeriod();
    }

    public long getClusterSocketTimeout() {
        return this._clusterSocketTimeout;
    }

    @Configurable
    public TcpPort createHttp() throws ConfigException {
        TcpPort listener = new TcpPort();
        this.applyPortDefaults(listener);
        HttpProtocol protocol = new HttpProtocol();
        listener.setProtocol(protocol);
        return listener;
    }

    public void addHttp(TcpPort listener) {
        if (listener.getPort() <= 0) {
            log.fine(listener + " skipping because port is 0.");
            return;
        }
        this._listeners.add(listener);
    }

    @Configurable
    public TcpPort createProtocol() {
        ProtocolPortConfig port = new ProtocolPortConfig();
        this._listeners.add(port);
        return port;
    }

    @Configurable
    public TcpPort createListen() {
        ProtocolPortConfig listener = new ProtocolPortConfig();
        return listener;
    }

    public void addListen(TcpPort listener) {
        if (listener.getPort() <= 0) {
            log.fine(listener + " skipping because port is 0.");
            return;
        }
        this._listeners.add(listener);
    }

    @Configurable
    public void add(ProtocolPort protocolPort) {
        TcpPort listener = new TcpPort();
        AbstractProtocol protocol = protocolPort.getProtocol();
        listener.setProtocol(protocol);
        this.applyPortDefaults(listener);
        protocolPort.getConfigProgram().configure(listener);
        this._listeners.add(listener);
    }

    public ArrayList<TcpPort> getListeners() {
        return this._listeners;
    }

    @Configurable
    public void addPortDefault(ContainerProgram program) {
        this.addListenDefault(program);
    }

    @Configurable
    public void addListenDefault(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    private void applyPortDefaults(TcpPort port) {
        this._portDefaults.configure(port);
    }

    public void setAcceptListenBacklog(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setAcceptThreadMin(ConfigProgram program) throws ConfigException {
        this._portDefaults.addProgram(program);
    }

    public void setAcceptThreadMax(ConfigProgram program) throws ConfigException {
        this._portDefaults.addProgram(program);
    }

    public void setConnectionMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveTimeout(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveConnectionTimeMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveSelectEnable(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveSelectMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setKeepaliveSelectThreadTimeout(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setSocketTimeout(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setSuspendTimeMax(ConfigProgram program) {
        this._portDefaults.addProgram(program);
    }

    public void setStage(String stage) {
        this._stage = stage;
    }

    public String getStage() {
        return this._stage;
    }

    public void addPingUrl(String url) {
        this._pingUrls.add(url);
    }

    public ArrayList<String> getPingUrlList() {
        return this._pingUrls;
    }

    public void setLoadBalanceWarmupTime(Period period) {
        this._loadBalanceWarmupTime = period.getPeriod();
    }

    public long getLoadBalanceWarmupTime() {
        return this._loadBalanceWarmupTime;
    }

    public void setLoadBalanceWeight(int weight) {
        this._loadBalanceWeight = weight;
    }

    public int getLoadBalanceWeight() {
        return this._loadBalanceWeight;
    }

    public String getIp() {
        return this.getCloudServer().getIpAddress();
    }

    public boolean isSelf() {
        return this.getCloudServer().isSelf();
    }

    public boolean isRemote() {
        return !this.isSelf();
    }

    private String lookupLocalAddress() {
        String address;
        long timeout = 120000L;
        long expireTime = CurrentTime.getCurrentTime() + timeout;
        while ((address = this.allocateLocalAddress()) == null && CurrentTime.getCurrentTime() < expireTime) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (address == null) {
            throw new ConfigException(L.l("Cannot find an internal local IP address for server {0}, external IP {1} within 120s. 'external-address=true' is used for cloud networks where the internal address is allocated dynamically. Check that the persistent address has been assigned in the cloud configuration or DNS.", (Object)this._cloudServer.getId(), (Object)this._cloudServer.getAddress()));
        }
        return address;
    }

    private String allocateLocalAddress() {
        ArrayList<String> addressNames = new ArrayList<String>();
        for (InetAddress addr : NetworkClusterSystem.getLocalAddresses()) {
            String localAddress = this.getLocalAddress(addr);
            if (localAddress == null) continue;
            addressNames.add(localAddress);
        }
        Collections.sort(addressNames);
        String address = null;
        if (addressNames.size() > 0) {
            address = (String)addressNames.get(0);
        }
        return address;
    }

    private String getLocalAddress(InetAddress addr) {
        String address = addr.getHostAddress();
        byte[] bytes = addr.getAddress();
        if (address.equals(this._cloudServer.getAddress())) {
            return null;
        }
        if (bytes[0] == 127) {
            return null;
        }
        if (this.isLocal(bytes)) {
            return address;
        }
        return null;
    }

    private boolean isLocal(byte[] bytes) {
        if (bytes.length != 4) {
            return false;
        }
        if (bytes[0] == 10) {
            return true;
        }
        if ((bytes[0] & 0xFF) == 192 && (bytes[1] & 0xFF) == 168) {
            return true;
        }
        return (bytes[0] & 0xFF) == 172 && (bytes[1] & 0xF0) == 16;
    }

    public final ClientSocketFactory getClusterSocketPool() {
        return this.getClusterSocketFactory();
    }

    public final ClientSocketFactory getLoadBalanceSocketPool() {
        ClientSocketFactory factory = this.getLoadBalanceSocketFactory();
        if (factory == null) {
            return null;
        }
        if (this._cloudServer.getState().isDisableSoft()) {
            factory.enableSessionOnly();
        } else if (this._cloudServer.getState().isDisabled()) {
            factory.disable();
        } else {
            factory.enable();
        }
        return factory;
    }

    private ClientSocketFactory getClusterSocketFactory() {
        SocketPool socketPool = this._clusterSocketPool.get();
        if (socketPool != null) {
            return socketPool.getFactory();
        }
        if (!this.isExternal()) {
            return null;
        }
        NetworkAddressResult result = this._clusterSystem.getLocalSocketAddress(this);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " getLocalSocketAddress -> " + result);
        }
        if (result == null) {
            return null;
        }
        ClientSocketFactory factory = this.createClusterPool(this._clusterSystem.getServerId(), result.getAddress(), result.getPort());
        factory.init();
        factory.start();
        socketPool = new SocketPool(factory);
        if (!this._clusterSocketPool.compareAndSet(null, socketPool)) {
            factory.stop();
            socketPool = this._clusterSocketPool.get();
        }
        if (socketPool != null) {
            return socketPool.getFactory();
        }
        return null;
    }

    private ClientSocketFactory getLoadBalanceSocketFactory() {
        SocketPool socketPool = this._loadBalanceSocketPool.get();
        if (socketPool != null) {
            return socketPool.getFactory();
        }
        if (!this.isExternal()) {
            return null;
        }
        return null;
    }

    public final boolean isActiveRemote() {
        ClientSocketFactory pool = this.getClusterSocketPool();
        return pool != null && pool.isActive();
    }

    @Configurable
    public void addContentProgram(ConfigProgram program) {
        this._serverProgram.addProgram(program);
    }

    public ConfigProgram getServerProgram() {
        return this._serverProgram;
    }

    public ConfigProgram getPortDefaults() {
        return this._portDefaults;
    }

    public void init() {
        if (!this.isSelf() && this.getCloudServer().getPort() >= 0 && !this.isExternal()) {
            ClientSocketFactory clusterFactory = this.createClusterPool(this._clusterSystem.getServerId(), this.getAddress(), this.getPort());
            clusterFactory.init();
            this._clusterSocketPool.set(new SocketPool(clusterFactory));
            ClientSocketFactory loadBalanceFactory = this.createLoadBalancePool(this._clusterSystem.getServerId());
            loadBalanceFactory.init();
            this._loadBalanceSocketPool.set(new SocketPool(loadBalanceFactory));
        }
        this._admin.register();
    }

    private ClientSocketFactory createLoadBalancePool(String serverId) {
        ClientSocketFactory pool = new ClientSocketFactory(serverId, this.getId(), "Resin|LoadBalanceSocket", this.getStatId(), this.getAddress(), this.getPort(), this.isSSL());
        pool.setLoadBalanceConnectTimeout(this.getLoadBalanceConnectTimeout());
        pool.setLoadBalanceConnectionMin(this.getLoadBalanceConnectionMin());
        pool.setLoadBalanceSocketTimeout(this.getLoadBalanceSocketTimeout());
        pool.setLoadBalanceIdleTime(this.getLoadBalanceIdleTime());
        pool.setLoadBalanceRecoverTime(this.getLoadBalanceRecoverTime());
        pool.setLoadBalanceBusyRecoverTime(this.getLoadBalanceBusyRecoverTime());
        pool.setLoadBalanceWarmupTime(this.getLoadBalanceWarmupTime());
        pool.setLoadBalanceWeight(this.getLoadBalanceWeight());
        return pool;
    }

    private ClientSocketFactory createClusterPool(String serverId, String address, int port) {
        if (port <= 0) {
            port = this.getPort();
        }
        ClientSocketFactory pool = new ClientSocketFactory(serverId, this.getId(), "Resin|ClusterSocket", this.getStatId(), address, port, this.isSSL());
        pool.setLoadBalanceSocketTimeout(this.getClusterIdleTime());
        pool.setLoadBalanceIdleTime(this.getClusterIdleTime());
        if (this.getCloudServer().getPod() == this._clusterSystem.getSelfServer().getPod()) {
            pool.setHeartbeatServer(true);
        }
        return pool;
    }

    private String getStatId() {
        String targetCluster = this.getCluster().getId();
        if ("".equals(targetCluster)) {
            targetCluster = "default";
        }
        int index = this.getIndex();
        return String.format("%02x:%s", index, targetCluster);
    }

    public boolean isRemotePod() {
        return this._isRemotePod;
    }

    public boolean isHeartbeatActive() {
        return this._heartbeatState.isHeartbeatActive();
    }

    public long getStateTimestamp() {
        return this._heartbeatState.getStateTimestamp();
    }

    public long getLastHeartbeatTime() {
        return this._heartbeatState.getLastHeartbeatTime();
    }

    public String getHeartbeatState() {
        return this._heartbeatState.getHeartbeatState();
    }

    public boolean notifyHeartbeatStart() {
        if (!this._heartbeatState.notifyHeartbeatStart()) {
            return false;
        }
        this._cloudServer.onHeartbeatStart();
        ClientSocketFactory clusterSocketPool = this.getClusterSocketPool();
        if (clusterSocketPool != null) {
            clusterSocketPool.notifyHeartbeatStart();
        }
        this._clusterSystem.notifyHeartbeatStart(this);
        return true;
    }

    public boolean notifyHeartbeatStop() {
        SocketPool clusterSocketPool = this.isExternal() ? (SocketPool)this._clusterSocketPool.getAndSet(null) : this._clusterSocketPool.get();
        if (clusterSocketPool != null) {
            clusterSocketPool.getFactory().notifyHeartbeatStop();
        }
        if (!this._heartbeatState.notifyHeartbeatStop()) {
            return false;
        }
        if (this._clusterSystem.isActive()) {
            log.warning(this + " notify-heartbeat-stop");
        } else {
            log.fine(this + " notify-heartbeat-stop");
        }
        this._cloudServer.onHeartbeatStop();
        this._clusterSystem.notifyHeartbeatStop(this);
        return true;
    }

    public void updateHeartbeatTimeout(long timeout) {
        this._heartbeatState.updateTimeout(timeout);
    }

    public void onHeartbeatTimeout() {
        if (this._clusterSystem.isActive()) {
            log.warning(this + " notify-heartbeat-timeout (check peer for possible freeze)");
        } else {
            log.fine(this + " notify-heartbeat-timeout (check peer for possible freeze)");
        }
        this._cloudServer.onHeartbeatStop();
        this._clusterSystem.notifyHeartbeatStop(this);
    }

    public void stopServer() {
        this._heartbeatState.notifyHeartbeatStop();
        SocketPool pool = this._clusterSocketPool.get();
        if (pool != null) {
            pool.getFactory().notifyHeartbeatStop();
        }
    }

    public void generateIdPrefix(StringBuilder cb) {
        cb.append(this.getServerClusterId());
    }

    public ClusterServerMXBean getAdmin() {
        return this._admin;
    }

    public void close() {
        SocketPool clusterPool;
        SocketPool loadBalancePool = this._loadBalanceSocketPool.get();
        if (loadBalancePool != null) {
            loadBalancePool.getFactory().close();
        }
        if ((clusterPool = this._clusterSocketPool.get()) != null) {
            clusterPool.getFactory().close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + "," + this.getAddress() + ":" + this.getPort() + "]";
    }

    public static String getServerAddress(int index, int podIndex) {
        StringBuilder sb = new StringBuilder();
        sb.append(ClusterServer.convert(index));
        sb.append(ClusterServer.convert(podIndex));
        sb.append(ClusterServer.convert(podIndex / 64));
        return sb.toString();
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    public static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    static {
        for (int i = 0; i < 64; ++i) {
            ClusterServer.DECODE[ClusterServer.convert((long)((long)i))] = i;
        }
    }

    static class SocketPool {
        private final ClientSocketFactory _factory;

        SocketPool(ClientSocketFactory factory) {
            this._factory = factory;
        }

        ClientSocketFactory getFactory() {
            return this._factory;
        }
    }
}

