/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.bytecode;

import com.caucho.config.inject.InjectManager;
import com.caucho.util.L10N;
import java.io.Serializable;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.PassivationCapable;

public class ScopeProxyHandle
implements Serializable {
    private static final L10N L = new L10N(ScopeProxyHandle.class);
    private String _id;

    public ScopeProxyHandle(InjectManager.ReferenceFactory factory) {
        Bean bean = factory.getBean();
        if (!(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(L.l("serializing bean '{0}' that is not passivating", (Object)bean));
        }
        this._id = ((PassivationCapable)bean).getId();
    }

    private Object readResolve() {
        InjectManager manager = InjectManager.getCurrent();
        Bean<?> bean = manager.getPassivationCapableBean(this._id);
        if (bean == null) {
            throw new IllegalStateException(L.l("No passivation bean exists with hash {0}", (Object)this._id));
        }
        return manager.getReference(bean);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

