/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.event;

import com.caucho.config.event.ObserverMap;
import com.caucho.config.event.ObserverMethodAfterCompletionImpl;
import com.caucho.config.event.ObserverMethodAfterFailureImpl;
import com.caucho.config.event.ObserverMethodAfterSuccessImpl;
import com.caucho.config.event.ObserverMethodBeforeCompletionImpl;
import com.caucho.config.event.ObserverMethodImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.ParamType;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import javax.inject.Qualifier;

@Module
public class EventManager {
    private static final L10N L = new L10N(EventManager.class);
    private static final Logger log = Logger.getLogger(EventManager.class.getName());
    private InjectManager _cdiManager;
    private ConcurrentHashMap<Class<?>, ObserverMap> _extObserverMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<?>, ObserverMap> _observerMap = new ConcurrentHashMap();
    private ConcurrentHashMap<EventKey, Set<ObserverMethod<?>>> _observerMethodCache = new ConcurrentHashMap();

    public EventManager(InjectManager cdiManager) {
        this._cdiManager = cdiManager;
    }

    public <X, Z> void addObserver(Bean<X> bean, AnnotatedMethod<Z> beanMethod) {
        ObserverMethodImpl observerMethod;
        int param = EventManager.findObserverAnnotation(beanMethod);
        if (param < 0) {
            return;
        }
        Method method = beanMethod.getJavaMember();
        Type eventType = method.getGenericParameterTypes()[param];
        HashSet<Annotation> bindingSet = new HashSet<Annotation>();
        List paramList = beanMethod.getParameters();
        for (Annotation ann : ((AnnotatedParameter)paramList.get(param)).getAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(Qualifier.class)) continue;
            bindingSet.add(ann);
        }
        Observes observes = (Observes)((AnnotatedParameter)paramList.get(param)).getAnnotation(Observes.class);
        if (method.isAnnotationPresent(Inject.class)) {
            throw InjectManager.error(method, L.l("A method may not have both an @Observer and an @Inject annotation."));
        }
        if (method.isAnnotationPresent(Produces.class)) {
            throw InjectManager.error(method, L.l("A method may not have both an @Observer and a @Produces annotation."));
        }
        if (method.isAnnotationPresent(Disposes.class)) {
            throw InjectManager.error(method, L.l("A method may not have both an @Observer and a @Disposes annotation."));
        }
        switch (observes.during()) {
            case BEFORE_COMPLETION: {
                observerMethod = new ObserverMethodBeforeCompletionImpl(this._cdiManager, bean, beanMethod, eventType, bindingSet);
                break;
            }
            case AFTER_COMPLETION: {
                observerMethod = new ObserverMethodAfterCompletionImpl(this._cdiManager, bean, beanMethod, eventType, bindingSet);
                break;
            }
            case AFTER_SUCCESS: {
                observerMethod = new ObserverMethodAfterSuccessImpl(this._cdiManager, bean, beanMethod, eventType, bindingSet);
                break;
            }
            case AFTER_FAILURE: {
                observerMethod = new ObserverMethodAfterFailureImpl(this._cdiManager, bean, beanMethod, eventType, bindingSet);
                break;
            }
            default: {
                observerMethod = new ObserverMethodImpl(this._cdiManager, bean, beanMethod, eventType, bindingSet);
            }
        }
        this._cdiManager.addObserver(observerMethod, beanMethod);
    }

    public static <Z> int findObserverAnnotation(AnnotatedMethod<Z> method) {
        List params = method.getParameters();
        int size = params.size();
        int observer = -1;
        for (int i = 0; i < size; ++i) {
            AnnotatedParameter param = (AnnotatedParameter)params.get(i);
            if (!param.isAnnotationPresent(Observes.class)) continue;
            if (observer >= 0 && observer != i) {
                throw InjectManager.error(method.getJavaMember(), L.l("Only one param may have an @Observer"));
            }
            observer = i;
        }
        return observer;
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        for (ObserverMethod<Object> method : this.resolveObserverMethods(event, qualifiers)) {
            method.notify(event);
        }
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        Class<?> eventClass = event.getClass();
        EventKey key = new EventKey(eventClass, qualifiers);
        Set<ObserverMethod<?>> observerList = this._observerMethodCache.get(key);
        if (observerList == null) {
            BaseType eventType = this._cdiManager.createSourceBaseType(event.getClass());
            if (eventType.isGeneric() || eventType instanceof ParamType) {
                throw new IllegalArgumentException(L.l("'{0}' is an invalid event type because it's generic.", (Object)eventType));
            }
            this.validateEventQualifiers(qualifiers);
            observerList = new LinkedHashSet<ObserverMethod<? super T>>();
            this.fillObserverMethodList(observerList, eventType, qualifiers);
            this._observerMethodCache.put(key, observerList);
        }
        return observerList;
    }

    private void validateEventQualifiers(Annotation[] qualifiers) {
        int length = qualifiers.length;
        for (int i = 0; i < length; ++i) {
            Annotation qualifierA = qualifiers[i];
            Class<? extends Annotation> annType = qualifierA.annotationType();
            if (!this._cdiManager.isQualifier(annType)) {
                throw new IllegalArgumentException(L.l("'{0}' is an invalid event annotation because it's not a @Qualifier.", (Object)qualifierA));
            }
            Retention retention = annType.getAnnotation(Retention.class);
            if (retention == null || retention.value() != RetentionPolicy.RUNTIME) {
                throw new IllegalArgumentException(L.l("'{0}' is an invalid event qualifier because it doesn't have RUNTIME retention.", (Object)qualifierA));
            }
            for (int j = i + 1; j < length; ++j) {
                if (qualifierA.annotationType() != qualifiers[j].annotationType()) continue;
                throw new IllegalArgumentException(L.l("fireEvent is invalid because the bindings are duplicate types: {0} and {1}", (Object)qualifiers[i], (Object)qualifiers[j]));
            }
        }
    }

    public void fillObserverMethodList(Set<ObserverMethod<?>> list, BaseType type, Annotation[] qualifiers) {
        if (this._cdiManager.getParent() != null) {
            EventManager parentManager = this._cdiManager.getParent().getEventManager();
            parentManager.fillObserverMethodList(list, type, qualifiers);
        }
        this.fillLocalObserverList(this._observerMap, list, type, qualifiers);
    }

    public void fireExtensionEvent(Object event, Annotation ... qualifiers) {
        this._cdiManager.getExtensionManager().updateExtensions();
        this.fireLocalEvent(this._extObserverMap, event, qualifiers);
    }

    @Module
    public void fireExtensionEvent(Object event, BaseType eventType, Annotation ... qualifiers) {
        this._cdiManager.getExtensionManager().updateExtensions();
        this.fireLocalEvent(this._extObserverMap, event, eventType, qualifiers);
    }

    private void fireLocalEvent(ConcurrentHashMap<Class<?>, ObserverMap> localMap, Object event, Annotation ... bindings) {
        BaseType eventType = this._cdiManager.createTargetBaseType(event.getClass());
        this.fireLocalEvent(localMap, event, eventType, bindings);
    }

    private void fireLocalEvent(ConcurrentHashMap<Class<?>, ObserverMap> localMap, Object event, BaseType eventType, Annotation ... qualifiers) {
        LinkedHashSet observerList = new LinkedHashSet();
        this.fillLocalObserverList(localMap, observerList, eventType, qualifiers);
        for (ObserverMethod observerMethod : observerList) {
            observerMethod.notify(event);
        }
    }

    private void fillLocalObserverList(ConcurrentHashMap<Class<?>, ObserverMap> localMap, Set<ObserverMethod<?>> list, BaseType eventType, Annotation[] qualifiers) {
        for (BaseType type : eventType.getBaseTypeClosure(this._cdiManager)) {
            Class<?> rawClass = type.getRawClass();
            ObserverMap map = localMap.get(rawClass);
            if (map == null) continue;
            map.resolveObservers(list, eventType, qualifiers);
            map.resolveObservers(list, type, qualifiers);
        }
    }

    public void addObserver(ObserverMethod<?> observer) {
        BaseType observedType = this._cdiManager.createTargetBaseType(observer.getObservedType());
        Set qualifierSet = observer.getObservedQualifiers();
        Annotation[] qualifiers = new Annotation[qualifierSet.size()];
        int i = 0;
        for (Annotation qualifier : qualifierSet) {
            qualifiers[i++] = qualifier;
        }
        this.addObserver(observer, observedType, qualifiers);
    }

    public void addObserver(ObserverMethod<?> observer, Type type, Annotation ... bindings) {
        BaseType eventType = this._cdiManager.createTargetBaseType(type);
        this.addObserver(observer, eventType, bindings);
    }

    public void addObserver(ObserverMethod<?> observer, BaseType eventBaseType, Annotation ... bindings) {
        ObserverMap oldMap;
        Class<?> eventType = eventBaseType.getRawClass();
        this._cdiManager.checkActive();
        ObserverMap map = this._observerMap.get(eventType);
        if (map == null && (oldMap = this._observerMap.putIfAbsent(eventType, map = new ObserverMap(eventType))) != null) {
            map = oldMap;
        }
        map.addObserver(observer, eventBaseType, bindings);
        this._observerMethodCache.clear();
    }

    public void addExtensionObserver(ObserverMethod<?> observer, BaseType eventBaseType, Annotation ... bindings) {
        this.addObserver(this._extObserverMap, observer, eventBaseType, bindings);
    }

    private void addObserver(ConcurrentHashMap<Class<?>, ObserverMap> observerMap, ObserverMethod<?> observer, BaseType eventBaseType, Annotation ... bindings) {
        ObserverMap oldMap;
        Class<?> eventType = eventBaseType.getRawClass();
        this._cdiManager.checkActive();
        ObserverMap map = observerMap.get(eventType);
        if (map == null && (oldMap = observerMap.putIfAbsent(eventType, map = new ObserverMap(eventType))) != null) {
            map = oldMap;
        }
        map.addObserver(observer, eventBaseType, bindings);
        this._observerMethodCache.clear();
    }

    public void removeObserver(ObserverMethod<?> observer) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cdiManager + "]";
    }

    static class EventKey {
        private Class<?> _type;
        private Annotation[] _qualifiers;

        EventKey(Class<?> type, Annotation[] qualifiers) {
            this._type = type;
            this._qualifiers = qualifiers;
        }

        public int hashCode() {
            int hash = this._type.hashCode();
            if (this._qualifiers == null) {
                return hash;
            }
            for (Annotation ann : this._qualifiers) {
                hash += 65521 * ann.hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof EventKey)) {
                return false;
            }
            EventKey key = (EventKey)o;
            if (!this._type.equals(key._type)) {
                return false;
            }
            if (this._qualifiers.length != key._qualifiers.length) {
                return false;
            }
            for (int i = 0; i < this._qualifiers.length; ++i) {
                if (this._qualifiers[i] == key._qualifiers[i]) continue;
                return false;
            }
            return true;
        }
    }
}

