/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;

public class LifecycleInterceptor {
    private static final L10N L = new L10N(LifecycleInterceptor.class);
    private Class<? extends Annotation> _annType;
    private ArrayList<Class<?>> _defaultInterceptors = new ArrayList();
    private ArrayList<Class<?>> _classInterceptors = new ArrayList();
    private boolean _isExcludeDefaultInterceptors;
    private boolean _isExcludeClassInterceptors;
    private String _uniqueName;
    private ArrayList<Class<?>> _interceptors = new ArrayList();
    private HashMap<Class<?>, String> _interceptorVarMap = new HashMap();
    private ArrayList<Class<?>> _ownInterceptors = new ArrayList();

    public LifecycleInterceptor(Class<? extends Annotation> annType) {
        this._annType = annType;
    }

    public boolean isEnhanced() {
        return this._interceptors.size() > 0;
    }

    public ArrayList<Class<?>> getInterceptors() {
        return this._interceptors;
    }

    public void introspect(AnnotatedType<?> implClass) {
        Interceptors iAnn = (Interceptors)implClass.getAnnotation(Interceptors.class);
        if (iAnn != null) {
            for (Class iClass : iAnn.value()) {
                this.introspectClass(iClass);
            }
        }
        this._interceptors.addAll(this._classInterceptors);
    }

    private void introspectClass(Class<?> iClass) {
        if (this.findInterceptorMethod(iClass) != null) {
            this._classInterceptors.add(iClass);
        }
    }

    private Method findInterceptorMethod(Class<?> cl) {
        for (Method method : cl.getMethods()) {
            if (!method.isAnnotationPresent(this._annType) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(InvocationContext.class)) continue;
            return method;
        }
        return null;
    }

    public void generatePrologue(JavaWriter out, HashMap map) throws IOException {
        if (this._interceptors.size() == 0) {
            return;
        }
        this._uniqueName = "_v" + out.generateId();
        out.println();
        out.println("private static java.lang.reflect.Method " + this._uniqueName + "_method;");
        out.println("private static java.lang.reflect.Method " + this._uniqueName + "_implMethod;");
        boolean isAroundInvokePrologue = false;
        out.println("private static java.lang.reflect.Method []" + this._uniqueName + "_methodChain;");
        out.println("private transient Object []" + this._uniqueName + "_objectChain;");
        Object cl = null;
        out.println();
        out.println("static {");
        out.pushDepth();
        out.println("try {");
        out.pushDepth();
        this.generateMethodChain(out);
        out.popDepth();
        out.println("} catch (Exception e) {");
        out.println("  throw new RuntimeException(e);");
        out.println("}");
        out.popDepth();
        out.println("}");
        for (Class<?> iClass : this._interceptors) {
            String var = (String)map.get("interceptor-" + iClass.getName());
            if (var == null) {
                var = "__caucho_i" + out.generateId();
                out.println();
                out.print("private static ");
                out.printClass(Bean.class);
                out.println(" " + var + "_f;");
                out.print("private transient ");
                out.printClass(iClass);
                out.println(" " + var + ";");
                map.put("interceptor-" + iClass.getName(), var);
                this._ownInterceptors.add(iClass);
            }
            this._interceptorVarMap.put(iClass, var);
        }
    }

    public void generateConstructor(JavaWriter out, HashMap map) throws IOException {
        for (Class<?> iClass : this._ownInterceptors) {
            String var = this._interceptorVarMap.get(iClass);
            out.println("if (" + var + "_f == null)");
            out.println("  " + var + "_f = com.caucho.webbeans.manager.WebBeansContainer.create().createTransient(" + iClass.getName() + ".class);");
            out.print(var + " = (");
            out.printClass(iClass);
            out.println(")" + var + "_f.get();");
        }
    }

    public void generateCall(JavaWriter out) throws IOException {
        Class[] exnList;
        if (this._interceptors.size() == 0) {
            return;
        }
        out.println("try {");
        out.pushDepth();
        this.generateObjectChain(out);
        out.print("new com.caucho.ejb3.gen.LifecycleInvocationContext(");
        out.print("this, ");
        out.print(this._uniqueName + "_methodChain, ");
        out.println(this._uniqueName + "_objectChain).proceed();");
        out.popDepth();
        out.println("} catch (RuntimeException e) {");
        out.println("  throw e;");
        boolean isException = false;
        for (Class cl : exnList = new Class[0]) {
            if (RuntimeException.class.isAssignableFrom(cl) || !this.isMostGeneralException(exnList, cl)) continue;
            if (cl.isAssignableFrom(Exception.class)) {
                isException = true;
            }
            out.println("} catch (" + cl.getName() + " e) {");
            out.println("  throw e;");
        }
        if (!isException) {
            out.println("} catch (Exception e) {");
            out.println("  throw new RuntimeException(e);");
        }
        out.println("}");
    }

    private boolean isMostGeneralException(Class[] exnList, Class cl) {
        for (Class exn : exnList) {
            if (exn == cl || !exn.isAssignableFrom(cl)) continue;
            return false;
        }
        return true;
    }

    protected void generateMethodChain(JavaWriter out) throws IOException {
        out.println(this._uniqueName + "_methodChain = new java.lang.reflect.Method[] {");
        out.pushDepth();
        for (Class<?> iClass : this._interceptors) {
            Method method = this.findInterceptorMethod(iClass);
            if (method == null) {
                throw new IllegalStateException(L.l("{0}: Can't find {1}", (Object)iClass.getName(), (Object)this._annType.getSimpleName()));
            }
            this.generateGetMethod(out, method);
            out.println(", ");
        }
        out.popDepth();
        out.println("};");
    }

    protected void generateObjectChain(JavaWriter out) throws IOException {
        out.print(this._uniqueName + "_objectChain = new Object[] {");
        for (Class<?> iClass : this._interceptors) {
            out.print(this._interceptorVarMap.get(iClass) + ", ");
        }
        out.println("};");
    }

    protected void generateGetMethod(JavaWriter out, Method method) throws IOException {
        this.generateGetMethod(out, method.getDeclaringClass().getName(), method.getName(), method.getParameterTypes());
    }

    protected void generateGetMethod(JavaWriter out, String className, String methodName, Class[] paramTypes) throws IOException {
        out.print("com.caucho.ejb.util.EjbUtil.getMethod(");
        out.print(className + ".class");
        out.print(", \"" + methodName + "\", new Class[] { ");
        for (Class type : paramTypes) {
            out.printClass(type);
            out.print(".class, ");
        }
        out.print("})");
    }

    protected void printCastClass(JavaWriter out, Class type) throws IOException {
        if (!type.isPrimitive()) {
            out.printClass(type);
        } else if (Boolean.TYPE.equals(type)) {
            out.print("Boolean");
        } else if (Character.TYPE.equals(type)) {
            out.print("Character");
        } else if (Byte.TYPE.equals(type)) {
            out.print("Byte");
        } else if (Short.TYPE.equals(type)) {
            out.print("Short");
        } else if (Integer.TYPE.equals(type)) {
            out.print("Integer");
        } else if (Long.TYPE.equals(type)) {
            out.print("Long");
        } else if (Float.TYPE.equals(type)) {
            out.print("Float");
        } else if (Double.TYPE.equals(type)) {
            out.print("Double");
        } else {
            throw new IllegalStateException(type.getName());
        }
    }
}

