/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;

public class AnnotationType
extends ConfigType {
    protected static final L10N L = new L10N(AnnotationType.class);

    public Class getType() {
        return Annotation.class;
    }

    @Override
    public Object valueOf(String text) {
        return this.parseAnnotation(text);
    }

    private Annotation parseAnnotation(String signature) throws ConfigException {
        int p = signature.indexOf(40);
        String className = p > 0 ? signature.substring(0, p) : signature;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(className, false, loader);
            Annotation ann = (Annotation)cl.newInstance();
            return ann;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

