/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.HessianProtocol;
import com.caucho.ejb.protocol.EjbProtocolManager;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemote;
import com.caucho.services.name.NameServerRemote;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NameContextSkeleton
extends Skeleton {
    private static final L10N L = new L10N(NameContextSkeleton.class);
    private static final Logger log = Logger.getLogger(NameContextSkeleton.class.getName());
    private HessianProtocol _protocol;
    private String _prefix;

    NameContextSkeleton(HessianProtocol protocol, String prefix) {
        this._protocol = protocol;
        this._prefix = prefix;
    }

    @Override
    public void _service(InputStream is, OutputStream os) throws Exception {
        int ch = is.read();
        if (ch != 72) {
            throw new IOException(L.l("expected 'H' for Hessian 2 at '{0}'", (Object)String.valueOf((char)ch)));
        }
        is.read();
        is.read();
        Hessian2Input in = new Hessian2Input(is);
        Hessian2Output out = new Hessian2Output(os);
        in.startCall();
        String method = in.getMethod();
        Object[] args = in.readArguments();
        in.completeCall();
        try {
            if (method.equals("lookup") || method.equals("lookup_string") || method.equals("lookup_1")) {
                this.executeLookup(args, in, out);
            } else if (method.equals("list")) {
                this.executeList(args, in, out);
            } else {
                this.executeUnknown(method, args, in, out);
            }
        }
        catch (HessianProtocolException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), (Object)e);
            out.completeReply();
        }
        out.flush();
    }

    private void executeLookup(Object[] args, Hessian2Input in, Hessian2Output out) throws Throwable {
        String name = (String)args[0];
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractEjbBeanManager<?> server = container.getServerByServerId(name);
        if (server == null) {
            server = container.getServerByEJBName(name);
        }
        if (server != null) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
        if (container.getRemoteChildren(name) != null) {
            String prefix;
            out.startReply();
            String serverId = this._prefix.endsWith("/") || name.startsWith("/") ? this._prefix + name : this._prefix + '/' + name;
            if (serverId.startsWith("/")) {
                serverId = serverId.substring(1);
            }
            String url = (prefix = this._protocol.getURLPrefix()).endsWith("/") ? prefix + serverId : prefix + '/' + serverId;
            out.writeObject((Object)new HessianRemote(NameServerRemote.class.getName(), url));
            out.completeReply();
        } else {
            out.startReply();
            out.writeNull();
            out.completeReply();
        }
    }

    private void executeList(Object[] args, Hessian2Input in, Hessian2Output out) throws Throwable {
        EjbProtocolManager container = this._protocol.getProtocolManager();
        AbstractEjbBeanManager<?> server = container.getServerByEJBName(this._prefix);
        if (server != null) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
        ArrayList<String> children = container.getRemoteChildren(this._prefix);
        if (children != null) {
            out.startReply();
            out.writeObject((Object)children.toArray(new String[children.size()]));
            out.completeReply();
        } else {
            out.startReply();
            out.writeNull();
            out.completeReply();
        }
    }

    protected void executeUnknown(String method, Object[] args, Hessian2Input in, Hessian2Output out) throws Exception {
        if (method.equals("_hessian_getAttribute")) {
            String key = (String)args[0];
            out.startReply();
            if ("java.api.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("java.home.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("java.object.class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("home-class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else if ("remote-class".equals(key)) {
                out.writeString(NameServerRemote.class.getName());
            } else {
                out.writeNull();
            }
            out.completeReply();
        } else {
            out.startReply();
            out.writeFault("NoMethod", "no such method: " + method, null);
            out.completeReply();
        }
    }
}

